<?php
	include("includes/dbconfig.php");
	$pagetitle = "Cash Sales Register";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Cash Sales</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default box -->
					<div class="row">
						<div class="col-md-12">
							<div id="servererrormessage">
							</div>
						</div>
					</div>
					
					<div class="row" id="searchitemarea" style="display:none;">
						<div class="col-md-12">
							<?php
								$pricedata = DB::query("SELECT item_price.id, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, item_batch.batch_code, stock_item.item_image_file, item_price.item, item_price.batch, item_price.cost_price, item_price.sell_price, item_price.version FROM item_price INNER JOIN stock_item ON item_price.item = stock_item.id INNER JOIN item_stock_level ON item_price.item = item_stock_level.item AND item_price.shop = item_stock_level.shop AND item_stock_level.is_active = 1 AND IF(item_price.batch IS NULL , item_stock_level.batch IS NULL , item_stock_level.batch = item_price.batch) LEFT JOIN item_batch ON item_price.batch = item_batch.id LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_price.sell_price > 0 AND item_price.shop=%i ORDER BY item_category.category_name", $_SESSION["connecteduserbranch"]);
							?>
							<div class="box box-default">
								<div class="box-body">
									<div class="box-body table-responsive no-padding">
										<div class="box-body table-responsive">
											<table id="stockitemstable" class="table table-striped">
												<thead>
													<tr>
														<th>Image</th>
														<th>Name</th>
														<th>Category</th>
														<th>Code</th>
														<th>Barcode</th>
														<th>Batch</th>
														<th class="text-right">Sell Price</th>
														<th class="text-center">Actions</th>
													</tr>
												</thead>
												<tfoot>
													<tr>
														<th>Image</th>
														<th>Name</th>
														<th>Category</th>
														<th>Code</th>
														<th>Barcode</th>
														<th>Batch</th>
														<th class="text-right">Sell Price</th>
														<th class="text-center">Actions</th>
													</tr>
												</tfoot>
												<tbody>
													<?php
														foreach($pricedata as $row)
														{
													?>
													<tr>
														<td style="width: 6%">
															<img class="img-thumbnail" id="logo" src="<?php echo ($row['item_image_file'] != "") ? "images/stockitemimage/" . $row['item_image_file'] : "images/stockitemimage/noimage.gif" ?>" alt="..." style="width: 100%;max-height: 100%">
														</td>
														<td style="vertical-align:middle;"><?php echo $row['item_name']; ?></td>
														<td style="vertical-align:middle;"><?php echo $row['category_name']; ?></td>
														<td style="vertical-align:middle;"><?php echo $row['item_code']; ?></td>
														<td style="vertical-align:middle;"><?php echo $row['bar_code']; ?></td>
														<td style="vertical-align:middle;"><?php echo $row['batch_code']; ?></td>
														<td style="vertical-align:middle;" class="text-right"><?php echo number_format($row['sell_price'], 2); ?></td>
														<td style="vertical-align:middle;" class="text-center">
															<a href="javascript:void(0);" onclick="addtocart(<?php echo $row['id'].', \''.addslashes($row['item_name']).'\', \''.number_format($row['sell_price'], 2).'\''; ?>)" data-toggle="tooltip" title="Add Item To Cart" class="tooltips"><span class="label label-primary" ><i class="glyphicon glyphicon-plus"></i></span></a>
														</td>
													</tr>
													<?php
														}
													?>
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					
					<div class="row">
						<div class="col-md-8">
							<div class="box box-primary" id="saledetails" style="height: 450px;">
								<div class="box-body">
									<div class="row">
										<div class="form-group col-sm-8">
											<input type="text" name="itemcode" id="itemcode" class="form-control" placeholder="Scan Item Barcode" >
										</div><!-- form-group -->
										<div class="form-group col-sm-4">
											<button id="searchitembtn" onclick="showorhideitemsearch()" class="btn btn-primary"><i class="glyphicon glyphicon-search"></i> Open Item Search</button>
										</div>
									</div>
									
									<div>
										<div id="cartitemslist">
											<table class="table table-hover"  id="cartitemstable">
												<thead>
													<tr>
														<th style="display:none;"></th>
														<th>Name</th>
														<th class="text-right">Price</th>
														<th class="text-right">Quantity</th>
														<th class="text-right">Total</th>
														<th class="text-right">Action</th>
													</tr>
												</thead>
												<tbody>
													
												</tbody>
											</table>
										</div>
									</div>
								</div><!-- /.box-body -->
							</div><!-- /.box -->
						</div>
						
						<div class="col-md-4">
							<div class="box box-success" id="salesummary" style="height: 450px;">
								<div class="box-body">
									<div class="form-group col-md-12">
										<input type="text" name="clientname" id="clientname" maxlength="100" class="form-control" placeholder="Enter Customer Name" >
									</div><!-- form-group -->
									
									<label class="col-md-6">Items Count</label><i class="col-md-6" id="itemscount"><b>0</b></i>
									
									<div class="col-md-12" style="margin-top: 25px"></div>
									
									<label class="col-md-6">Amount Due</label><i class="col-md-6" id="cost"><b>0 UGX</b></i>
									
									<div class="col-md-12" style="margin-top: 25px"></div>
									
									<div class="form-group col-md-12">
										<label for="cashpaidin">Paid Amount</label>
										<input type="text" name="cashpaidin" id="cashpaidin" maxlength="100" class="form-control" onfocus="this.select();" onmouseup="return false;">
									</div><!-- form-group -->
									
									<label class="col-md-6">Customer Balance</label><i class="col-md-6" id="clientbalance"><b>0 UGX</b></i>
									
									<div class="col-md-12" style="margin-top: 25px"></div>
									
									<div class="form-group col-md-12">
										<textarea name="memo" id="memo" rows="3" placeholder="Additional Notes ..." maxlength="100" class="form-control"></textarea>
									</div><!-- form-group -->
									
									<div class="btn-list col-md-12 text-center">
										<button onclick="cancelsale()" class="btn btn-danger"><i class="glyphicon glyphicon-remove"></i> Cancel Sale</button>
										
										<button onclick="processcashsale()" class="btn btn-success"><i class="glyphicon glyphicon-floppy-disk"></i> Process Sale</button>
									</div>
							
								</div><!-- /.box-body -->
							</div><!-- /.box -->
						</div>
					</div>
					
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> StorePOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<!-- jQuery 2.1.3 -->
		<script src="plugins/jQuery/jQuery-2.1.3.min.js"></script>
		<!-- Bootstrap 3.3.2 JS -->
		<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
		<!-- FastClick -->
		<script src='plugins/fastclick/fastclick.min.js'></script>
		<!-- DATA TABES SCRIPT -->
		<script src="plugins/datatables/jquery.dataTables.js" type="text/javascript"></script>
		<script src="plugins/datatables/dataTables.bootstrap.js" type="text/javascript"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		
		<script src="plugins/bert/jquery.price_format.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/cashsalesregister.js" type="text/javascript"></script>
	</body>
</html>