<?php
	include("includes/dbconfig.php");
	$pagetitle = "Category";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Manage Category</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
					<?php
						if($_SESSION["connectedusergroup"] == 1)
						{
					?>
						<div class="card-header with-border text-center">
							<h3 class="card-title">Item Category List</h3>
						</div>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							<div class="card-body table-responsive no-padding">
								<div class="col-sm-12">
									<div class="input-group-btn">
										<button onclick="categorysetup(0, 0)" class="btn btn-sm btn-primary pull-right"><i class="fa fa-plus"></i> Add Item Category</button>
									</div>
								</div>
								
								<div class="col-md-12" style="margin-top: 25px"></div>
										
								<table id="example1"   class="table table-bordered table-striped">
									<thead>
										<tr>
											<th>Category Name</th>
											<th>Description</th>
											<th class="text-center">Action</th>
										</tr>
									</thead>
									<tfoot>
										<tr>
											<th>Category Name</th>
											<th>Description</th>
											<th class="text-center">Action</th>
										</tr>
									</tfoot>
									<tbody>
										<?php
											$itemcategorydata = DB::query("SELECT id, category_name, category_description, version FROM item_category ORDER BY category_name");

											if(DB::count() > 0)
											{
												foreach($itemcategorydata as $itemcategory)
												{
													$action = '<a href="javascript:void(0);" onclick="categorysetup('.$itemcategory['id'].', '.$itemcategory['version'].')" data-toggle="tooltip" title="Edit Item Category" class="tooltips"><span class="label label-primary" ><i class="fa fa-edit"></i></span></a> <a href="javascript:void(0);" onclick="categorydelete('.$itemcategory['id'].', '.$itemcategory['version'].')" data-toggle="tooltip" title="Delete Item Category" class="tooltips"><span class="label label-danger" ><i class="fa fa-trash"></i></span></a>';
										?>
										<tr>
											<td><?php echo $itemcategory['category_name']; ?></td>
											<td><a href="javascript:void(0);" onclick="" data-toggle="tooltip" title="<?php echo $itemcategory['category_description']; ?>" class="tooltips"><?php echo substr($itemcategory['category_description'], 0, 100); ?></a></td>
											<td class="text-center"><?php echo $action; ?></td>
										</tr>
										<?php
												}
											}
										?>
									</tbody>
								</table>
							</div>
						</div><!-- /.card-body -->
						<div class="card-footer">
							
						</div><!-- /.card-footer-->
					<?php
						}
						else
						{
					?>
					<div class="alert alert-danger alert-dismissable">
						<i class="fa fa-ban-circle"></i>
						Limited Access
					</div>
					<?php
						}
					?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="mediummodaldetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>
<?php include ('includes/general_footer.php')?>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/category.js" type="text/javascript"></script>
	</body>
</html>