<?php
	include("includes/dbconfig.php");
	$pagetitle = "GL Account Defination";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$successsave="";
	
	if(isset($_POST['glaccountfocus']))
	{
		$glaccountfocus = $_POST['glaccountfocus'];
	}
	
	if(!isset($_POST['savedatabtn']))
	{
		if(isset($glaccountfocus) && $glaccountfocus > 0)
		{
			$results = DB::queryFirstRow("SELECT account_code, account_name, account_class, currency, version FROM gl_chartmaster WHERE id=%i LIMIT 1", $glaccountfocus);
			if(DB::count()==1)
			{
				$_POST['glaccountfocus'] = $glaccountfocus;
				$_POST['accountcode'] = $results['account_code'];
				$_POST['accountname'] = $results['account_name'];
				$_POST['accountclass'] = $results['account_class'];
				$_POST['recversion'] = $results['version'];
			}
		}
	}
	
	if(isset($_POST['savedatabtn']))
	{
		if($_SESSION["connectedusergroup"] == 1)
		{
			if(trim($_POST['accountcode'])=="")
			{
				$err = $err."GL Account Number Required!<br>";
			}
			else
			{
				if($_POST['glaccountfocus'] == 0)
				{
					DB::query("SELECT id FROM gl_chartmaster WHERE account_code=%s", trim($_POST['accountcode']));
			
					if(DB::count() > 0)
					{
						$err = $err."GL Account Number Already Exists!<br>";
					}
				}
				else
				{
					DB::query("SELECT id FROM gl_chartmaster WHERE account_code=%s AND id!=%i", trim($_POST['accountcode']), $_POST['glaccountfocus']);
			
					if(DB::count() > 0)
					{
						$err = $err."GL Account Number Already Exists!<br>";
					}
				}
			}
		
			if(trim($_POST['accountname'])=="")
			{
				$err = $err."GL Account Name Required!<br>";
			}
			else
			{
				if($_POST['glaccountfocus'] == 0)
				{
					DB::query("SELECT id FROM gl_chartmaster WHERE account_name=%s", trim($_POST['accountname']));
			
					if(DB::count() > 0)
					{
						$err = $err."GL Account Name Already Exists!<br>";
					}
				}
				else
				{
					DB::query("SELECT id FROM gl_chartmaster WHERE account_name=%s AND id!=%i", trim($_POST['accountname']), $_POST['glaccountfocus']);
			
					if(DB::count() > 0)
					{
						$err = $err."GL Account Name Already Exists!<br>";
					}
				}
			}
			
			if($_POST['accountclass']=="")
				$err = $err."GL Account Type Required!<br>";
				
			if($err == "")
			{
				DB::$error_handler = false;
				DB::$throw_exception_on_error = true;
			
				if($_POST['glaccountfocus'] == 0)
				{
					try
					{
						DB::startTransaction();
						DB::query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
						
						DB::insert
						('gl_chartmaster', 
							array
							(
								'created_date' => date("Y-m-d H:i:s"),
								'created_by' => $_SESSION["connecteduserid"],
								'account_code' => trim($_POST['accountcode']),
								'account_name' => trim($_POST['accountname']),
								'account_class' => $_POST['accountclass']
							)
						);
						
						DB::commit();

						$successsave="New GL Account Successfully Added.";
						unset($_POST['glaccountfocus']); 
						unset($_POST['accountcode']);
						unset($_POST['accountname']);
						unset($_POST['accountclass']);
						unset($_POST['recversion']);
					}
					catch(MeekroDBException $e)
					{
						$err = $err."Critical Error Occured!<br>";
						$err = $err.$e->getMessage()."<br>";
						$err = $err.$e->getQuery()."<br>";
						DB::rollback();
						DB::$error_handler = 'meekrodb_error_handler';
						DB::$throw_exception_on_error = false;
					}
				}
				else
				{
					try
					{
						$trxnConnextn = new MeekroDB();
						$nonTrxnConnextn = new MeekroDB();
					
						$trxnConnextn->startTransaction();
						$trxnConnextn->query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
						$trxnConnextn->query("SELECT * FROM gl_chartmaster WHERE id=%i FOR UPDATE", $_POST['glaccountfocus']);
					
						$trxnConnextn->update
						('gl_chartmaster', 
							array
							(
								'updated_date' => date("Y-m-d H:i:s"),
								'updated_by' => $_SESSION["connecteduserid"],
								'account_code' => trim($_POST['accountcode']),
								'account_name' => trim($_POST['accountname']),
								'account_class' => $_POST['accountclass'],
								'version' => ($_POST['recversion'] + 1)
							), 
							"id=%i", $_POST['glaccountfocus']
						);
					
						$row = $nonTrxnConnextn->queryFirstRow("SELECT version FROM gl_chartmaster WHERE id=%i LIMIT 1", $_POST['glaccountfocus']);
					
						if($row['version'] == $_POST['recversion'])
						{
							$trxnConnextn->commit(); 						
?>
							<script>
								location.href="glaccountsview.php";
							</script>
<?php
							exit();
						}
						else
						{
							$trxnConnextn->rollback();
							$err = "GL Account Details Could Not Be Updated Due To Updates Just Done By Another System User!<br>";
						}
					}
					catch(MeekroDBException $e)
					{
						$err = $err."Critical Error Occured!<br>";
						$err = $err.$e->getMessage()."<br>";
						$err = $err.$e->getQuery()."<br>";
						$trxnConnextn->rollback();
						DB::$error_handler = 'meekrodb_error_handler';
						DB::$throw_exception_on_error = false;
					}
				}
				
			}
		}
		else
		{
			$err = $err."Limited Acccess!<br>";
		}
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>GL Account Defination</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default box -->
					<div class="box box-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="box-header with-border text-center">
							<h3 class="box-title">GL Account Form</h3>
						</div>
						
						<div class="box-body">
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="glyphicon glyphicon-ban-circle"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<?php
								if($successsave!="")
								{
							?>
							<div class="alert alert-success alert-dismissable">
								<i class="glyphicon glyphicon-ok"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
								<?php 
									echo $successsave; 
								?>
							</div>
							<?php
								}
							?>
							<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
								<INPUT name="glaccountfocus" id="glaccountfocus" type=hidden value="<?php echo isset($_POST['glaccountfocus']) ? $_POST['glaccountfocus'] : 0 ?>">
								<INPUT name="recversion" id="recversion" type=hidden value="<?php echo isset($_POST['recversion']) ? $_POST['recversion'] : 0 ?>">
								<div class="form-group">
									<label for="accountcode">GL Account Number</label>
									<input type="text" name="accountcode" id="accountcode" maxlength="20" class="form-control" value="<?php echo isset($_POST['accountcode']) ? $_POST['accountcode'] : "" ?>" >
								</div><!-- form-group -->
								
								<div class="form-group">
									<label for="accountname">GL Account Name</label>
									<input type="text" name="accountname" id="accountname" maxlength="80" class="form-control" value="<?php echo isset($_POST['accountname']) ? $_POST['accountname'] : "" ?>" >
								</div><!-- form-group -->
								
								<div class="form-group">
									<label for="accountclass">GL Account Type</label>
									<select  class="form-control" name="accountclass" id="accountclass" data-placeholder="Choose One">
										<option value="">Choose One</option>
										<?php
											$accountclassdata = DB::query("SELECT id, gl_class_name FROM gl_class");
											
											foreach ($accountclassdata as $accountclass)
											{
										?>
										<option <?php if(isset($_POST['accountclass']) && $accountclass['id']==$_POST['accountclass']) echo "selected=\"selected\""; ?> value="<?php echo $accountclass['id']; ?>"><?php echo $accountclass['gl_class_name']; ?></option>
										<?php
											}
										?>
									</select>
								</div><!-- form-group -->
						</div><!-- /.box-body -->
						
						<div class="box-footer">
							<div class="btn-list">
								<div class="text-right">
									<a href="glaccountsview.php" class="btn btn-danger"><i class="glyphicon glyphicon-remove"></i> Cancel</a>
									
									<button type="submit" name="savedatabtn" id="savedatabtn" class="btn btn-success"><i class="glyphicon glyphicon-floppy-disk"></i> Save</button>
								</div>
							</div>
						</div><!-- /.box-footer-->
							</form>
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="glyphicon glyphicon-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.box -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->

		<!-- jQuery 2.1.3 -->
		<script src="plugins/jQuery/jQuery-2.1.3.min.js"></script>
		<!-- Bootstrap 3.3.2 JS -->
		<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
		<!-- FastClick -->
		<script src='plugins/fastclick/fastclick.min.js'></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/jquery.price_format.min.js" type="text/javascript"></script>
	</body>
</html>