<?php
	include("includes/dbconfig.php");
	$pagetitle = "Income Expense View";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$startdatevalid = false;
	
	$balancescount = 0;

	if(isset($_POST['gettrxnsbtn']))
	{	
		if($_SESSION["connectedusergroup"] == 1)
		{
			if(trim($_POST['from'])=="")
			{
				$err = $err."Start Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['from'], 0, 2);
				$day = substr($_POST['from'], 3, 2);
				$year = substr($_POST['from'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid Start Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d"))
					{
						$err = $err."Future Start Date Not Supported.<br>";
					}
					else
					{
						$startdatevalid = true;
					}
				}
			}
			
			if(trim($_POST['to'])=="")
			{
				$err = $err."End Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['to'], 0, 2);
				$day = substr($_POST['to'], 3, 2);
				$year = substr($_POST['to'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid End Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['to']))) > date("Y-m-d"))
					{
						$err = $err."Future End Date Not Supported.<br>";
					}
					else
					{
						if($startdatevalid)
						{
							if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d", strtotime(trim($_POST['to']))))
							{
								$err = $err."Start Date Can Not Be Greater Than The End Date.<br>";
							}
							else
							{
								$incomebalancesdata = DB::query("SELECT gl_chartmaster.account_name, gl_chartmaster.account_code, IF(SUM(gl_gltrxn.trxn_amount) > 0, SUM(gl_gltrxn.trxn_amount), (SUM(gl_gltrxn.trxn_amount) * -1)) AS balance, SUM(gl_gltrxn.trxn_amount) AS pure_balance FROM gl_gltrxn, gl_chartmaster WHERE gl_gltrxn.value_date>=%s AND gl_gltrxn.value_date<=%s AND gl_gltrxn.chartmaster = gl_chartmaster.id AND gl_chartmaster.account_class = 4 GROUP BY gl_gltrxn.chartmaster ORDER BY gl_chartmaster.account_code", date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
								
								$balancescount = DB::count();
								
								$expensebalancesdata = DB::query("SELECT gl_chartmaster.account_name, gl_chartmaster.account_code, IF(SUM(gl_gltrxn.trxn_amount) > 0, SUM(gl_gltrxn.trxn_amount), (SUM(gl_gltrxn.trxn_amount) * -1)) AS balance, SUM(gl_gltrxn.trxn_amount) AS pure_balance FROM gl_gltrxn, gl_chartmaster WHERE gl_gltrxn.value_date>=%s AND gl_gltrxn.value_date<=%s AND gl_gltrxn.chartmaster = gl_chartmaster.id AND gl_chartmaster.account_class = 5 GROUP BY gl_gltrxn.chartmaster ORDER BY gl_chartmaster.account_code", date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
								
								$balancescount += DB::count();
								
								if($balancescount == 0)
									$err = $err."No GL Income - Expense Entries Found!<br>";
								
							}
						}
					}
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}

	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Income Expense View</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default box -->
					<div class="box box-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="box-header with-border text-center">
							<h3 class="box-title">Income Expense List</h3>
						</div>
						
						<div class="box-body">
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="glyphicon glyphicon-ban-circle"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<div id="servererrormessage">
							</div>
							
							<div class="box-body table-responsive no-padding">
								<div class="col-sm-12">
									<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
										<div class="form-group col-sm-3">
										</div><!-- form-group -->
										
										<div class="form-group col-sm-3">
											<label for="from">Start Date</label>
											<input type="text" value="<?php echo isset($_POST['from']) ? $_POST['from'] : "" ?>" name="from" id="from" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
										</div><!-- form-group -->
										
										<div class="form-group col-sm-3">
											<label for="to">End Date</label>
											<div class="input-group">
												<input type="text" value="<?php echo isset($_POST['to']) ? $_POST['to'] : "" ?>" name="to" id="to" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
												<span class="input-group-btn">
													<button class="btn btn-primary btn-flat" type="submit" name="gettrxnsbtn" id="gettrxnsbtn">Go!</button>
												</span>
											</div>
										</div><!-- form-group -->
										
										<div class="form-group col-sm-3">
										</div><!-- form-group -->
									</form>									
								</div>
								
								<div class="col-md-12" style="margin-top: 25px"></div>
								
								<table class="table table-hover">
									<thead>
										<tr>
											<th>Account Class</th>
											<th>Account Name</th>
											<th>Account Code</th>
											<th class="text-right">Account Balance</th>
											<th class="text-right">Class Balance</th>
											<th class="text-right">Profit/Loss</th>
										</tr>
									</thead>
									<tbody>
										<?php
											if($balancescount > 0)
											{
												$totalrevenue = 0;
												$totalexpense = 0;
										?>
										<tr>
											<td>Revenue</td>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
										</tr>
										<?php
												foreach($incomebalancesdata as $incomebalance)
												{
													$totalrevenue += $incomebalance['pure_balance'];
										?>
										<tr>
											<td></td>
											<td><?php echo $incomebalance['account_name']; ?></td>
											<td><?php echo $incomebalance['account_code']; ?></td>
											<td class="text-right"><?php echo ($incomebalance['pure_balance'] < 0) ? number_format($incomebalance['balance'], 2) . " Cr" : number_format($incomebalance['balance'], 2) . " Dr"; ?></td>
											<td></td>
											<td></td>
										</tr>
										<?php
												}
										?>
										<tr>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
											<td class="text-right"><b><?php echo ($totalrevenue < 0) ? number_format(($totalrevenue * -1), 2) . " Cr" : number_format($totalrevenue, 2) . " Dr"; ?></b></td>
											<td></td>
										</tr>
										<tr>
											<td>Expenses</td>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
										</tr>
										<?php
												foreach($expensebalancesdata as $expensebalance)
												{
													$totalexpense += $expensebalance['pure_balance'];
										?>
										<tr>
											<td></td>
											<td><?php echo $expensebalance['account_name']; ?></td>
											<td><?php echo $expensebalance['account_code']; ?></td>
											<td class="text-right"><?php echo ($expensebalance['pure_balance'] < 0) ? number_format($expensebalance['balance'], 2) . " Cr" : number_format($expensebalance['balance'], 2) . " Dr"; ?></td>
											<td></td>
											<td></td>
										</tr>
										<?php
												}
										?>
										<tr>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
											<td class="text-right"><b><?php echo ($totalexpense < 0) ? number_format(($totalexpense * -1), 2) . " Cr" : number_format($totalexpense, 2) . " Dr"; ?></b></td>
											<td></td>
										</tr>
										
										<tr>
											<td></td>
											<td><b><?php echo (($totalrevenue + $totalexpense) < 0) ? "Profit" : "Loss"; ?></b></td>
											<td></td>
											<td></td>
											<td></td>
											<td class="text-right"><b><?php echo (($totalrevenue + $totalexpense) < 0) ? number_format((($totalrevenue + $totalexpense) * -1), 2) . " Cr" : number_format(($totalrevenue + $totalexpense), 2) . " Dr"; ?></b></td>
										</tr>
										<?php
											}
										?>
									</tbody>
								</table>
							</div><!-- /.box-body -->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="glyphicon glyphicon-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.box -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->

		<!-- jQuery 2.1.3 -->
		<script src="plugins/jQuery/jQuery-2.1.3.min.js"></script>
		<!-- Bootstrap 3.3.2 JS -->
		<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
		<!-- InputMask -->
		<script src="plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.extensions.js" type="text/javascript"></script>
		<!-- FastClick -->
		<script src='plugins/fastclick/fastclick.min.js'></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		
		<script type="text/javascript">
			$(function() 
			{
				//Datemask2 mm/dd/yyyy
				$("#datemask2").inputmask("mm/dd/yyyy", {"placeholder": "mm/dd/yyyy"});
				//Money Euro
				$("[data-mask]").inputmask();
				
				$("#from").focus();
			});
		</script>
	</body>
</html>