<?php
	header('Content-Type: application/json');
	include("includes/dbconfig.php");
	
	session_write_close();
	
	$err = "";
	
	$server_response = array();
	
	$tag = $_POST['tag'];
	$tagname = trim($_POST['tagname']);
	$recversion = $_POST['recversion'];
	
	if(isset($_SESSION['connecteduserid']))
	{
		if($_SESSION["connectedusergroup"] == 1)
		{
			if($tagname == "")
			{
				$err = $err."Tag Name Required!<br>";
			}
			else
			{
				if($tag > 0)
				{
					$tagdata = DB::queryFirstRow("SELECT tag_name FROM gl_tag WHERE id=%i ", $tag);
					
					if(DB::count() == 1)
					{
						DB::queryFirstRow("SELECT id FROM gl_tag WHERE tag_name=%s AND id!=%i", $tagname, $tag);
					
						if(DB::count() > 0)
							$err = $err."Tag Name Already Exists!<br>";
					}
					else
					{
						$err = $err."Tag Can Not Be Identified!<br>";
					}
				}
				else
				{
					DB::queryFirstRow("SELECT id FROM gl_tag WHERE tag_name=%s", $tagname);
					
					if(DB::count() > 0)
						$err = $err."Tag Name Already Exists!<br>";
				}

			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
	else
	{
		$err = $err."Un Authenticated User Access Detected!<br>";
	}
	
	if($err == "")
	{
		if($tag == 0)
		{
			try
			{
				DB::startTransaction();
				DB::query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
				DB::insert
				('gl_tag', 
					array
					(
						'created_date' => date("Y-m-d H:i:s"),
						'created_by' => $_SESSION["connecteduserid"],
						'tag_name' => $tagname
					)
				);
				
				DB::commit();
				
				$server_response[] = array('issaved' => 1, 'message' => "GL Tag Successfully Added.");
				echo json_encode($server_response);
			}
			catch(Exception $e)
			{
				$server_response[] = array('issaved' => 0, 'message' => "GL Tag Save Error Occured. Try Again");
				echo json_encode($server_response);
				exit();
			}
		}
		else
		{
			try
			{
				$trxnConnextn = new MeekroDB();
				$nonTrxnConnextn = new MeekroDB();
				
				$trxnConnextn->startTransaction();
				$trxnConnextn->query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
				$trxnConnextn->query("SELECT * FROM gl_tag WHERE id=%i FOR UPDATE", $tag);
				
				$trxnConnextn->update
				('gl_tag', 
					array
					(
						'updated_date' => date("Y-m-d H:i:s"),
						'updated_by' => $_SESSION["connecteduserid"],
						'tag_name' => $tagname,
						'version' => ($recversion + 1)
					), 
					"id=%i", $tag
				);
				
				$row = $nonTrxnConnextn->queryFirstRow("SELECT version FROM gl_tag WHERE id=%i LIMIT 1", $tag);
				
				if($row['version'] == $recversion)
				{
					$trxnConnextn->commit();
					
					$server_response[] = array('issaved' => 1, 'message' => "GL Tag Successfully Updated.");
					echo json_encode($server_response);
				}
				else
				{
					$trxnConnextn->rollback();
					$server_response[] = array('issaved' => 0, 'message' => "GL Tag Details Could Not Be Updated Due To Updates Just Done By Another System User.");
					echo json_encode($server_response);
				}
			}
			catch(Exception $e)
			{
				$server_response[] = array('issaved' => 0, 'message' => "GL Tag Update Error Occured. Try Again");
				echo json_encode($server_response);
				exit();
			}
		}
	}
	else
	{
		$server_response[] = array('issaved' => 0, 'message' => $err);
		echo json_encode($server_response);
	}
?>