<?php
	include("includes/dbconfig.php");
	$pagetitle = "GL Tags View";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>GL Tags View</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default box -->
					<div class="box box-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="box-header with-border text-center">
							<h3 class="box-title">GL Tags View</h3>
						</div>
						
						<div class="box-body">
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="glyphicon glyphicon-ban-circle"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<div id="servererrormessage">
							</div>
							
							<div class="box-body table-responsive no-padding">
								<div class="col-sm-12">
									<div class="input-group-btn">
										<button onclick="tagsetup(0, 0)" class="btn btn-sm btn-primary pull-right"><i class="fa fa-tags"></i> Add GL Tag</button>
									</div>
								</div>
								
								<div class="col-md-12" style="margin-top: 25px"></div>
								
								<div class="col-md-2"></div>
								
								<div class="col-md-8">
									<table class="table table-hover">
										<thead>
											<tr>
												<th>GL Tag Name</th>
												<th class="text-center">Action</th>
											</tr>
										</thead>
										<?php
											$gltagdata = DB::query("SELECT id, tag_name, version FROM gl_tag ORDER BY tag_name");

											if(DB::count() > 0)
											{
												foreach($gltagdata as $gltag)
												{
										?>
										<tr>
											<td><?php echo $gltag['tag_name']; ?></td>
											<td class="text-center">
												<a href="javascript:void(0);" onclick="tagsetup(<?php echo $gltag['id']; ?>, <?php echo $gltag['version']; ?>)" data-toggle="tooltip" title="Edit GL Tag" class="tooltips"><span class="label label-primary" ><i class="glyphicon glyphicon-edit"></i></span></a>&nbsp;&nbsp;
												<a href="javascript:void(0);" onclick="deletetag(<?php echo $gltag['id']; ?>, <?php echo $gltag['version']; ?>)" data-toggle="tooltip" title="Delete GL Tag" class="tooltips"><span class="label label-danger" ><i class="glyphicon glyphicon-trash"></i></span></a>
											</td>
										</tr>
										<?php
												}
											}
										?>
									</table>
								</div>
								
								<div class="col-md-2"></div>
								
							</div><!-- /.box-body -->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="glyphicon glyphicon-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.box -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->
		
		<div class="modal" id="tagmodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="tagdetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- jQuery 2.1.3 -->
		<script src="plugins/jQuery/jQuery-2.1.3.min.js"></script>
		<!-- Bootstrap 3.3.2 JS -->
		<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
		<!-- FastClick -->
		<script src='plugins/fastclick/fastclick.min.js'></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/jquery.price_format.min.js" type="text/javascript"></script>
		<script src="plugins/bert/gltagsview.js" type="text/javascript"></script>
	</body>
</html>