<?php
	include("includes/dbconfig.php");
	$pagetitle = "GL Trial Balance View";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$startdatevalid = false;
	
	$balancescount = 0;

	if(isset($_POST['getbalancesbtn']))
	{	
		if($_SESSION["connectedusergroup"] == 1)
		{
			if(trim($_POST['asat'])=="")
			{
				$err = $err."Trial Balance Report As At Required!<br>";
			}
			else
			{
				$month = substr($_POST['asat'], 0, 2);
				$day = substr($_POST['asat'], 3, 2);
				$year = substr($_POST['asat'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['asat']))) > date("Y-m-d"))
					{
						$err = $err."Future End Date Not Supported.<br>";
					}
					else
					{
						$balancesdata = DB::query("SELECT gl_chartmaster.account_name, gl_chartmaster.account_code, gl_class.gl_class_name, IF(SUM(gl_gltrxn.trxn_amount) > 0, SUM(gl_gltrxn.trxn_amount), 0.00) AS debit, IF(SUM(gl_gltrxn.trxn_amount) < 0, (SUM(gl_gltrxn.trxn_amount) * -1), 0.00) AS credit FROM gl_gltrxn, gl_chartmaster, gl_class WHERE gl_gltrxn.value_date<=%s AND gl_gltrxn.chartmaster = gl_chartmaster.id AND gl_chartmaster.account_class = gl_class.id AND gl_chartmaster.currency=%i GROUP BY gl_gltrxn.chartmaster ORDER BY gl_class.id", date("Y-m-d H:i:s", strtotime(trim($_POST['asat'] . " 23:59:00"))));
					
						$balancescount = DB::count();
						
						if($balancescount == 0)
							$err = $err."No Balances Found Upto The Selected Date!<br>";
					}
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}

	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>GL Trial Balance View</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default box -->
					<div class="box box-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="box-header with-border text-center">
							<h3 class="box-title">GL Balances List</h3>
						</div>
						
						<div class="box-body">
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="glyphicon glyphicon-ban-circle"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<div id="servererrormessage">
							</div>
							
							<div class="box-body table-responsive no-padding">
								<div class="col-sm-12">
									<form action="gltrialbalanceview.php" method="post">
										<div class="form-group col-sm-4">
											
										</div><!-- form-group -->
										
										<div class="form-group col-sm-4">
											<label for="asat">Trial Balance View As At</label>
											<div class="input-group">
												<input type="text" value="<?php echo isset($_POST['asat']) ? $_POST['asat'] : "" ?>" name="asat" id="asat" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
												<span class="input-group-btn">
													<button class="btn btn-primary btn-flat" type="submit" name="getbalancesbtn" id="getbalancesbtn">Go!</button>
												</span>
											</div>
										</div><!-- form-group -->
										
										<div class="form-group col-sm-4">
											
										</div><!-- form-group -->
									</form>
									
								</div>
								
								<div class="col-md-12" style="margin-top: 25px"></div>
								
								<table class="table table-hover">
									<thead>
										<tr>
											<th>GL Account Name</th>
											<th>Account Code</th>
											<th>Account Class</th>
											<th class="text-right">Debit</th>
											<th class="text-right">Credit</th>
										</tr>
									</thead>
									<tbody>
										<?php
											if($balancescount > 0)
											{
												$debitbalance = 0;
												$creitbalance = 0;
										
												foreach($balancesdata as $balance)
												{
													$debitbalance += $balance['debit'];
													$creitbalance += $balance['credit'];
										?>
										<tr>
											<td><?php echo $balance['account_name']; ?></td>
											<td><?php echo $balance['account_code']; ?></td>
											<td><?php echo $balance['gl_class_name']; ?></td>
											<td class="text-right"><?php echo number_format($balance['debit'], 2); ?></td>
											<td class="text-right"><?php echo number_format($balance['credit'], 2); ?></td>
										</tr>
										<?php
												}
										?>
										<tr>
											<td></td>
											<td></td>
											<td></td>
											<td class="text-right"><b><?php echo number_format($debitbalance, 2); ?></b></td>
											<td class="text-right"><b><?php echo number_format($creitbalance, 2); ?></b></td>
										</tr>
										<?php	
											}
										?>
									</tbody>
								</table>
							</div><!-- /.box-body -->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="glyphicon glyphicon-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.box -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->

		<!-- jQuery 2.1.3 -->
		<script src="plugins/jQuery/jQuery-2.1.3.min.js"></script>
		<!-- Bootstrap 3.3.2 JS -->
		<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
		<!-- InputMask -->
		<script src="plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.extensions.js" type="text/javascript"></script>
		<!-- FastClick -->
		<script src='plugins/fastclick/fastclick.min.js'></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/jquery.price_format.min.js" type="text/javascript"></script>
		
		<script type="text/javascript">
			$(function() 
			{
				//Datemask2 mm/dd/yyyy
				$("#datemask2").inputmask("mm/dd/yyyy", {"placeholder": "mm/dd/yyyy"});
				//Money Euro
				$("[data-mask]").inputmask();
				
				$("#asat").focus();
			});
		</script>
	</body>
</html>