$(function() 
{	
	$('#cartitemslist').slimscroll({
		height: '350px',
		color: "#428bca"
	});
	
	$('#searchresultsdisplay').slimscroll({
		height: '350px',
		color: "#428bca"
	});
	
	$("#stockitemstable").dataTable();
		
	$('#itemcode').on('input', function() 
	{
		$("#servererrormessage").html("");
	});
	
	$("#itemcode").focus();
	
	$("#itemquantity").priceFormat({
		prefix: "",
		allowNegative: true,
		thousandsSeparator: ",",
		centsLimit: 0,
		clearOnEmpty: true
	});

	$("#itemcode").keyup(function(e) 
	{
		if (e.keyCode == 13) 
		{
			if($("#itemcode").val().trim()!="")
			{
				$("#servererrormessage").html("");
				
				$.ajax
				(
					{
						url: "getshopstockitemdetails.php",
						async: false, 
						type: "POST",
						dataType: "json",
						data: {itemcode: $("#itemcode").val().trim()},
						success: function(json)
						{
							if(json[0].isdataobtained == 0)
							{
								$("#servererrormessage").html(json[0].message);
								$('html, body').animate({ scrollTop: 0}, 'slow');
								$("#itemcode").select();
							}
							else
							{
								var itemrow = '<tr><td style="display:none;">'+json[0].stockid+'</td><td>'+json[0].name+'</td><td>'+json[0].barcode+'</td><td class="text-right">1</td><td class="text-right"><a href="javascript:void(0);" onclick="itemupdate(this)" data-toggle="tooltip" title="Edit Cart Item" class="tooltips"><span class="label label-primary" ><i class="glyphicon glyphicon-edit"></i></span></a> <a href="javascript:void(0);" onclick="itemdelete(this)" data-toggle="tooltip" title="Delete Cart Item" class="tooltips"><span class="label label-danger" ><i class="glyphicon glyphicon-trash"></i></span></a></td></tr>';
								
								$('#cartitemstable > tbody:last-child').append(itemrow);
								document.getElementById("itemcode").value = "";
								
								$('#cartitemslist').slimscroll({scrollTo: '350px'});
								
								var usenumberofrows = 0.00;
									
								$("#cartitemstable").children("tbody").children("tr").each(function(i) 
								{
									usenumberofrows += 1;
								});
								
								$("#itemscount").html('<b>'+usenumberofrows+'</b>');
							}
						},
						error: function(jqXHR, exception)
						{	
							if (jqXHR.status === 0) 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Not Connected Verify Network.</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else if (jqXHR.status == 404) 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested Operation Not Found.</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else if (jqXHR.status == 500) 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Internal Server Error.</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else if (exception === "parsererror") 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested JSON Parse Failed" + jqXHR.responseText + ".</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else if (exception === "timeout") 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Time Out Error.</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else if (exception === "abort") 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Ajax Request Aborted.</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Uncaught Error " + jqXHR.responseText + ".</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							}
						}
					}
				);
			}
			else
			{
				$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Item Identification Code Required!</div>");
				$('html, body').animate({ scrollTop: 0}, 'slow');
			}
		}
	});

	loadsearchform = function()
	{
		$('#largemodal').modal('show');
	}
	
	$("#largemodal").on("shown.bs.modal", function (e){
		$("#itemsearchtext").focus();
		$("#searchitemerrormessage").html("");
		$("#searchresultsdisplay").html("");
	});
	
	$("#largemodal").on("hidden.bs.modal", function (e){
		document.getElementById("itemsearchtext").value = "";
	});
	
	$("#getitemsbtn").click(function()
	{
		if($("#itemsearchtext").val().trim()!="")
		{
			$("#searchitemerrormessage").html("");
			
			$.ajax
			(
				{
					url: "getshopstockitemsearchresults.php",
					async: false, 
					type: "POST",
					dataType: "json",
					data: {itemsearchtext: $("#itemsearchtext").val().trim()},
					success: function(json)
					{
						if(json[0].isdataobtained == 0)
						{
							$("#searchitemerrormessage").html(json[0].message);
							$("#itemsearchtext").select();
						}
						else
						{
							$("#searchresultsdisplay").html(json[0].message);
						}
					},
					error: function(jqXHR, exception)
					{	
						if (jqXHR.status === 0) 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Not Connected Verify Network.</div>");
						} 
						else if (jqXHR.status == 404) 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested Operation Not Found.</div>");
						} 
						else if (jqXHR.status == 500) 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Internal Server Error.</div>");
						} 
						else if (exception === "parsererror") 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested JSON Parse Failed" + jqXHR.responseText + ".</div>");
						} 
						else if (exception === "timeout") 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Time Out Error.</div>");
						} 
						else if (exception === "abort") 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Ajax Request Aborted.</div>");
						} 
						else 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Uncaught Error " + jqXHR.responseText + ".</div>");
						}
					}
				}
			);
		}
		else
		{
			$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Item Name Or Code Required!</div>");
		}
	});
	
	$('#itemsearchtext').on('input', function() 
	{
		$("#searchitemerrormessage").html("");
		$("#searchresultsdisplay").html("");
	});
	
	$("#itemsearchtext").keyup(function(e) 
	{
		if (e.keyCode == 13) 
		{
			if($("#itemsearchtext").val().trim()!="")
			{
				$("#searchitemerrormessage").html("");
				
				$.ajax
				(
					{
						url: "getshopstockitemsearchresults.php",
						async: false, 
						type: "POST",
						dataType: "json",
						data: {itemsearchtext: $("#itemsearchtext").val().trim()},
						success: function(json)
						{
							if(json[0].isdataobtained == 0)
							{
								$("#searchitemerrormessage").html(json[0].message);
								$("#itemsearchtext").select();
							}
							else
							{
								$("#searchresultsdisplay").html(json[0].message);
							}
						},
						error: function(jqXHR, exception)
						{	
							if (jqXHR.status === 0) 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Not Connected Verify Network.</div>");
							} 
							else if (jqXHR.status == 404) 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested Operation Not Found.</div>");
							} 
							else if (jqXHR.status == 500) 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Internal Server Error.</div>");
							} 
							else if (exception === "parsererror") 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested JSON Parse Failed" + jqXHR.responseText + ".</div>");
							} 
							else if (exception === "timeout") 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Time Out Error.</div>");
							} 
							else if (exception === "abort") 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Ajax Request Aborted.</div>");
							} 
							else 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Uncaught Error " + jqXHR.responseText + ".</div>");
							}
						}
					}
				);
			}
			else
			{
				$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Item Name Or Code Required!</div>");
			}
		}
	});
	
	itemupdate = function(t)
	{
		var row = t.parentNode.parentNode;
		$("#servererrormessage").html("");
		$("#itemrowindex").text(row.rowIndex);
		$("#itemnamedisplay").html("<b>"+$("#cartitemstable tr:eq("+row.rowIndex+") td:eq(1)").text()+"</b>");
		$("#itemquantity").val($("#cartitemstable tr:eq("+row.rowIndex+") td:eq(3)").text());
		$('#mediummodal').modal('show');
	}
	
	cartitemrowupdate = function()
	{
		$("#itemediterrormessage").html("");
		
		var err = "";
		
		if($("#itemquantity").val() == "")
		{
			err += "Item Quantity Required!<br>";
		}
		else
		{
			if(parseFloat($("#itemquantity").val().replace(/[^-?0-9\.]/g,"")) == parseFloat(0))
				err += "Item Quantity Equal To Zero Not Supported!<br>";
		}
		
		if(err == "")
		{
			$("#cartitemstable tr:eq("+$("#itemrowindex").text()+") td:eq(3)").text($("#itemquantity").val());
			
			var usenumberofrows = 0.00;
				
			$("#cartitemstable").children("tbody").children("tr").each(function(i) 
			{
				usenumberofrows += 1;
			});
			
			$("#itemscount").html('<b>'+usenumberofrows+'</b>');
			$('#mediummodal').modal('hide');
		}
		else
		{
			$("#itemediterrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" + err + "</div>");
		}
	}
	
	$("#mediummodal").on("shown.bs.modal", function (e){
		$("#itemediterrormessage").html("");
	});

	itemdelete = function(t)
	{
		$("#servererrormessage").html("");
		
		var row = t.parentNode.parentNode;
		
		document.getElementById("cartitemstable").deleteRow(row.rowIndex);
		
		var usenumberofrows = 0.00;
	
		$("#cartitemstable").children("tbody").children("tr").each(function(i) 
		{
			usenumberofrows += 1;
		});
		
		$("#itemscount").html('<b>'+usenumberofrows+'</b>');
		$("#itemcode").focus();
	}
	
	canceladjustment = function()
	{
		$("#servererrormessage").html("");
		
		$("#cartitemstable > tbody").html("");
		
		var usenumberofrows = 0.00;
	
		$("#cartitemstable").children("tbody").children("tr").each(function(i) 
		{
			usenumberofrows += 1;
		});
		
		$("#itemscount").html('<b>'+usenumberofrows+'</b>');
		$("#memo").val('');
		document.getElementById("itemcode").value = "";
		$("#itemcode").focus();
	}
	
	processadjustment = function()
	{
		var err = "";
		var cartitemsarray = [];
		
		$("#servererrormessage").html("");
		
		var tbody = $("#cartitemstable tbody");

		if (tbody.children().length == 0)
		{
			err += "Cart Items Required!<br>";
		}
		else
		{
			var usenumberofrows = 0.00;
		
			$("#cartitemstable").children("tbody").children("tr").each(function(i) 
			{
				$tr = $(this);
				var useindex = 0;
				var usestockid = 0;
				var useitemname = "";
				var usequantity = 0;

				$("td", $tr).each(function() 
				{	
					if(useindex == 0)
					{
						usestockid = $(this).text();
					}
					
					if(useindex == 1)
					{
						useitemname = $(this).text();
					}
					
					if(useindex == 3)
					{
						usequantity = parseFloat($(this).text().replace(/[^-?0-9\.]/g,""));
						
						if(parseFloat($(this).text().replace(/[^-?0-9\.]/g,"")) == parseFloat(0))
							err += useitemname+" With Zero Quantity Is Not Supported!<br>";
					}
				
					useindex +=1;
					usenumberofrows += 1;
				});
				
				cartitemsarray.push({stockid: usestockid, itemname: useitemname, quantity: usequantity});
			});
			
			$("#itemscount").html('<b>'+usenumberofrows+'</b>');
		}
		
		if(err == "")
		{
			$("#servererrormessage").html("");
			
			$.ajax
			(
				{
					url: "itemadjustmentsave.php",
					async: false, 
					type: "POST",
					dataType: "json",
					data: {memo: $("#memo").val().trim(), cartitems: JSON.stringify(cartitemsarray)},
					success: function(json)
					{
						if(json[0].issaved == 0)
						{
							$("#servererrormessage").html(json[0].message);
							$('html, body').animate({ scrollTop: 0}, 'slow');
						}
						else
						{
							$("#servererrormessage").html(json[0].message);
							$('html, body').animate({ scrollTop: 0}, 'slow');
							
							$("#cartitemstable > tbody").html("");
		
							var usenumberofrows = 0.00;
						
							$("#cartitemstable").children("tbody").children("tr").each(function(i) 
							{
								usenumberofrows += 1;
							});
							
							$("#itemscount").html('<b>'+usenumberofrows+'</b>');
							$("#memo").val('');
							document.getElementById("itemcode").value = "";
							$("#itemcode").focus();
						}
					},
					error: function(jqXHR, exception)
					{	
						if (jqXHR.status === 0) 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Not Connected Verify Network.</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else if (jqXHR.status == 404) 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested Operation Not Found.</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else if (jqXHR.status == 500) 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Internal Server Error.</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else if (exception === "parsererror") 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested JSON Parse Failed" + jqXHR.responseText + ".</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else if (exception === "timeout") 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Time Out Error.</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else if (exception === "abort") 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Ajax Request Aborted.</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Uncaught Error " + jqXHR.responseText + ".</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						}
					}
				}
			);
		}
		else
		{
			$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>"+err+"</div>");
			$('html, body').animate({ scrollTop: 0}, 'slow');
		}
	}
	
});