<?php
	include("includes/dbconfig.php");
	$pagetitle = "Prices";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	$pricelistfound = FALSE;
		
	if(isset($_POST['getitembtn']))
	{
		if($_POST['shop']=="")
		{
			$err = $err."Shop Selection Required!<br>";
		}
		else
		{	
			if(trim($_POST['itemsearchtext'])=="")
			{
				$err = $err."Item Name, Code Or Barcode Required!<br>";
			}
			else
			{
				$pricedata = DB::query("SELECT item_price.id, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, item_price.item, item_price.cost_price, item_price.sell_price, item_price.version FROM item_price INNER JOIN stock_item ON item_price.item = stock_item.id AND stock_item.item_name LIKE %ss LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_price.shop=%i UNION SELECT item_price.id, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, item_price.item, item_price.cost_price, item_price.sell_price, item_price.version FROM item_price INNER JOIN stock_item ON item_price.item = stock_item.id AND stock_item.item_code=%s LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_price.shop=%i UNION SELECT item_price.id, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, item_price.item, item_price.cost_price, item_price.sell_price, item_price.version FROM item_price INNER JOIN stock_item ON item_price.item = stock_item.id AND stock_item.bar_code=%s LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_price.shop=%i UNION SELECT item_price.id, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, item_price.item, item_price.cost_price, item_price.sell_price, item_price.version FROM item_price INNER JOIN stock_item ON item_price.item = stock_item.id AND stock_item.alt_barcode=%s LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_price.shop=%i", trim($_POST['itemsearchtext']), $_POST['shop'], trim($_POST['itemsearchtext']), $_POST['shop'], trim($_POST['itemsearchtext']), $_POST['shop'], trim($_POST['itemsearchtext']), $_POST['shop']);
		
				if(DB::count() == 0)
				{
					$err=$err."No Item Found!<br>";
				}
				else
				{
					$pricelistfound = TRUE;
				}
			}
		}
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Manage Shop Prices</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							<?php
								
								if($err!="")
								{
							?>
							<div class="alert alert-danger">
								<i class="fa fa-ban-circle"></i><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Different Width</h3>
              </div>
              <div class="card-body">
			  <form  role='form' action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
                <div class="row">
				
                  <div class="col-6">
                   <label for="shop">Select Shop</label>
											<select class="form-control" name="shop" id="shop" data-placeholder="Choose One">
												<option value="">Choose One</option>
												<?php
													$results = DB::query("SELECT id, full_name FROM shop");
													
													foreach ($results as $row)
													{
												?>
												<option <?php if(isset($_POST['shop']) && $row['id']==$_POST['shop']) echo "selected=\"selected\""; ?> value="<?php echo $row['id']; ?>"><?php echo $row['full_name']; ?></option>
												<?php
													}
												?>
											</select>
                  </div>
                  <div class="col-6">
                     <div class="form-group">
											<label for="itemsearchtext">Item</label>
											<div class="input-group">
												<input type="text" value="<?php echo isset($_POST['itemsearchtext']) ? $_POST['itemsearchtext'] : "" ?>" name="itemsearchtext" id="itemsearchtext" class="form-control" placeholder="Enter Item Name, Code Or Barcode" />
												<span class="input-group-btn">
													<button class="btn btn-primary btn-flat" type="submit" name="getitembtn" id="getitembtn">Go!</button>
												</span>
											</div>
										</div><!-- form-group -->
                  </div>
                   
                </div>
				</form>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
							 
							
							<?php
								if($pricelistfound)
								{
							?>							
							<!--<div class="col-sm-12">-->
								<h3 class="card-title text-center">Search Result Set Price List</h3>
								<div class="card-body table-responsive no-padding">
									<div class="card-body table-responsive">
										<table id="stockitemstable" class="table table-striped">
											<thead>
												<tr>
													<th>Image</th>
													<th>Name</th>
													<th>Category</th>
													<th>Code</th>
													<th>Barcode</th>
													<th class="text-right">Cost Price</th>
													<th class="text-right">Sell Price</th>
													<th class="text-center">Actions</th>
												</tr>
											</thead>
											<tfoot>
												<tr>
													<th>Image</th>
													<th>Name</th>
													<th>Category</th>
													<th>Code</th>
													<th>Barcode</th>
													<th class="text-right">Cost Price</th>
													<th class="text-right">Sell Price</th>
													<th class="text-center">Actions</th>
												</tr>
											</tfoot>
											<tbody>
												<?php
													foreach($pricedata as $row)
													{
												?>
												<tr>
													<td style="width: 6%; vertical-align:middle;">
														<img class="img-thumbnail" id="logo" src="<?php echo ($row['item_image_file'] != "") ? "images/stockitemimage/" . $row['item_image_file'] : "images/stockitemimage/noimage.gif" ?>" alt="..." style="width: 100%;max-height: 100%">
													</td>
													<td style="vertical-align:middle;"><?php echo $row['item_name']; ?></td>
													<td style="vertical-align:middle;"><?php echo $row['category_name']; ?></td>
													<td style="vertical-align:middle;"><?php echo $row['item_code']; ?></td>
													<td style="vertical-align:middle;"><?php echo $row['bar_code']; ?></td>
													<td style="vertical-align:middle;" class="text-right"><?php echo number_format($row['cost_price'], 2); ?></td>
													<td style="vertical-align:middle;" class="text-right"><?php echo number_format($row['sell_price'], 2); ?></td>
													<td style="vertical-align:middle;" class="text-center">
														<a href="javascript:void(0);" onclick="pricesetup(<?php echo $row['id'].', '.$row['version']; ?>)" data-toggle="tooltip" title="Edit Item Price" class="tooltips"><span class="label label-primary" ><i class="fa fa-edit"></i></span></a>
													</td>
												</tr>
												<?php
													}
												?>
											</tbody>
										</table>
									</div>
								</div>
							<!--</div>-->
							<?php
								}
							?>
						</div><!-- /.card-body -->
						<div class="card-footer">
							
						</div><!-- /.card-footer-->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>

						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="mediummodaldetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<div class="modal" id="largemodal">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="largemodaldetails">
							
						</div>
					</div>
				</div>
			</div>
		</div>

			<?php include ('includes/general_footer.php')?>
			<script src="<?php echo $base_url;?>mod/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/pricesetup.js" type="text/javascript"></script>
	</body>
</html>