<?php
	include("includes/dbconfig.php");
	
	$err= "";
	
	if(isset($_POST['receiptfocus']))
	{
		if(DB::queryFirstField("SELECT COUNT(id) FROM cash_receipt WHERE id=%i", $_POST['receiptfocus']) != 1)
		{
			$err = $err."Receipt Not Identified!<br>";
		}
		else
		{
			if(DB::queryFirstField("SELECT COUNT(id) FROM cash_sale_item WHERE receipt=%i", $_POST['receiptfocus']) == 0)
			{
				$err = $err."Receipt Items Not Identified!<br>";
			}
			else
			{
				$receipt = DB::queryFirstRow("SELECT shop.full_name, shop.logo_file, shop.address_line_1, shop.address_line_2, shop.address_line_3, shop.zip_code, shop.city, shop.country, shop.tin, shop.phone, shop.fax, shop.email, personnel_details.display_name, personnel_details.first_name, cash_receipt.created_date, cash_receipt.value_date, cash_receipt.receipt_number, cash_receipt.customer_name, cash_receipt.amount, cash_receipt.customer_change, cash_receipt.memo, cash_receipt.is_cancelled FROM cash_receipt LEFT JOIN  personnel_details ON cash_receipt.created_by = personnel_details.id LEFT JOIN shop ON cash_receipt.shop = shop.id WHERE cash_receipt.id=%i", $_POST['receiptfocus']);
					
				
				if(DB::count() != 1)
				{
					$err = $err."Shop Not Identified!<br>";
				}
				else
				{
					$detailedreceiptaddress = "";
					$detailedcontactinfo = "";
					
					if(trim($receipt['address_line_1']) != "")
						$detailedreceiptaddress = $detailedreceiptaddress.trim($receipt['address_line_1'])."<br>";
					if(trim($receipt['address_line_2']) != "")
						$detailedreceiptaddress = $detailedreceiptaddress.trim($receipt['address_line_2'])."<br>";
					if(trim($receipt['address_line_3']) != "")
						$detailedreceiptaddress = $detailedreceiptaddress.trim($receipt['address_line_3'])."<br>";
						
					if(trim($receipt['zip_code']) != "")
						$detailedcontactinfo = $detailedcontactinfo."P.O Box ".trim($receipt['zip_code']);
					if(trim($receipt['city']) != "")
						$detailedcontactinfo = $detailedcontactinfo." ".trim($receipt['city']);
					if(trim($receipt['country']) != "")
						$detailedcontactinfo = $detailedcontactinfo." - ".trim($receipt['country'])."<br>";
					
					if(trim($receipt['phone']) != "")
						$detailedcontactinfo = $detailedcontactinfo.'<i class="glyphicon glyphicon-earphone"></i>: '.trim($receipt['phone']).'<br>';
					if(trim($receipt['fax']) != "")
						$detailedcontactinfo = $detailedcontactinfo.'<i class="glyphicon glyphicon-print"></i>: '.trim($receipt['fax']).'<br>';
					if(trim($receipt['email']) != "")
						$detailedcontactinfo = $detailedcontactinfo.'<i class="glyphicon glyphicon-envelope"></i>: '.trim($receipt['email']).'<br>';
						
					$receiptitems = DB::query("SELECT stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.description, cash_sale_item.sell_price, cash_sale_item.quantity, cash_sale_item.serial_number FROM cash_sale_item INNER JOIN item_price ON cash_sale_item.price_id = item_price.id INNER JOIN stock_item ON item_price.item = stock_item.id WHERE cash_sale_item.receipt=%i", $_POST['receiptfocus']);
					
					$receiptitemscompact = DB::query("SELECT stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.description, cash_sale_item.sell_price, cash_sale_item.quantity, cash_sale_item.serial_number FROM cash_sale_item INNER JOIN item_price ON cash_sale_item.price_id = item_price.id INNER JOIN stock_item ON item_price.item = stock_item.id WHERE cash_sale_item.receipt=%i", $_POST['receiptfocus']);

				}
			}
		}
	}
	else
	{
		$err= $err."Receipt Identification Required!<br>";
	}
?>
<!DOCTYPE html>
<html>
	<head>
	<meta charset="UTF-8">
	<title>Cash Receipt</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<!-- Bootstrap 3.3.2 -->
	<link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
	<!-- Font Awesome Icons -->
	<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
	<!-- Ionicons -->
	<link href="http://code.ionicframework.com/ionicons/2.0.0/css/ionicons.min.css" rel="stylesheet" type="text/css" />
	<!-- Theme style -->
	<link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />

	<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
	<!--[if lt IE 9]>
	<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
	<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
	<![endif]-->
	</head>
	<body onload="location.href='shopreceiptsview.php'; window.print();">
		<div class="wrapper">
			<!-- Main content -->
			<section class="content">
				<?php
					if($err == "")
					{
				?>
				
				<table>
					<tr>
						<td style="vertical-align:top; width: 10%">
							<div style="height: 80px width: 80px">
							<img class="img-thumbnail" id="itemphoto" src="<?php echo ($receipt['logo_file'] != "") ? "images/shoplogos/" . $receipt['logo_file'] : "images/shoplogos/noimage.gif" ?>" alt="..." width="100%"; height="100%" >
							</div>
						</td>
						<td style="vertical-align:top; padding-left: 15px;">
							<address>
								<strong><?php echo $receipt['full_name']; ?></strong><br>
								<?php echo $detailedreceiptaddress; ?>												
							</address>
						</td>
						<td class="pull-right" style="vertical-align:top;">
							<div>
								M/S <b><?php echo $receipt['customer_name']; ?></b><br>
								<b>Receipt No:</b> <?php echo $receipt['receipt_number']; ?><br>
								<b>Date:</b> <?php echo date("d-m-Y H:i", strtotime($receipt['created_date'])); ?><br>
							</div>
						</td>
					</tr>
					<tr>
						<td colspan="3" style="vertical-align:top; padding-top: 0px;">
							<address>
								<?php echo $detailedcontactinfo; ?>
								TIN:<?php echo $receipt['tin']; ?><br>
							</address>
						</td>
					</tr>
				</table>
						
						<table class="table table-hover">
							<thead>
								<tr>
									<th>Item</th>
									<th>Description</th>
									<th class="text-center">Quantity</th>
									<th class="text-right">Price</th>
									<th class="text-right">Amount</th>
								</tr>
							</thead>											
							<tbody>
								<?php
									$itemscount = 0;
									$itemstotalcost = 0;
									
									foreach($receiptitemscompact as $receiptitemscompactrow)
									{
										$userowtotal = ($receiptitemscompactrow['quantity'] * $receiptitemscompactrow['sell_price']);
										
										$itemscount += $receiptitemscompactrow['quantity'];
										$itemstotalcost += $userowtotal;
								?>
								<tr>
									<td style="vertical-align:middle;"><?php echo substr($receiptitemscompactrow['item_name'], 0, 50); ?></td>
									<td style="vertical-align:middle;"><?php echo substr($receiptitemscompactrow['description'], 0, 100); ?></td>
									<td class="text-center" style="vertical-align:middle;"><?php echo $receiptitemscompactrow['quantity']; ?></td>
									<td class="text-right" style="vertical-align:middle;"><?php echo number_format($receiptitemscompactrow['sell_price'], 2); ?></td>
									<td class="text-right" style="vertical-align:middle;"><?php echo number_format($userowtotal, 2); ?></td>
								</tr>
								<?php
										if($receiptitemscompactrow['serial_number'] != "")
										{
								?>
								<tr>
									<td style="vertical-align:middle;" colspan="5"><?php echo "<b>Serial:</b> <i>".$receiptitemscompactrow['serial_number']."</i>"; ?></td>
								</tr>	
								<?php
										}
									}
								?>
							</tbody>
							<tfoot>
								<tr>
									<th>Totals</th>
									<th></th>
									<th class="text-center"><?php echo number_format($itemscount, 2); ?></th>
									<th class="text-right"></th>
									<th class="text-right"><?php echo number_format($itemstotalcost, 2); ?></th>
								</tr>
							</tfoot>
						</table>
						<div class="row">
							<div class="col-xs-6">
							</div>
							 
							<div class="col-xs-6">
								<table class="table table-hover pull-right">
									<tr>
										<td class="lead">Paid</td>
										<td class="text-center lead"><b>:</b></td>
										<td class="text-right lead"><?php echo number_format($receipt['amount'], 2); ?></td>
									</tr>
									<tr>
										<td class="lead">Change</td>
										<td class="text-center lead"><b>:</b></td>
										<td class="text-right lead"><?php echo number_format($receipt['customer_change'], 2); ?></td>
									</tr>
								</table>
							</div>										
						</div>
						
						<div class="text-center">
							Goods once sold will not be taken back or exchanged<br>
							<b>Thank you. Please come again.</b><br>
							Served By:<b><?php echo $receipt['display_name']; ?></b><br>
						</div>
					<!--</div><!-- /.box-body -->
				<!--</div><!-- /.box -->
				<?php
					}
					else
					{
				?>
				<div class="alert alert-danger alert-dismissable">
					<i class="glyphicon glyphicon-ban-circle"></i><br>
					<?php 
						echo $err; 
					?>
				</div>
				<?php
					}
				?>
			</section><!-- /.content -->
		</div><!-- ./wrapper -->
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
	</body>
</html>