<?php
	include("includes/dbconfig.php");
	$pagetitle = "Shops";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Manage Shops</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="box-header with-border text-center">
							<h3 class="box-title">Shops List</h3>
						</div>
						<div class="box-body">
							<div id="servererrormessage">
							</div>
							 <div class="card-body">	
								<div class="col-sm-12">
									<div class="input-group-btn">
										<a href="shopsetup.php" class="btn btn-sm btn-primary pull-right"><i class="fa fa-plus"></i> Add Shop</a>
									</div>
								</div>
								
								<div class="col-md-12" style="margin-top: 25px"></div>
										
								<table id="example1"   class="table table-bordered table-striped">
									<thead>
										<tr>
											<th>Logo</th>
											<th>Shop Name</th>
											<th>Shop Code</th>
											<th>Tax Number</th>
											<th>Address</th>
											<th>Contacts</th>
											<th>Status</th>
											<th class="text-center">Action</th>
										</tr>
									</thead>
									<tfoot>
										<tr>
											<th>Logo</th>
											<th>Shop Name</th>
											<th>Shop Code</th>
											<th>Tax Number</th>
											<th>Address</th>
											<th>Contacts</th>
											<th>Status</th>
											<th class="text-center">Action</th>
										</tr>
									</tfoot>
									<tbody>
										<?php
											$shopdata = DB::query("SELECT id, full_name, shop_code, logo_file, address_line_1, address_line_2, address_line_3, zip_code, city, country, tin, phone, fax, email, is_active FROM shop ORDER BY full_name");

											if(DB::count() > 0)
											{
												foreach($shopdata as $row)
												{
													$address = "";
													$contacts = "";
													$status = "";
												
													if(trim($row['address_line_1']) != "")
														$address = $address.trim($row['address_line_1'])."<br>";
													if(trim($row['address_line_2']) != "")
														$address = $address.trim($row['address_line_2'])."<br>";
													if($row['address_line_3'] != "")
														$address = $address.trim($row['address_line_3'])."<br>";
													if($row['zip_code'] != "")
														$address = $address."P.O Box ".$row['zip_code']."<br>";
													if(trim($row['city']) != "")
														$address = $address.trim($row['city'])."<br>";
													if(trim($row['country']) != "")
														$address = $address.trim($row['country']);
													
													if(trim($row['phone']) != "")
														$contacts = $contacts.'<i class="fa fa-earphone"></i>: '.$row['phone'].'<br>';
													if($row['fax'] != "")
														$contacts = $contacts.'<i class="fa fa-fax"></i>: '.$row['fax'].'<br>';
													if($row['email'] != "")
														$contacts = $contacts.'<i class="fa fa-envelope"></i>: '.$row['email'].'<br>';
														
													if($row['is_active'] == 1)
													{
														$status = '<label class="label label-success" >Active</label>';
													}
													else
													{
														$status = '<label class="label label-danger" >Inactive</label>';
													}
										
													$action = '<a href="javascript:void(0);" onclick="gendawano(\'shopsetup\', \'shopfocus\', '.$row['id'].')" data-toggle="tooltip" title="Edit Shop" class="tooltips"><span class="label label-primary" ><i class="fa fa-edit"></i></span></a>';
										?>
										<tr>
											<td style="width: 10%; vertical-align:middle;">
												<div style="height: 80px width: 80px">
												<img class="img-thumbnail" id="logo" src="<?php echo ($row['logo_file'] != "") ? "images/shoplogos/" . $row['logo_file'] : "images/shoplogos/noimage.gif" ?>" alt="..." style="width: 100%;max-height: 100%">
												</div>
											</td>
											<td style="vertical-align:middle;"><?php echo $row['full_name']; ?></td>
											<td style="vertical-align:middle;"><?php echo $row['shop_code']; ?></td>
											<td style="vertical-align:middle;"><?php echo $row['tin']; ?></td>
											<td style="vertical-align:middle;"><?php echo $address; ?></td>
											<td style="vertical-align:middle;"><?php echo $contacts; ?></td>
											<td style="vertical-align:middle;"><?php echo $status; ?></td>
											<td style="vertical-align:middle;" class="text-center"><?php echo $action; ?></td>
										</tr>
										<?php
												}
											}
										?>
									</tbody>
								</table>
							</div>
						</div><!-- /.box-body -->
						 
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					 </div>
					</div>
					 
					
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="mediummodaldetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>

		<?php include ('includes/general_footer.php')?>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
	</body>
</html>