<?php
	include("includes/dbconfig.php");
	$pagetitle = "Shop Sales Summary";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$startdatevalid = false;
	
	if(isset($_POST['getreceiptsbtn']))
	{
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 3)
		{
			
			if($_POST['shop']=="")
			{
				$err = $err."Shop Selection Required!<br>";
			}
			else
			{
				if($_SESSION["connectedusergroup"] == 3 && $_POST['shop'] != $_SESSION["connecteduserbranch"])
					$err = $err."You Are Not Authorised To Access Receipts From Other Shops!<br>";
			}
			
			if(trim($_POST['from'])=="")
			{
				$err = $err."Start Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['from'], 0, 2);
				$day = substr($_POST['from'], 3, 2);
				$year = substr($_POST['from'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid Start Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d"))
					{
						$err = $err."Future Start Date Not Supported.<br>";
					}
					else
					{
						$startdatevalid = true;
					}
				}
			}
			
			if(trim($_POST['to'])=="")
			{
				$err = $err."End Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['to'], 0, 2);
				$day = substr($_POST['to'], 3, 2);
				$year = substr($_POST['to'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid End Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['to']))) > date("Y-m-d"))
					{
						$err = $err."Future End Date Not Supported.<br>";
					}
					else
					{
						if($startdatevalid)
						{
							if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d", strtotime(trim($_POST['to']))))
							{
								$err = $err."Start Date Can Not Be Greater Than The End Date.<br>";
							}
							else
							{
								if($_POST['shop'] == "x")
								{
									$salesdata = DB::queryFirstRow("SELECT 'All Shops' AS full_name, COUNT(cash_receipt.id) AS trxncount, COALESCE(SUM(cash_receipt.bill), 0) AS totalsales FROM cash_receipt WHERE cash_receipt.value_date>=%s AND cash_receipt.value_date<=%s AND cash_receipt.is_cancelled = 0", date("Y-m-d", strtotime(trim($_POST['from']))), date("Y-m-d", strtotime(trim($_POST['to']))));
									
									if(DB::count() == 0)
										$err = $err."No Sales Information Found!<br>";
								}
								else
								{
									$salesdata = DB::queryFirstRow("SELECT shop.full_name, COUNT(cash_receipt.id) AS trxncount, COALESCE(SUM(cash_receipt.bill), 0) AS totalsales FROM cash_receipt INNER JOIN shop ON cash_receipt.shop = shop.id WHERE cash_receipt.shop=%i AND cash_receipt.value_date>=%s AND cash_receipt.value_date<=%s AND cash_receipt.is_cancelled = 0 GROUP BY cash_receipt.shop", $_POST['shop'], date("Y-m-d", strtotime(trim($_POST['from']))), date("Y-m-d", strtotime(trim($_POST['to']))));
									
									if(DB::count() == 0)
										$err = $err."No Sales Information Found!<br>";
								}
							}
						}
					}
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h6>Shop Sales Summary</h6>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 3)
							{
						?>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="fa fa-ban"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<div class="card card-info">
              <div class="card-header">
                <h6 class="card-title">Sales Summary</h6>
              </div>
              <div class="card-body">
			  <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
									
                <div class="row">
                  <div class="col-3">
                  <label for="shop">Select Shop</label>
											<select  class="form-control" name="shop" id="shop" data-placeholder="Choose One">
												<option value="x">All Shops</option>
												<?php
													$shopsdata = DB::query("SELECT id, full_name FROM shop");
													
													foreach ($shopsdata as $shoprow)
													{
												?>
												<option <?php if(isset($_POST['shop']) && $shoprow['id']==$_POST['shop']) echo "selected=\"selected\""; ?> value="<?php echo $shoprow['id']; ?>"><?php echo $shoprow['full_name']; ?></option>
												<?php
													}
												?>
											</select>
                  </div>
                  <div class="col-4">
                   	<label for="from">Start Date</label>
											<input type="text" value="<?php echo isset($_POST['from']) ? $_POST['from'] : "" ?>" name="from" id="from" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
										
                  </div>
                  <div class="col-5">
                    <label for="to">End Date</label>
											<div class="input-group">
												<input type="text" value="<?php echo isset($_POST['to']) ? $_POST['to'] : "" ?>" name="to" id="to" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
												<span class="input-group-btn">
													<button class="btn btn-primary btn-flat" type="submit" name="getreceiptsbtn" id="getreceiptsbtn">Go!</button>
												</span>
											</div>
										</div><!-- form-group -->
                </div>
				</form>
              </div>
              <!-- /.card-body -->
            </div>
							
							<div class="card-body table-responsive no-padding">
								 
								
								<div class="col-md-12" style="margin-top: 25px"></div>
								 
								<?php
									if($err=="" && isset($_POST['getreceiptsbtn']))
									{
								?>
								<table class="table table-striped table-bordered" id="receiptstable">
									<thead>
										<tr>
											<th>Shop Name</th>
											<th class="text-center">Transactions</th>
											<th class="text-right">Amount</th>
										</tr>
									</thead>
									<tbody>
										<tr>
											<td><?php echo $salesdata['full_name']; ?></td>
											<td class="text-center"><?php echo number_format($salesdata['trxncount'], 0); ?></td>
											<td class="text-right"><?php echo number_format($salesdata['totalsales'], 2); ?></td>
										</tr>
									</tbody>
								</table>
								<?php
									}
								?>
								 
							</div>
						</div><!-- /.card-body -->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>

	 <?php include ('includes/general_footer.php')?>
		<!-- InputMask -->
		<script src="plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.extensions.js" type="text/javascript"></script>
		<!-- AdminLTE App -->
	 
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script>
			$(function() 
			{
				//Datemask2 mm/dd/yyyy
				$("#datemask2").inputmask("mm/dd/yyyy", {"placeholder": "mm/dd/yyyy"});
				//Money Euro
				$("[data-mask]").inputmask();
			});
		</script>
	</body>
</html>