<?php
	include("includes/dbconfig.php");
	$pagetitle = "Transfer From Shop";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Transfer From Shop</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<?php
						if($_SESSION["connectedusergroup"] == 3)
						{
					?>
					<div class="row">
						<div class="col-md-12">
							<div id="servererrormessage">
							</div>
						</div>
					</div>
				
					<div class="row">
						<div class="col-md-8">
							<div class="card card-primary" id="saledetails" style="height: 500px;">
								<div class="card-body">
									<div class="row">
										<div class="form-group col-sm-8">
											<input type="text" name="itemcode" id="itemcode" class="form-control" placeholder="Scan Item Barcode" >
										</div><!-- form-group -->
										<div class="form-group col-sm-4">
											<button id="searchitembtn" onclick="loadsearchform()" class="btn btn-primary"><i class="fa fa-search"></i> Open Item Search</button>
										</div>
									</div>
									
									<div>
										<div id="cartitemslist">
											<table   id="cartitemstable" class="table table-hover  table-bordered table-striped table-responsive">
												<thead>
													<tr>
														<th style="display:none;"></th>
														<th>Name</th>
														<th>Barcode</th>
														<th class="text-right">Quantity</th>
														<th class="text-right">Action</th>
													</tr>
												</thead>
												<tbody>
													
												</tbody>
											</table>
										</div>
									</div>
								</div><!-- /.card-body -->
							</div><!-- /.card -->
						</div>
						
						<div class="col-md-4">
							<div class="card card-success" id="salesummary" style="height: 500px;">
								<div class="card-body">
									<div class="form-group col-md-12">
										<div class="form-group">
											<label for="shop">Select Destination Shop/Store</label>
											<select  class="form-control" name="shop" id="shop" data-placeholder="Choose One">
												<option value="">Choose One</option>
												<option value="x">Store</option>';
												<?php
													$shopdata = DB::query("SELECT id, full_name FROM shop WHERE is_active = 1 AND id!=%i", $_SESSION["connecteduserbranch"]);
													
													foreach($shopdata as $shop)
													{
												?>
													<option value="<?php echo $shop['id']; ?>"><?php echo $shop['full_name']; ?></option>';
												<?php
													}
												?>
											</select>
										</div><!-- form-group -->
									</div><!-- form-group -->
									
									<label class="col-md-6">Items Count</label><i class="col-md-6" id="itemscount"><b>0</b></i>
									
									<div class="col-md-12" style="margin-top: 25px"></div>
									
									<div class="form-group col-md-12">
										<textarea name="memo" id="memo" rows="12" placeholder="Additional Notes ..." maxlength="195" class="form-control"></textarea>
									</div><!-- form-group -->
									
									<div class="btn-list col-md-12 text-center">
										<button onclick="canceltransfer()" class="btn btn-danger"><i class="fa fa-remove"></i> Cancel Transfer</button>
										
										<button onclick="processtransfer()" class="btn btn-success"><i class="fa fa-floppy-disk"></i> Process Transfer</button>
									</div>
							
								</div><!-- /.card-body -->
							</div><!-- /.card -->
						</div>
					</div>
					<?php
						}
						else
						{
					?>
					<div class="alert alert-danger alert-dismissable">
						<i class="fa fa-ban-circle"></i>
						Limited Access
					</div>
					<?php
						}
					?>
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
						<h4 class="modal-title text-center">Transfer Quantity Update</h4>
					</div>
					<div class="modal-body">					
						<div id="itemediterrormessage">
						</div>
						
						<div id="itemrowindex" style="display:none;">
						</div>
						
						<div id="itemnamedisplay" class="text-center" >
							<b>Sample Item Name</b>
						</div>
						
						<div class="col-md-12" style="margin-top: 15px"></div>
						
						<div class="row">
							<div class="col-sm-12">
								<div class="form-group">
									<label for="itemquantity">Transfer Quantity</label>
									<input type="text" name="itemquantity" id="itemquantity" class="form-control" >
								</div><!-- form-group -->
							</div>
						</div>
				
						<div id="notesfooter" class="modal-footer">
							<a href="" data-dismiss="modal" class="btn btn-danger"><i class="fa fa-times"></i> Close</a>
							<button name="updateitembtn" id="updateitembtn" onclick="cartitemrowupdate()" class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
							
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<div class="modal" id="largemodal">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
						<h4 class="modal-title text-center">Item Search Form</h4>
					</div>
					<div class="modal-body">
						<div id="searchitemerrormessage">
						</div>
						
						<div class="form-group">
							<div class="input-group">
								<input type="text" name="itemsearchtext" id="itemsearchtext" class="form-control" placeholder="Enter Item Name Or Code" />
								<span class="input-group-btn">
									<button class="btn btn-primary btn-flat" name="getitemsbtn" id="getitemsbtn">Go!</button>
								</span>
							</div>
						</div><!-- form-group -->
						
						<div id="searchresultsdisplay">
						
						</div>
					</div>
					<div id="notesfooter" class="modal-footer">
						<a href="" data-dismiss="modal" class="btn btn-danger"><i class="fa fa-times"></i> Close</a>
					</div>
				</div>
			</div>
		</div>
		<?php include ('includes/general_footer.php')?>
								 
		
		<script src="plugins/bert/jquery.price_format.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/shopstocktransfer.js" type="text/javascript"></script>
	</body>
</html>