<?php

	include("includes/dbconfig.php");
	$pagetitle = "Shop Items Quantities"; 
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
		
	if(isset($_POST['shop']))
	{
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 3 || $_SESSION["connectedusergroup"] == 2)
		{
			if($_SESSION["connectedusergroup"] == 3 && ($_POST['shop'] != $_SESSION["connecteduserbranch"]))
			{
				$err=$err."You Are Not Authorised To Access Stock Information From Other Shops!<br>";
			}
			else
			{
				$pricedata = DB::query("SELECT item_stock_level.id, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, item_batch.batch_code, stock_item.item_image_file, item_stock_level.quantity, item_stock_level.is_active, item_stock_level.version FROM item_stock_level INNER JOIN stock_item ON item_stock_level.item = stock_item.id LEFT JOIN item_batch ON item_stock_level.batch = item_batch.id LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_stock_level.shop=%i AND item_stock_level.quantity != 0 ORDER BY item_stock_level.is_active DESC, item_category.category_name, stock_item.item_name, stock_item.item_code", $_POST['shop']);
			
				if(DB::count() == 0)
					$err=$err."No Stock List For Selected Shop Found!<br>";
			}
			
			if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
			{
				$pricedata = DB::query("SELECT item_stock_level.id, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, item_batch.batch_code, stock_item.item_image_file, item_stock_level.quantity, item_stock_level.is_active, item_stock_level.version FROM item_stock_level INNER JOIN stock_item ON item_stock_level.item = stock_item.id LEFT JOIN item_batch ON item_stock_level.batch = item_batch.id LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_stock_level.shop=%i AND item_stock_level.quantity != 0 ORDER BY item_stock_level.is_active DESC, item_category.category_name, stock_item.item_name, stock_item.item_code", $_POST['shop']);
			
				if(DB::count() == 0)
					$err=$err."No Stock List For Selected Shop Found!<br>";
			}
		}
		else
		{
			$err=$err."Limited Access!<br>";
		}
		
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Shop Items Quantities</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default box -->
					<div class="box box-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
							{
						?>
						<div class="box-body" id ="Load_here" >
							<div id="servererrormessage">
							</div>
							
							<div class="row">
								<div class="col-sm-3">
								</div>
								<div class="col-sm-6">
									<div class="form-group">
										<label for="shop">Select Shop</label>
										<select onchange="gendawano('stock_take', 'shop', $('#shop').val())" class="form-control" name="shop" id="shop" data-placeholder="Choose One">
											<option value="">Choose One</option>
											<?php
												$results = DB::query("SELECT id, full_name FROM shop");
												
												foreach ($results as $row)
												{
											?>
											<option <?php if(isset($_POST['shop']) && $row['id']==$_POST['shop']) echo "selected=\"selected\""; ?> value="<?php echo $row['id']; ?>"><?php echo $row['full_name']; ?></option>
											<?php
												}
											?>
										</select>
									</div><!-- form-group -->
								</div>
								<div class="col-sm-3">
								</div>
							</div>
							
							<?php
								if($err=="" && isset($_POST['shop']))
								{
							?>							
							<!--<div class="col-sm-12">-->
								<h3 class="box-title text-center">Shop Items Quantities</h3>
								<div class="box-body table-responsive no-padding">
									<div class="box-body table-responsive">
										<table id="stockitemstable" class="table table-striped">
											<thead>
												<tr>
													<th>Image</th>
													<th>Name</th>
													<th>Category</th>
													<th>Code</th>
													<th>Barcode</th>
													<th>Batch</th>
													<th class="text-right">Quantity</th>
												    <th class="text-right">Sold</th>
												    <th class="text-right">Balance</th>
													<th class="text-center">Status</th>
												</tr>
											</thead>
											<tfoot>
												<tr>
													<th>Image</th>
													<th>Name</th>
													<th>Category</th>
													<th>Code</th>
													<th>Barcode</th>
													<th>Batch</th>
													<th class="text-right">Quantity</th>
												    <th class="text-right">Sold</th>
												    <th class="text-right">Balance</th>
														<th class="text-center">Add to stock</th>
													<th class="text-center">Reduce Stock</th>
												</tr>
											</tfoot>
											<tbody>
												<?php
												 
													foreach($pricedata as $row)
													{
														if($row['is_active'] == 1)
														{
															$status = '<label class="label label-success" >Active</label>';
														}
														else
														{
															$status = '<label class="label label-danger" >Inactive</label>';
														}
												?>
												<tr>
													<td style="width: 6%; vertical-align:middle;">
														<img class="img-thumbnail" id="logo" src="<?php echo ($row['item_image_file'] != "") ? "images/stockitemimage/" . $row['item_image_file'] : "images/stockitemimage/noimage.gif" ?>" alt="..." style="width: 100%;max-height: 100%">
													</td>
													<?php
												$no_sold  =0;
												 
												$item_id = DB::query("SELECT  id from stock_item WHERE item_code   = ".$row['item_code']."  ");
												foreach($item_id as $rowi)
												{
													 $item_price_id = DB::query("SELECT  id from item_price WHERE shop  = ".$_POST['shop']." AND item   = ".$rowi['id']."  ");
													 foreach($item_price_id as $rowid)
												        {
															 $item_id = DB::query('SELECT  SUM(quantity) as qty FROM cash_sale_item WHERE  is_cancelled ="0" AND price_id   = '.$rowid['id'].'    ');
															 
															  $no_sold  = $item_id[0]['qty'];
															
															
															
														}   
												}
												
												
												//$pricedata2X = DB::query("SELECT  count(quantity) from  cash_sale_item WHERE item_code   = ".$row['item_code']."  ");
												
												//print_r($pricedata2X);

												?>
													<td style="vertical-align:middle;"><?php echo $row['item_name']; ?></td>
													<td style="vertical-align:middle;"><?php echo $row['category_name']; ?></td>
													<td style="vertical-align:middle;"><?php echo $row['item_code']; ?></td>
													<td style="vertical-align:middle;"><?php echo $row['bar_code']; ?></td>
													<td style="vertical-align:middle;"><?php echo $row['batch_code']; ?></td>
													
													<td style="vertical-align:middle;" class="text-right"><?php echo (number_format($row['quantity'], 2)); ?></td>
												<td style="vertical-align:middle;" class="text-right"><?php echo ( $no_sold); ?></td>
												
												<td style="vertical-align:middle;" class="text-right"><?php echo (number_format($row['quantity'], 2) - $no_sold); ?></td>
												<td style="vertical-align:middle;" class="text-center"><label><input onclick ="return add_to_stock();" type  ="radio" value =" <?php echo$row['id']; ?>" id ="add_to_stock" name ="add_to_stock" />Add </label> </td> 
												<td style="vertical-align:middle;" class="text-center"><label><input onclick ="return remove_from_stock();" type  ="radio" value =" <?php echo$row['id']; ?>" id ="remove_from_stock" name ="remove_from_stock" />Reduce </label> </td> 
												
												</tr>
												<?php
													}
												?>
											</tbody>
										</table>
									</div>
								</div>
							<!--</div>-->
							<?php
								}
								
								if($err != "")
								{
							?>
							<div class="alert alert-danger">
								<i class="glyphicon glyphicon-ban-circle"></i><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
						</div><!-- /.box-body -->
						<div class="box-footer">
							
						</div><!-- /.box-footer-->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="glyphicon glyphicon-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.box -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>

		<!-- jQuery 2.1.3 -->
		<script src="plugins/jQuery/jQuery-2.1.3.min.js"></script>
		<!-- Bootstrap 3.3.2 JS -->
		<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
		<!-- FastClick -->
		<script src='plugins/fastclick/fastclick.min.js'></script>
		<!-- DATA TABES SCRIPT -->
		<script src="plugins/datatables/jquery.dataTables.js" type="text/javascript"></script>
		<script src="plugins/datatables/dataTables.bootstrap.js" type="text/javascript"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/shopstock.js" type="text/javascript"></script>
	</body>
</html>