<?php
	include("includes/dbconfig.php");
	
	$solditemsdata = DB::query("SELECT cash_sale_item.id, item_price.item, item_price.batch, cash_sale_item.shop, cash_sale_item.price_id, cash_sale_item.quantity, cash_sale_item.version FROM cash_sale_item, item_price WHERE cash_sale_item.price_id = item_price.id AND cash_sale_item.is_cancelled = 0 AND cash_sale_item.is_stock_updated = 0 LIMIT 500");
	
	if(DB::count() > 0)
	{
		foreach($solditemsdata as $solditem)
		{
			if($solditem['batch'] != "")
			{
				$stockquantitydata = DB::queryFirstRow("SELECT item_stock_level.id, item_stock_level.quantity, item_stock_level.version FROM item_stock_level, item_price WHERE item_stock_level.shop = item_price.shop AND item_stock_level.item = item_price.item AND item_stock_level.batch = item_price.batch AND item_price.id=%i", $solditem['price_id']);
			}
			else
			{
				$stockquantitydata = DB::queryFirstRow("SELECT item_stock_level.id, item_stock_level.quantity, item_stock_level.version FROM item_stock_level, item_price WHERE item_stock_level.shop = item_price.shop AND item_stock_level.item = item_price.item AND item_price.id=%i", $solditem['price_id']);
			}
			
			$trxnConnextn = new MeekroDB();
			$nonTrxnConnextn = new MeekroDB();
			
			$trxnConnextn->startTransaction();
			
			try
			{
				$trxnConnextn->query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
				$trxnConnextn->query("SELECT * FROM item_stock_level WHERE id=%i FOR UPDATE", $stockquantitydata['id']);
				$trxnConnextn->query("SELECT * FROM cash_sale_item WHERE id=%i FOR UPDATE", $solditem['id']);
				
				$trxnConnextn->update
				('item_stock_level', 
					array
					(
						'updated_date' => $trxnConnextn->sqleval("current_timestamp()"),
						'updated_by' => 0,
						'quantity' => ($stockquantitydata['quantity'] - $solditem['quantity']),
						'version' => ($stockquantitydata['version'] + 1)
					), 
					"id=%i", $stockquantitydata['id']
				);
				
				$trxnConnextn->update
				('cash_sale_item', 
					array
					(
						'updated_date' => $trxnConnextn->sqleval("current_timestamp()"),
						'updated_by' => 0,
						'is_stock_updated' => 1,
						'version' => ($solditem['version'] + 1)
					), 
					"id=%i", $solditem['id']
				);
				
				$stockrow = $nonTrxnConnextn->queryFirstRow("SELECT version FROM item_stock_level WHERE id=%i LIMIT 1", $stockquantitydata['id']);
				$salesrow = $nonTrxnConnextn->queryFirstRow("SELECT version FROM cash_sale_item WHERE id=%i LIMIT 1", $solditem['id']);
				
				if($stockrow['version'] == $stockquantitydata['version'] && $salesrow['version'] == $solditem['version'])
				{
					$trxnConnextn->commit();
				}
				else
				{
					$trxnConnextn->rollback();
				}
			}
			catch(MeekroDBException $e)
			{
				$trxnConnextn->rollback();
			}
		}
	}
	
	$solditemscancelleddata = DB::query("SELECT cash_sale_item.id, item_price.item, item_price.batch, cash_sale_item.shop, cash_sale_item.price_id, cash_sale_item.quantity, cash_sale_item.version FROM cash_sale_item, item_price WHERE cash_sale_item.price_id = item_price.id AND cash_sale_item.is_cancelled = 1 AND cash_sale_item.is_stock_updated = 1 AND cash_sale_item.quantity > 0 LIMIT 50");
	
	if(DB::count() > 0)
	{
		foreach($solditemscancelleddata as $cancelleditem)
		{
			if($cancelleditem['batch'] != "")
			{
				$stockquantitydata = DB::queryFirstRow("SELECT item_stock_level.id, item_stock_level.quantity, item_stock_level.version FROM item_stock_level, item_price WHERE item_stock_level.shop = item_price.shop AND item_stock_level.item = item_price.item AND item_stock_level.batch = item_price.batch AND item_price.id=%i", $cancelleditem['price_id']);
			}
			else
			{
				$stockquantitydata = DB::queryFirstRow("SELECT item_stock_level.id, item_stock_level.quantity, item_stock_level.version FROM item_stock_level, item_price WHERE item_stock_level.shop = item_price.shop AND item_stock_level.item = item_price.item AND item_price.id=%i", $cancelleditem['price_id']);
			}
			
			$trxnConnextn = new MeekroDB();
			$nonTrxnConnextn = new MeekroDB();
			
			$trxnConnextn->startTransaction();
			
			try
			{
				$trxnConnextn->query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
				$trxnConnextn->query("SELECT * FROM item_stock_level WHERE id=%i FOR UPDATE", $stockquantitydata['id']);
				$trxnConnextn->query("SELECT * FROM cash_sale_item WHERE id=%i FOR UPDATE", $cancelleditem['id']);
				
				$trxnConnextn->update
				('item_stock_level', 
					array
					(
						'updated_date' => $trxnConnextn->sqleval("current_timestamp()"),
						'updated_by' => 0,
						'quantity' => ($stockquantitydata['quantity'] + $cancelleditem['quantity']),
						'version' => ($stockquantitydata['version'] + 1)
					), 
					"id=%i", $stockquantitydata['id']
				);
				
				$trxnConnextn->update
				('cash_sale_item', 
					array
					(
						'updated_date' => $trxnConnextn->sqleval("current_timestamp()"),
						'updated_by' => 0,
						'quantity' => ($cancelleditem['quantity'] * -1),
						'version' => ($cancelleditem['version'] + 1)
					), 
					"id=%i", $cancelleditem['id']
				);
				
				$stockrow = $nonTrxnConnextn->queryFirstRow("SELECT version FROM item_stock_level WHERE id=%i LIMIT 1", $stockquantitydata['id']);
				$salesrow = $nonTrxnConnextn->queryFirstRow("SELECT version FROM cash_sale_item WHERE id=%i LIMIT 1", $cancelleditem['id']);
				
				if($stockrow['version'] == $stockquantitydata['version'] && $salesrow['version'] == $cancelleditem['version'])
				{
					$trxnConnextn->commit();
				}
				else
				{
					$trxnConnextn->rollback();
				}
			}
			catch(MeekroDBException $e)
			{
				$trxnConnextn->rollback();
			}
		}
	}
?>