<?php
	include("includes/dbconfig.php");
	$pagetitle = "Store stock management";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	$stocklistfound = FALSE;
	
	if(isset($_POST['getitembtn']))
	{	
		if( EMPTY($_POST['thesearch']))
		{
			$err = $err."Item Name, Code Or Barcode Required!<br>";
		}
		else
		{
			 
			$stockitemsdata = DB::query('
			SELECT item_stock_level.id, stock_item.item_name,  stock_item.item_image_file, item_code, stock_item.reorder_level, stock_item.status, item_category.category_name, bar_code, status as is_active, item_stock_level.quantity, item_stock_level.version FROM item_stock_level LEFT JOIN stock_item ON item_stock_level.item = stock_item.id LEFT JOIN item_category ON stock_item.category = item_category.id   WHERE item_stock_level.shop IS NULL and (item_name LIKE "%'.$_POST['thesearch'].'%"  or bar_code ="'.$_POST['thesearch'].'" ) 
			
			
			 
			'
			);
			if(DB::count() == 0)
			{
			 
				$err=$err."No Item Found!<br>";
			}
			else
			{
				$stocklistfound = TRUE;
			}
		}
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				 

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
					<?php
						if($_SESSION["connectedusergroup"] < 4)
						{
					?>
						<div class="card-header with-border text-center">
							<h3 class="card-title"><?= $pagetitle;?></h3>
						</div>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger">
								<i class="fa fa-ban-circle"></i><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}?>
							<div class="card-body table-responsive no-padding">
								<div class="col-sm-12">
								 
									
										<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
											<div class="row">
											<div class="col-md-12">
											<label for="itemsearchtext">Search Item</label>
											<div class="input-group">
												<input type="text" value="<?php echo isset($_POST['itemsearchtext']) ? $_POST['itemsearchtext'] : "" ?>" name="thesearch" id="itemsearchtext" class="form-control" placeholder="Enter Item Name, Code Or Barcode" />
												<span class="input-group-btn">
													<button class="btn btn-primary btn-flat" type="submit" name="getitembtn" id="getitembtn">Go!</button>
												</span>
											</div>
										</div><!-- form-group -->
										</div>
									</form>
									
										
										 
								</div>
								
								<div class="col-md-12" style="margin-top: 25px"></div>
								
								<?php if(!empty($stockitemsdata)){ ?>
										
								<table id="stockitemstable" class="table table-striped">
										<thead>
											<tr>
												<th>Image</th>
												<th>Name</th>
												<th>Category</th>
												<th>Code</th>
												<th>Barcode</th> 
												<th>Reorder Level</th>
												<th>Quantity At Hand</th>
												<th class="text-center">Status</th>
												<th class="text-center">Actions</th>
											</tr>
										</thead>
										<tfoot>
											<tr>
												<th>Image</th>
												<th>Name</th>
												<th>Category</th>
												<th>Code</th>
												<th>Barcode</th> 
												<th>Reorder Level</th>
												<th>Quantity At Hand</th>
												<th class="text-center">Status</th>
												<th class="text-center">Actions</th>
											</tr>
										</tfoot>
										<tbody>
											<?php
												$status = "";
												$action = "";
												
												foreach($stockitemsdata as $row)
												{
													 
														if($row['status'] == 1)
														{
															$status = '<label class="btn btn-mini btn-success" >Active</label>';
															
															$action = '<a href="javascript:void(0);" onclick="receivegoodsform('.$row['id'].', '.$row['status'].', '.$row['version'].')" data-toggle="tooltip" title="Receive Item" class="tooltips"><span class="btn btn-mini btn-success" ><i class="fa fa-truck"></i></span></a>
															<a href="javascript:void(0);"  onclick="transfergoodstoshopform('.$row['id'].', '.$row['status'].', '.$row['version'].')" data-toggle="tooltip" title="Transfer To Shop" class="tooltips"><span class="btn btn-mini btn-primary" ><i class="fa fa-arrow-right"></i></span></a> 
															<a href="javascript:void(0);"  onclick="itemadjustmentform('.$row['id'].', '.$row['version'].')" data-toggle="tooltip" title="Adjust Item Quantity" class="tooltips"><span class="btn btn-mini btn-info" ><i class="fa fa-adjust"></i></span></a>';
														}
														else
														{
															$status = '<label class="btn btn-mini btn-danger" >Inactive</label>';
															
															$action = '<a href="javascript:void(0);" onclick="itemadjustmentform('.$row['id'].', '.$row['version'].')" data-toggle="tooltip" title="Adjust Item Quantity" class="tooltips"><span class="btn btn-mini btn-default" ><i class="fa fa-adjust"></i></span></a>';
														}
													 
											?>
											<tr>
												<td style="width: 7%; vertical-align:middle;">
													<img class="img-thumbnail" id="logo" src="<?php echo ($row['item_image_file'] != "") ? "images/stockitemimage/" . $row['item_image_file'] : "images/stockitemimage/noimage.gif" ?>" alt="..." style="width: 100%;max-height: 100%">
												</td>
												<td style="vertical-align:middle;"><?php echo $row['item_name']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['category_name']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['item_code']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['bar_code']; ?></td> 
												<td style="vertical-align:middle;"><?php echo number_format($row['reorder_level'], 2); ?></td>
												<td style="vertical-align:middle;"><?php echo number_format($row['quantity'], 2); ?></td>
												<td style="vertical-align:middle;" class="text-center"><?php  echo $status; ?></td>
												<td style="vertical-align:middle;" class="text-center"><?php  echo $action; ?></td>
												 
											</tr>
											<?php
												}
											?>
										</tbody>
									</table>
								<?php } ?>
							</div>
						</div><!-- /.card-body -->
						<div class="card-footer">
							
						</div><!-- /.card-footer-->
					<?php
						}
						else
						{
					?>
					<div class="alert alert-danger alert-dismissable">
						<i class="fa fa-ban-circle"></i>
						Limited Access
					</div>
					<?php
						}
					?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog modal-xl">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="mediummodaldetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<div class="modal" id="largemodal">
			<div class="modal-dialog modal-xl">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="largemodaldetails">
							
						</div>
					</div>
				</div>
			</div>
		</div>
<?php include ('includes/general_footer.php')?> 
		 
		
		
		<script src="<?php echo $base_url; ?>plugins/bert/storepos2.js" type="text/javascript"></script>
		<script src="<?php echo $base_url; ?>plugins/bert/store2.js" type="text/javascript"></script>
		 
	</body>
</html>