<?php
	include("includes/dbconfig.php");
	$pagetitle = "Store Items Quantities";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Store Items Quantities</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
							{
						?>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							
							<h3 class="card-title text-center">Store Items Quantities</h3>
							
							<div class="card-body table-responsive no-padding">
								<div class="card-body table-responsive">
									<table id="stockitemstable" class="table table-striped">
										<thead>
											<tr>
												<th>Image</th>
												<th>Name</th>
												<th>Category</th>
												<th>Code</th>
												<th>Barcode</th>
												<th>Reorder Level</th>
												<th>Quantity At Hand</th>
												<th class="text-center">Status</th>
											</tr>
										</thead>
										<tfoot>
											<tr>
												<th>Image</th>
												<th>Name</th>
												<th>Category</th>
												<th>Code</th>
												<th>Barcode</th>
												<th>Reorder Level</th>
												<th>Quantity At Hand</th>
												<th class="text-center">Status</th>
											</tr>
										</tfoot>
										<tbody>
											<?php
												$stockitemsdata = DB::query("SELECT item_stock_level.id, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, stock_item.reorder_level, stock_item.status, item_category.category_name, item_stock_level.quantity, item_stock_level.version FROM item_stock_level INNER JOIN stock_item ON item_stock_level.item = stock_item.id LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_stock_level.shop IS NULL ");
												$status = "";
												
												foreach($stockitemsdata as $row)
												{
													if($row['status'] == 1)
													{
														$status = '<label class="label label-success" >Active</label>';
													}
													else
													{
														$status = '<label class="label label-danger" >Inactive</label>';
													}
											?>
											<tr>
												<td style="width: 7%; vertical-align:middle;">
													<img class="img-thumbnail" id="logo" src="<?php echo ($row['item_image_file'] != "") ? "images/stockitemimage/" . $row['item_image_file'] : "images/stockitemimage/noimage.gif" ?>" alt="..." style="width: 100%;max-height: 100%">
												</td>
												<td style="vertical-align:middle;"><?php echo $row['item_name']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['category_name']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['item_code']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['bar_code']; ?></td>
												<td style="vertical-align:middle;"><?php echo number_format($row['reorder_level'], 2); ?></td>
												<td style="vertical-align:middle;"><?php echo number_format($row['quantity'], 2); ?></td>
												<td style="vertical-align:middle;" class="text-center"><?php echo $status; ?></td>
											</tr>
											<?php
												}
											?>
										</tbody>
									</table>
								</div>
							</div>
							
						</div><!-- /.card-body -->
						<div class="card-footer">
							
						</div><!-- /.card-footer-->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="mediummodaldetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<div class="modal" id="largemodal">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="largemodaldetails">
							
						</div>
					</div>
				</div>
			</div>
		</div>

		
		<?php include ('includes/general_footer.php')?> 
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/store.js" type="text/javascript"></script>
	</body>
</html>