<?php
	include("includes/dbconfig.php");
	
	$err= "";
	
	$startdatevalid = false;
	
	$adjustmentscount = 0;
	
	if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
	{
		if(trim($_POST['from'])=="")
		{
			$err = $err."Start Date Required!<br>";
		}
		else
		{
			$month = substr($_POST['from'], 0, 2);
			$day = substr($_POST['from'], 3, 2);
			$year = substr($_POST['from'], 6, 4);
			
			if(!checkdate($month, $day, $year))
			{
				$err = $err."Valid Start Date Required.<br>";
			}
			else
			{
				if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d"))
				{
					$err = $err."Future Start Date Not Supported.<br>";
				}
				else
				{
					$startdatevalid = true;
				}
			}
		}
		
		if(trim($_POST['to'])=="")
		{
			$err = $err."End Date Required!<br>";
		}
		else
		{
			$month = substr($_POST['to'], 0, 2);
			$day = substr($_POST['to'], 3, 2);
			$year = substr($_POST['to'], 6, 4);
			
			if(!checkdate($month, $day, $year))
			{
				$err = $err."Valid End Date Required.<br>";
			}
			else
			{
				if(date("Y-m-d", strtotime(trim($_POST['to']))) > date("Y-m-d"))
				{
					$err = $err."Future End Date Not Supported.<br>";
				}
				else
				{
					if($startdatevalid)
					{
						if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d", strtotime(trim($_POST['to']))))
						{
							$err = $err."Start Date Can Not Be Greater Than The End Date.<br>";
						}
						else
						{
							$storestockajustmentdata = DB::query("SELECT stock_item_adjustment.value_date, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item_adjustment.quantity, stock_item_adjustment.memo, personnel_details.display_name FROM stock_item_adjustment INNER JOIN stock_item ON stock_item_adjustment.item = stock_item.id LEFT JOIN item_category ON stock_item.category = item_category.id LEFT JOIN personnel_details ON stock_item_adjustment.created_by =  personnel_details.id WHERE stock_item_adjustment.shop IS NULL AND stock_item_adjustment.value_date>=%s AND stock_item_adjustment.value_date<=%s ORDER BY stock_item_adjustment.value_date, item_category.category_name, stock_item_adjustment.id", date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
							
							$adjustmentscount += DB::count();
							
							if($adjustmentscount == 0)
								$err = $err."No Stock Ajustment Entries Found!<br>";
							
						}
					}
				}
			}
		}
	}
	else
	{
		$err = $err."Limited Access!<br>";
	}
?>
<!DOCTYPE html>
<html>
	<head>
	<meta charset="UTF-8">
	<title>Store Adjustments</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<!-- Bootstrap 3.3.2 -->
	<link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
	<!-- Font Awesome Icons -->
	<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
	<!-- Ionicons -->
	<link href="http://code.ionicframework.com/ionicons/2.0.0/css/ionicons.min.css" rel="stylesheet" type="text/css" />
	<!-- Theme style -->
	<link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />

	<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
	<!--[if lt IE 9]>
	<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
	<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
	<![endif]-->
	</head>
	<body onload="location.href='storestockadjustmentsview.php'; window.print();">
		<div class="wrapper">
			<!-- Main content -->
			<section class="content">
				<?php
					if($err == "")
					{
				?>
				
				<h3 class="box-title text-center"><?php echo "Store Adjustments From ".date("d-m-Y", strtotime(trim($_POST['from']))). " To ". date("d-m-Y", strtotime(trim($_POST['to']))); ?></h3>
			
				<table class="table table-hover">
					<thead>
						<tr>
							<th>Sr.</th>
							<th>Date</th>
							<th>Name</th>
							<th>Category</th>
							<th>Barcode</th>
							<th class="text-right">Quantity</th>
							<th>Memo</th>
						</tr>
					</thead>											
					<tbody>
						<?php
							$itemscount = 0;
							
							foreach($storestockajustmentdata as $storestockajustment)
							{
								$itemscount += 1;
						?>
						<tr>
							<td style="vertical-align:middle;"><?php echo number_format($itemscount, 0); ?></td>
							<td><?php echo date("d-m-Y", strtotime($storestockajustment['value_date'])); ?></td>
							<td><?php echo $storestockajustment['item_name']; ?></td>
							<td><?php echo $storestockajustment['category_name']; ?></td>
							<td><?php echo $storestockajustment['bar_code']; ?></td>
							<td class="text-right"><?php echo number_format($storestockajustment['quantity'], 2); ?></td>
							<td><?php echo $storestockajustment['memo'] . " Entrant: " . $storestockajustment['display_name']; ?></td>
						</tr>	
						<?php
							}
						?>
					</tbody>
					<tfoot>
						<tr>
							<th>Sr.</th>
							<th>Date</th>
							<th>Name</th>
							<th>Category</th>
							<th>Barcode</th>
							<th class="text-right">Quantity</th>
							<th>Memo</th>
						</tr>
					</tfoot>
				</table>
						
				<div class="text-center">
					Report Generated By:<b><?php echo $_SESSION["connecteduserdisplayname"]; ?></b><br>
				</div>
				<?php
					}
					else
					{
				?>
				<div class="alert alert-danger alert-dismissable">
					<i class="glyphicon glyphicon-ban-circle"></i><br>
					<?php 
						echo $err; 
					?>
				</div>
				<?php
					}
				?>
			</section><!-- /.content -->
		</div><!-- ./wrapper -->
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
	</body>
</html>