<?php
	include("includes/dbconfig.php");
	$pagetitle = "Store Adjustments View";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$startdatevalid = false;
	
	$adjustmentscount = 0;

	if(isset($_POST['gettrxnsbtn']))
	{	
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
		{
			if(trim($_POST['from'])=="")
			{
				$err = $err."Start Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['from'], 0, 2);
				$day = substr($_POST['from'], 3, 2);
				$year = substr($_POST['from'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid Start Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d"))
					{
						$err = $err."Future Start Date Not Supported.<br>";
					}
					else
					{
						$startdatevalid = true;
					}
				}
			}
			
			if(trim($_POST['to'])=="")
			{
				$err = $err."End Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['to'], 0, 2);
				$day = substr($_POST['to'], 3, 2);
				$year = substr($_POST['to'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid End Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['to']))) > date("Y-m-d"))
					{
						$err = $err."Future End Date Not Supported.<br>";
					}
					else
					{
						if($startdatevalid)
						{
							if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d", strtotime(trim($_POST['to']))))
							{
								$err = $err."Start Date Can Not Be Greater Than The End Date.<br>";
							}
							else
							{
								$storestockajustmentdata = DB::query("SELECT stock_item_adjustment.value_date, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item_adjustment.quantity, stock_item_adjustment.memo, personnel_details.display_name FROM stock_item_adjustment INNER JOIN stock_item ON stock_item_adjustment.item = stock_item.id LEFT JOIN item_category ON stock_item.category = item_category.id LEFT JOIN personnel_details ON stock_item_adjustment.created_by =  personnel_details.id WHERE stock_item_adjustment.shop IS NULL AND stock_item_adjustment.value_date>=%s AND stock_item_adjustment.value_date<=%s ORDER BY stock_item_adjustment.value_date, item_category.category_name, stock_item_adjustment.id", date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
								
								$adjustmentscount += DB::count();
								
								if($adjustmentscount == 0)
									$err = $err."No Stock Ajustment Entries Found!<br>";
								
							}
						}
					}
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}

	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Store Adjustments View</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
							{
						?>
						<div class="card-body">
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="fa fa-ban-circle"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<div id="servererrormessage">
							</div>
							
							<div class="card card-info">
              <div class="card-header">
                <h3 class="card-title">Store Adjustments </h3>
              </div>
              <div class="card-body">
			  <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
							
                <div class="row">
                  <div class="col-6">
                    <label for="from">Start Date</label>
											<input type="text" value="<?php echo isset($_POST['from']) ? $_POST['from'] : "" ?>" name="from" id="from" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
									
                  </div>
                 <div class="form-group col-sm-6">
											<label for="to">End Date</label>
											<div class="input-group">
												<input type="text" value="<?php echo isset($_POST['to']) ? $_POST['to'] : "" ?>" name="to" id="to" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
												<span class="input-group-btn">
													<button class="btn btn-primary btn-flat" type="submit" name="gettrxnsbtn" id="gettrxnsbtn">Go!</button>
												</span>
											</div>
										</div><!-- form-group -->
                   
                </div>
				</div>
              </div>
              <!-- /.card-body -->
            </div>
							
							<div class="card-body table-responsive no-padding">
									
								 
								 
								
								<div class="col-md-12" style="margin-top: 25px"></div>
								
								<?php
									if($err=="" && isset($_POST['gettrxnsbtn']))
									{
								?>
								<div class="col-sm-12">
									<div class="input-group-btn">
										<button onclick="gendawano2('storestockadjustments_print', 'from', '<?php echo $_POST['from']; ?>', 'to', '<?php echo $_POST['to']; ?>')" class="btn btn-sm btn-primary pull-right"><i class="fa fa-print"></i> Print</button>
									</div>
								</div>
								
								<div class="col-md-12" style="margin-top: 25px"></div>
								
								<table id="stockitemstable" class="table table-striped">
									<thead>
										<tr>
											<th>Date</th>
											<th>Name</th>
											<th>Category</th>
											<th>Barcode</th>
											<th class="text-right">Quantity</th>
											<th>Memo</th>
										</tr>
									</thead>
									<tbody>
										<?php
											foreach($storestockajustmentdata as $storestockajustment)
											{
										?>
										<tr>
											<td><?php echo date("d-m-Y", strtotime($storestockajustment['value_date'])); ?></td>
											<td><?php echo $storestockajustment['item_name']; ?></td>
											<td><?php echo $storestockajustment['category_name']; ?></td>
											<td><?php echo $storestockajustment['bar_code']; ?></td>
											<td class="text-right"><?php echo number_format($storestockajustment['quantity'], 2); ?></td>
											<td><?php echo $storestockajustment['memo'] . " Entrant: " . $storestockajustment['display_name']; ?></td>
										</tr>
										<?php
											}
										?>
									</tbody>
								</table>
								<?php
									}
								?>
								
							</div><!-- /.card-body -->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->

			<?php include ('includes/general_footer.php')?> 
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<!-- InputMask -->
		<script src="plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.extensions.js" type="text/javascript"></script>
		
		
		<script type="text/javascript">
			$(function() 
			{
				//Datemask2 mm/dd/yyyy
				$("#datemask2").inputmask("mm/dd/yyyy", {"placeholder": "mm/dd/yyyy"});
				//Money Euro
				$("[data-mask]").inputmask();
				
				$("#from").focus();
				
				$("#stockitemstable").dataTable();
			});
		</script>
	</body>
</html>