<?php
	include("includes/dbconfig.php");
	$pagetitle = "Supplier Setup";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$successsave="";
	
	if(isset($_POST['supplierfocus']))
	{
		$supplierfocus = $_POST['supplierfocus'];
	}
	
	if(!(isset($_POST['savedatabtn'])) && (isset($supplierfocus) && $supplierfocus > 0))
	{
		$supplierdata = DB::queryFirstRow("SELECT supplier_name, address_line1, address_line2, address_line3, postal_code, city, country, telephone_number, fax, supplier_email, supplier_bank, bank_branch_name, bank_account_code, contact_first_name, contact_last_name, contact_telephone_number, contact_email, supplier_status, version FROM supplier WHERE id=%i", $supplierfocus);
		
		if(DB::count() == 1)
		{   
			$_POST['supplierfocus'] = $supplierfocus;
			$_POST['suppliername'] = ($supplierdata['supplier_name'] != "") ? $supplierdata['supplier_name'] : "";
			$_POST['status'] = $supplierdata['supplier_status'];
			$_POST['addressline1'] = ($supplierdata['address_line1'] != "") ? $supplierdata['address_line1'] : "";
			$_POST['addressline2'] = ($supplierdata['address_line2'] != "") ? $supplierdata['address_line2'] : "";
			$_POST['addressline3'] = ($supplierdata['address_line3'] != "") ? $supplierdata['address_line3'] : "";
			$_POST['postalcode'] = ($supplierdata['postal_code'] != "") ? $supplierdata['postal_code'] : "";
			$_POST['city'] = ($supplierdata['city'] != "") ? $supplierdata['city'] : "";
			$_POST['country'] = ($supplierdata['country'] != "") ? $supplierdata['country'] : "";
			$_POST['phone'] = ($supplierdata['telephone_number'] != "") ? $supplierdata['telephone_number'] : "";
			$_POST['fax'] = ($supplierdata['fax'] != "") ? $supplierdata['fax'] : "";
			$_POST['email'] = ($supplierdata['supplier_email'] != "") ? $supplierdata['supplier_email'] : "";
			$_POST['bank'] = ($supplierdata['supplier_bank'] != "") ? $supplierdata['supplier_bank'] : "";
			$_POST['branch'] = ($supplierdata['bank_branch_name'] != "") ? $supplierdata['bank_branch_name'] : "";
			$_POST['accountnumber'] = ($supplierdata['bank_account_code'] != "") ? $supplierdata['bank_account_code'] : "";
			$_POST['firstname'] = ($supplierdata['contact_first_name'] != "") ? $supplierdata['contact_first_name'] : "";
			$_POST['lastname'] = ($supplierdata['contact_last_name'] != "") ? $supplierdata['contact_last_name'] : "";
			$_POST['contactphone'] = ($supplierdata['contact_telephone_number'] != "") ? $supplierdata['contact_telephone_number'] : "";
			$_POST['contactemail'] = ($supplierdata['contact_email'] != "") ? $supplierdata['contact_email'] : "";
			$_POST['recversion'] = $supplierdata['version'];
		}
	}
   	
	if(isset($_POST['savedatabtn']))
	{
		if($_SESSION["connectedusergroup"] == 1)
		{
			if(trim($_POST['suppliername']) == "")
				$err = $err."Supplier Name Required!<br>";
				
			if($_POST['status'] == "")
				$err = $err."Status Required!<br>";

			if(trim($_POST['email'])!="")
			{
				if(!filter_var(trim($_POST['email']), FILTER_VALIDATE_EMAIL))
				{
					$err = $err."Valid Email Address Required!<br>";
				}
			}
			
			if(trim($_POST['contactemail'])!="")
			{
				if(!filter_var(trim($_POST['contactemail']), FILTER_VALIDATE_EMAIL))
				{
					$err = $err."Valid Contact Person Email Address Required!<br>";
				}
			}
			
			if($err == "")
			{
				DB::$error_handler = false;
				DB::$throw_exception_on_error = true;
			
				if($supplierfocus == 0)
				{
					try
					{
						DB::startTransaction();
						DB::query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
						DB::insert
						('supplier', 
							array
							(
								'created_by' => $_SESSION["connecteduserid"],
								'supplier_name' => (trim($_POST['suppliername']) != "") ? trim($_POST['suppliername']) : NULL,
								'address_line1' => (trim($_POST['addressline1']) != "") ? trim($_POST['addressline1']) : NULL,
								'address_line2' => (trim($_POST['addressline2']) != "") ? trim($_POST['addressline2']) : NULL,
								'address_line3' => (trim($_POST['addressline3']) != "") ? trim($_POST['addressline3']) : NULL,
								'postal_code' => (trim($_POST['postalcode']) != "") ? trim($_POST['postalcode']) : NULL,
								'city' => (trim($_POST['city']) != "") ? trim($_POST['city']) : NULL,
								'country' => (trim($_POST['country']) != "") ? trim($_POST['country']) : NULL,
								'telephone_number' => (trim($_POST['phone']) != "") ? trim($_POST['phone']) : NULL,
								'fax' => (trim($_POST['fax']) != "") ? trim($_POST['fax']) : NULL,
								'supplier_email' => (trim($_POST['email']) != "") ? trim($_POST['email']) : NULL,
								'supplier_bank' => (trim($_POST['bank']) != "") ? trim($_POST['bank']) : NULL,
								'bank_branch_name' => (trim($_POST['branch']) != "") ? trim($_POST['branch']) : NULL,
								'bank_account_code' => (trim($_POST['accountnumber']) != "") ? trim($_POST['accountnumber']) : NULL,
								'contact_first_name' => (trim($_POST['firstname']) != "") ? trim($_POST['firstname']) : NULL,
								'contact_last_name' => (trim($_POST['lastname']) != "") ? trim($_POST['lastname']) : NULL,
								'contact_telephone_number' => (trim($_POST['contactphone']) != "") ? trim($_POST['contactphone']) : NULL,
								'contact_email' => (trim($_POST['contactemail']) != "") ? trim($_POST['contactemail']) : NULL,
								'supplier_status' => ($_POST['status'] == 1) ? 1 : 0
							)
						);
						
						$recid = DB::insertId();
						
						DB::query("UPDATE supplier SET supplier_code=%s WHERE id=%i", "S".str_pad($recid, 5, '0', STR_PAD_LEFT), $recid);
						
						
						DB::commit();
						
						$successsave="New Supplier Successfully Saved!";
						
						unset($_POST['supplierfocus']);
						unset($_POST['suppliername']);
						unset($_POST['status']);
						unset($_POST['addressline1']);
						unset($_POST['addressline2']);
						unset($_POST['addressline3']);
						unset($_POST['postalcode']);
						unset($_POST['city']);
						unset($_POST['country']);
						unset($_POST['phone']);
						unset($_POST['fax']);
						unset($_POST['email']);
						unset($_POST['bank']);
						unset($_POST['branch']);
						unset($_POST['accountnumber']);
						unset($_POST['firstname']);
						unset($_POST['lastname']);
						unset($_POST['contactphone']);
						unset($_POST['contactemail']);
						unset($_POST['recversion']);
					}
					catch(MeekroDBException $e)
					{
						$err = $err."Critical Error Occured!<br>";
						$err = $err.$e->getMessage()."<br>";
						$err = $err.$e->getQuery()."<br>";
						DB::rollback();
						DB::$error_handler = 'meekrodb_error_handler';
						DB::$throw_exception_on_error = false;
					}
				}
				else
				{
					try
					{
						$trxnConnextn = new MeekroDB();
						$nonTrxnConnextn = new MeekroDB();
						
						$trxnConnextn->startTransaction();
						$trxnConnextn->query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
						$trxnConnextn->query("SELECT * FROM supplier WHERE id=%i FOR UPDATE", $_POST['supplierfocus']);
						
						$trxnConnextn->update
						('supplier', 
							array
							(
								'updated_date' => $trxnConnextn->sqleval("current_timestamp()"),
								'updated_by' => $_SESSION['connecteduserid'], 
								'supplier_name' => (trim($_POST['suppliername']) != "") ? trim($_POST['suppliername']) : NULL,
								'address_line1' => (trim($_POST['addressline1']) != "") ? trim($_POST['addressline1']) : NULL,
								'address_line2' => (trim($_POST['addressline2']) != "") ? trim($_POST['addressline2']) : NULL,
								'address_line3' => (trim($_POST['addressline3']) != "") ? trim($_POST['addressline3']) : NULL,
								'postal_code' => (trim($_POST['postalcode']) != "") ? trim($_POST['postalcode']) : NULL,
								'city' => (trim($_POST['city']) != "") ? trim($_POST['city']) : NULL,
								'country' => (trim($_POST['country']) != "") ? trim($_POST['country']) : NULL,
								'telephone_number' => (trim($_POST['phone']) != "") ? trim($_POST['phone']) : NULL,
								'fax' => (trim($_POST['fax']) != "") ? trim($_POST['fax']) : NULL,
								'supplier_email' => (trim($_POST['email']) != "") ? trim($_POST['email']) : NULL,
								'supplier_bank' => (trim($_POST['bank']) != "") ? trim($_POST['bank']) : NULL,
								'bank_branch_name' => (trim($_POST['branch']) != "") ? trim($_POST['branch']) : NULL,
								'bank_account_code' => (trim($_POST['accountnumber']) != "") ? trim($_POST['accountnumber']) : NULL,
								'contact_first_name' => (trim($_POST['firstname']) != "") ? trim($_POST['firstname']) : NULL,
								'contact_last_name' => (trim($_POST['lastname']) != "") ? trim($_POST['lastname']) : NULL,
								'contact_telephone_number' => (trim($_POST['contactphone']) != "") ? trim($_POST['contactphone']) : NULL,
								'contact_email' => (trim($_POST['contactemail']) != "") ? trim($_POST['contactemail']) : NULL,
								'supplier_status' => ($_POST['status'] == 1) ? 1 : 0,
								'version' => ($_POST['recversion'] + 1)
							), 
							"id=%i", $_POST['supplierfocus']
						);
						
						$supplierversionrow = $nonTrxnConnextn->queryFirstRow("SELECT version FROM supplier WHERE id=%i LIMIT 1", $_POST['supplierfocus']);
						
						if($supplierversionrow['version'] == $_POST['recversion'])
						{						
							$trxnConnextn->commit();
?>
							<script>
								location.href="suppliers.php";
							</script>
<?php
							exit();
						}
						else
						{
							$trxnConnextn->rollback();
							$err = "Supplier Details Could Not Be Updated Due To Updates Just Done By Another System User!<br>";
						}
					}
					catch(MeekroDBException $e)
					{
						$err = $err."Critical Error Occured!<br>";
						$err = $err.$e->getMessage()."<br>";
						$err = $err.$e->getQuery()."<br>";
						$trxnConnextn->rollback();
						DB::$error_handler = 'meekrodb_error_handler';
						DB::$throw_exception_on_error = false;
					}
				}
			}
		}
		else
		{
			$err = $err."Limited Acccess!<br>";
		}
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Supplier Setup</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="card-header with-border text-center">
							<h3 class="card-title">Supplier Setup Form</h3>
						</div>
						
						<div class="card-body">
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="fa fa-ban-circle"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<?php
								if($successsave!="")
								{
							?>
							<div class="alert alert-success alert-dismissable">
								<i class="fa fa-ok"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
								<?php 
									echo $successsave; 
								?>
							</div>
							<?php
								}
							?>
							<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" enctype="multipart/form-data">
								<INPUT name="supplierfocus" id="supplierfocus" type=hidden value="<?php echo isset($_POST['supplierfocus']) ? $_POST['supplierfocus'] : 0 ?>">
								<INPUT name="recversion" id="recversion" type=hidden value="<?php echo isset($_POST['recversion']) ? $_POST['recversion'] : 0 ?>">
							<div class="row">
								<div class="col-sm-6">
									<div class="form-group">
										<label for="suppliername">Supplier Name</label>
										<input type="text" name="suppliername" id="suppliername" maxlength="100" class="form-control" value="<?php echo isset($_POST['suppliername']) ? $_POST['suppliername'] : "" ?>" >
									</div><!-- form-group -->
									
									<div class="form-group">
										<label for="status">Status</label>
										<select  class="form-control" name="status" id="status" data-placeholder="Choose One">
											<option value="">Choose One</option>
											<option <?php if(isset($_POST['status']) && "1"==$_POST['status']) echo "selected=\"selected\""; ?> value="1">Active</option>
											<option <?php if(isset($_POST['status']) && "0"==$_POST['status']) echo "selected=\"selected\""; ?> value="0">Inactive</option>
										</select>
									</div><!-- form-group -->
									
									<div class="row">
									<div class="form-group col-sm-6">
										<label for="addressline1">Address Line 1</label>
										<input type="text" name="addressline1" id="addressline1" maxlength="95" class="form-control" value="<?php echo isset($_POST['addressline1']) ? $_POST['addressline1'] : "" ?>" >
									</div><!-- form-group -->
									
									<div class="form-group col-sm-6">
										<label for="addressline2">Address Line 2</label>
										<input type="text" name="addressline2" id="addressline2" maxlength="95" class="form-control" value="<?php echo isset($_POST['addressline2']) ? $_POST['addressline2'] : "" ?>" >
									</div><!-- form-group -->
									</div>
									<div class="row">
									<div class="form-group col-sm-6">
										<label for="addressline3">Address Line 3</label>
										<input type="text" name="addressline3" id="addressline3" maxlength="95" class="form-control" value="<?php echo isset($_POST['addressline3']) ? $_POST['addressline3'] : "" ?>" >
									</div><!-- form-group -->
									
									<div class="form-group col-sm-6">
										<label for="postalcode">Postal Code</label>
										<input type="text" name="postalcode" id="postalcode" maxlength="95" class="form-control" value="<?php echo isset($_POST['postalcode']) ? $_POST['postalcode'] : "" ?>" >
									</div><!-- form-group -->
									</div>
									
									<div class="row">
										<div class="form-group col-sm-6">
											<label for="city">City/Town</label>
											<input type="text" name="city" id="city" maxlength="95" class="form-control" value="<?php echo isset($_POST['city']) ? $_POST['city'] : "" ?>" >
										</div><!-- form-group -->
										
										<div class="form-group col-sm-6">
											<label for="country">Country</label>
											<input type="text" name="country" id="country" maxlength="95" class="form-control" value="<?php echo isset($_POST['country']) ? $_POST['country'] : "" ?>" >
										</div><!-- form-group -->
									</div>
								</div>
								
								<div class="col-sm-6">									
									<div class="row">
										<div class="form-group col-sm-6">
											<label for="phone">Telephone Number</label>
											<input type="text" name="phone" id="phone" maxlength="45" class="form-control" value="<?php echo isset($_POST['phone']) ? $_POST['phone'] : "" ?>" >
										</div><!-- form-group -->
										
										<div class="form-group col-sm-6">
											<label for="fax">Fax Number</label>
											<input type="text" name="fax" id="fax" maxlength="45" class="form-control" value="<?php echo isset($_POST['fax']) ? $_POST['fax'] : "" ?>" >
										</div><!-- form-group -->
									</div>
								
									<div class="row">
									<div class="form-group col-sm-6">
										<label for="email">Email Address</label>
										<input type="text" name="email" id="email" maxlength="95" class="form-control" value="<?php echo isset($_POST['email']) ? $_POST['email'] : "" ?>" >
									</div><!-- form-group -->
									
									<div class="form-group col-sm-6">
										<label for="bank">Bank</label>
										<input type="text" name="bank" id="bank" maxlength="95" class="form-control" value="<?php echo isset($_POST['bank']) ? $_POST['bank'] : "" ?>" >
									</div><!-- form-group -->
									</div>
									
									<div class="row">
										<div class="form-group col-sm-6">
											<label for="branch">Bank Branch</label>
											<input type="text" name="branch" id="branch" maxlength="45" class="form-control" value="<?php echo isset($_POST['branch']) ? $_POST['branch'] : "" ?>" >
										</div><!-- form-group -->
										
										<div class="form-group col-sm-6">
											<label for="accountnumber">Bank Account Number</label>
											<input type="text" name="accountnumber" id="accountnumber" maxlength="45" class="form-control" value="<?php echo isset($_POST['accountnumber']) ? $_POST['accountnumber'] : "" ?>" >
										</div><!-- form-group -->
									</div>
									
									<div class="row">
										<div class="form-group col-sm-6">
											<label for="firstname">Contact Person First Name</label>
											<input type="text" name="firstname" id="firstname" maxlength="45" class="form-control" value="<?php echo isset($_POST['firstname']) ? $_POST['firstname'] : "" ?>" >
										</div><!-- form-group -->
										
										<div class="form-group col-sm-6">
											<label for="lastname">Contact Person Last Name</label>
											<input type="text" name="lastname" id="lastname" maxlength="45" class="form-control" value="<?php echo isset($_POST['lastname']) ? $_POST['lastname'] : "" ?>" >
										</div><!-- form-group -->
									</div>
									
									<div class="row">
										<div class="form-group col-sm-6">
											<label for="contactphone">Contact Person Telephone</label>
											<input type="text" name="contactphone" id="contactphone" maxlength="45" class="form-control" value="<?php echo isset($_POST['contactphone']) ? $_POST['contactphone'] : "" ?>" >
										</div><!-- form-group -->
										
										<div class="form-group col-sm-6">
											<label for="contactemail">Contact Person Email</label>
											<input type="text" name="contactemail" id="contactemail" maxlength="45" class="form-control" value="<?php echo isset($_POST['contactemail']) ? $_POST['contactemail'] : "" ?>" >
										</div><!-- form-group -->
									</div>
								</div>
							</div>
						</div><!-- /.card-body -->
						
						<div class="card-footer">
							
							<div class="btn-list">
							<div class="text-right">
								<a href="suppliers.php" class="btn btn-danger"><i class="fa fa-remove"></i> Cancel</a>
								
								<button type="submit" name="savedatabtn" id="savedatabtn" class="btn btn-success"><i class="fa fa-floppy-disk"></i> Save</button>
							</div>
							</div>
						</div><!-- /.card-footer-->
							</form>
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->

		<?php include ('includes/general_footer.php')?>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/shopsetup.js" type="text/javascript"></script>
	</body>
</html>