<?php
	include("includes/dbconfig.php");
	$pagetitle = "Change Password";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$successsave="";
	
	if(isset($_POST['savedatabtn']))
	{
		if(trim($_POST['oldkey']) == "")
		{
			$err = $err."Old Password Required!<br>";
		}
		else
		{
			$pass = md5(trim($_POST['oldkey']));
			$pass= password_hash(trim($_POST['oldkey']), PASSWORD_BCRYPT);
			$userexists = DB::queryFirstField("SELECT COUNT(id) FROM personnel_details WHERE id=%i AND password=%s", $_SESSION["connecteduserid"], $pass);
			
			if($userexists != 1)
			{
				$err = $err."Invalid Old Password Entered!<br>";
			}
		}		
		
		if (trim($_POST['kisumuluzo'])=="")
			$err = $err."New Password Required!<br>";
			
		if (trim($_POST['damuekisumuluzo'])=="")
			$err = $err."Confirm New Password Required!<br>";
			
		if(trim($_POST['kisumuluzo'])!="" && trim($_POST['damuekisumuluzo'])!="")
		{
			if(strlen(trim($_POST['kisumuluzo'])) < 8)
			{
				$err = $err."Password With 8 Or More Characters Permitted!<br>";
			}
			else
			{
				if(!preg_match('/[\'^!$%&*()}{@#~?><>,|=_+-]/', trim($_POST['kisumuluzo'])) || !preg_match('/[0-9]/', trim($_POST['kisumuluzo'])))
				{
					$err = $err."Password With Atleast One Digit And Special A Character Permitted!<br>";
				}
				else
				{
					if(strcmp(trim($_POST['kisumuluzo']), trim($_POST['damuekisumuluzo'])) != 0)
						$err = $err."Password And Confirm Password Should Be The Same!<br>";
				}
			}
			
		}
		
		if($err == "")
		{
			DB::$error_handler = false;
			DB::$throw_exception_on_error = true;
		
			try
			{
				$pass = md5(trim($_POST['kisumuluzo']));
				 $pass= password_hash(trim($_POST['kisumuluzo']), PASSWORD_BCRYPT);
				DB::startTransaction();
				DB::query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
				DB::query("UPDATE personnel_details SET updated_date = current_timestamp(), updated_by=%i, password=%s, password_change = (password_change + 1), version = (version + 1) WHERE id=%i", $_SESSION["connecteduserid"], $pass, $_SESSION["connecteduserid"]);
			
				DB::commit();
				$successsave= "Password Successfully Updated";
				
				unset($_POST['oldkey']); 
				unset($_POST['kisumuluzo']); 
				unset($_POST['damuekisumuluzo']);
			}
			catch(MeekroDBException $e)
			{
				$err = $err."Critical Error Occured!<br>";
				$err = $err.$e->getMessage()."<br>";
				$err = $err.$e->getQuery()."<br>";
				DB::rollback();
				DB::$error_handler = 'meekrodb_error_handler';
				DB::$throw_exception_on_error = false;
			}

		}
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h4>Change Password</h4>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<div class="card-header with-border text-center">
							<h3 class="card-title">Change Password Form</h3>
						</div>
						
						<div class="card-body">
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="glyphicon glyphicon-ban-circle"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<?php
								if($successsave!="")
								{
							?>
							<div class="alert alert-success alert-dismissable">
								<i class="glyphicon glyphicon-ok"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
								<?php 
									echo $successsave; 
								?>
							</div>
							<?php
								}
							?>
							<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
								<INPUT name="userfocus" id="userfocus" type=hidden value="<?php echo isset($_POST['userfocus']) ? $_POST['userfocus'] : 0 ?>">
								<INPUT name="recversion" id="recversion" type=hidden value="<?php echo isset($_POST['recversion']) ? $_POST['recversion'] : 0 ?>">
							
								<div class="form-group">
									<label for="oldkey">Old Password</label>
									<input type="password" name="oldkey" id="oldkey" maxlength="80" class="form-control" value="<?php echo isset($_POST['oldkey']) ? $_POST['oldkey'] : "" ?>" >
								</div><!-- form-group -->
								
								<div class="form-group">
									<label for="kisumuluzo">New Password</label>
									<input type="password" name="kisumuluzo" id="kisumuluzo" maxlength="50" class="form-control" value="<?php echo isset($_POST['kisumuluzo']) ? $_POST['kisumuluzo'] : "" ?>" >
								</div><!-- form-group -->
								
								<div class="form-group">
									<label for="damuekisumuluzo">Confirm New Password</label>
									<input type="password" name="damuekisumuluzo" id="damuekisumuluzo" maxlength="50" class="form-control" value="<?php echo isset($_POST['damuekisumuluzo']) ? $_POST['damuekisumuluzo'] : "" ?>" >
								</div><!-- form-group -->
						</div><!-- /.card-body -->
						
						<div class="card-footer">
							
							<div class="btn-list">
								<div class="text-right">
									<button type="submit" name="savedatabtn" id="savedatabtn" class="btn btn-success"><i class="glyphicon glyphicon-floppy-disk"></i> Save</button>
								</div>
							</div>
						</div><!-- /.card-footer-->
							</form>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->

 
		
		
			<?php include ('includes/general_footer.php')?>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		
	</body>

</html>