<?php
	header('Content-Type: application/json');
	include("includes/dbconfig.php");
	
	session_write_close();
	
	$err = "";
	
	$server_response = array();
	
	$tag = $_POST['tag'];
	$recversion = $_POST['recversion'];
	
	$tagname = "";
	
	if(isset($_SESSION['connecteduserid']))
	{
		if($_SESSION["connectedusergroup"] == 1)
		{
			if($tag > 0)
			{
				$tagdata = DB::queryFirstRow("SELECT tag_name FROM gl_tag WHERE id=%i", $tag);
			
				if(DB::count() != 1)
				{
					$err = $err."Tag Not Identified!<br>";
				}
				else
				{
					$tagname = $tagdata['tag_name'];
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
	else
	{
		$err = $err."Un Authenticated User Access Detected!<br>";
	}

	if($err == "")
	{
		try
		{
		
			$gltagformdata = '<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
							<h4 class="modal-title text-center">GL Tag Setup Form</h4>
						</div>
						<div class="modal-body">
							<div id="gltagerrormessage">
							</div>
							
							<div class="form-group">
								<label for="tagname">Tag Name</label>
								<input type="text" name="tagname" id="tagname" class="form-control" value="' . $tagname . '" >
							</div><!-- form-group -->
							
						</div>
						
						<div id="notesfooter" class="modal-footer">
							<a href="" data-dismiss="modal" class="btn btn-danger"><i class="fa fa-times"></i> Close</a>
							<button name="savetagbtn" id="savetagbtn" class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
							
						</div>
						
						<!-- AdminLTE App -->
						<script src="js/AdminLTE/app.js" type="text/javascript"></script>
						<!-- AdminLTE for demo purposes -->
						<script src="js/AdminLTE/demo.js" type="text/javascript"></script>
						
						<script>
							$("#tagmodal").on("hidden.bs.modal", function (e){
								$("#gltagerrormessage").html("");
							});
							
							$("#tagmodal").on("shown.bs.modal", function (e){
								$("#tagname").focus();
							});
							
							$("#savetagbtn").click(function()
							{
								var err = "";
								
								$("#gltagerrormessage").html("");
								
								if($("#tagname").val().trim()=="")
									err += "Tag Name Required!<br>";
								
								if(err == "")
								{
									$("#gltagerrormessage").html("");
								
									$.ajax
									(
										{
											url: "gltagsave.php",
											async: false, 
											type: "POST",
											dataType: "json",
											data: {tagname: $("#tagname").val().trim(), tag: ' . $tag . ', recversion: ' . $recversion . '},
											success: function(json)
											{
												if(json[0].issaved == 0)
												{
													$("#gltagerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" + json[0].message + "</div>");
												}
												else
												{
													$("#gltagerrormessage").html("<div class=\"alert alert-success\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" + json[0].message + "</div>");
													location.href="gltagsview.php";
												}
											},
											error: function(jqXHR, exception)
											{	
												if (jqXHR.status === 0) 
												{
													$("#gltagerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Not Connected Verify Network.</div>");
												} 
												else if (jqXHR.status == 404) 
												{
													$("#gltagerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested Operation Not Found.</div>");
												} 
												else if (jqXHR.status == 500) 
												{
													$("#gltagerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Internal Server Error.</div>");
												} 
												else if (exception === "parsererror") 
												{
													$("#gltagerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested JSON Parse Failed.</div>");
												} 
												else if (exception === "timeout") 
												{
													$("#gltagerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Time Out Error.</div>");
												} 
												else if (exception === "abort") 
												{
													$("#gltagerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Ajax Request Aborted.</div>");
												} 
												else 
												{
													$("#gltagerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Uncaught Error " + jqXHR.responseText + ".</div>");
												}
											}
										}
									);
									
								}
								else
								{
									$("#gltagerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" + err + "</div>");
								}
							});
						</script>';
	
			$server_response[] = array('isdataobtained' => 1, 'message' => $gltagformdata);
			echo json_encode($server_response);
		}
		catch(Exception $e)
		{
			$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Tag Setup Form Load Error Occured. Try Again</div>";
			
			$server_response[] = array('isdataobtained' => 0, 'message' => $errormessage);
			echo json_encode($server_response);
			exit();
		}
		
	}
	else
	{
		$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>".$err."</div>";
		
		$server_response[] = array('isdataobtained' => 0, 'message' => $errormessage);
		echo json_encode($server_response);
	}
?>