<?php
	header('Content-Type: application/json');
	include("includes/dbconfig.php");
	
	session_write_close();
	
	$err = "";
	
	$server_response = array();
	
	$stockitem = $_POST['stockitem'];
		
	if(isset($_SESSION['connecteduserid']))
	{
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
		{
			if($stockitem == "")
			{
				$err = $err."Item Identification Required!<br>";
			}
			else
			{
				$stockitemdata = DB::queryFirstRow("SELECT stock_item.item_name, stock_item.item_code, item_batch.batch_code, item_batch.manufacture_date, item_batch.expiry_date, item_batch.is_active FROM item_batch INNER JOIN stock_item ON item_batch.item = stock_item.id WHERE item_batch.id=%i", $stockitem);
			
				if(DB::count() != 1)
				{
					$err = $err."Stock Item Not Identified!<br>";
				}
				else
				{
					$status = ($stockitemdata['is_active'] == 1) ? "Active" : "Inactive";
					$manufacture = date("d-m-Y", strtotime($stockitemdata['manufacture_date']));
					$expiry = date("d-m-Y", strtotime($stockitemdata['expiry_date']));
					
					$stockleveldata = DB::query("SELECT shop.full_name, item_stock_level.quantity, item_stock_level.is_active FROM item_stock_level LEFT JOIN shop ON item_stock_level.shop = shop.id WHERE item_stock_level.batch=%i", $stockitem);
										
					$stocktable = '<table class="table table-hover">
										<thead>
											<tr>
												<th>Location</th>
												<th class="text-right">Quantity</th>
												<th class="text-right">Status</th>
											</tr>
										</thead>											
										<tbody>';
					
					$totalstock = 0;
					
					foreach($stockleveldata as $location)
					{
						$locationname = ($location['full_name'] == "") ? "Store" : $location['full_name'];
					
						$stockstatus = ($location['is_active'] == 1) ? '<label class="label label-success" >Active</label>' : '<label class="label label-danger" >Inactive</label>';
						
						$totalstock += $location['quantity'];
						
						$stocktable .= '<tr>
											<td>'.$locationname.'</td>
											<td class="text-right">'.number_format($location['quantity'], 2).'</td>
											<td class="text-right">'.$stockstatus.'</td>
										</tr>';
					}

					$stocktable .= '</tbody>
									<tfoot>
										<tr>
											<th>Total</th>
											<th class="text-right">'.number_format($totalstock, 2).'</th>
											<th class="text-right"></th>
										</tr>
									</tfoot>
								</table>';
			
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
	else
	{
		$err = $err."Un Authenticated User Access Detected!<br>";
	}

	if($err == "")
	{
		try
		{
			$adjustmentformdata = '<div class="modal-header">
									<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
									<h4 class="modal-title text-center">Batch Distribution Information</h4>
								</div>
								
								<div class="modal-body">
									<div class="row col-sm-12">
										<div class="col-sm-3">
											<b>Item Name </b>
										</div>
										
										<div class="col-sm-9">
											'.$stockitemdata['item_name'].'
										</div>
									</div>
									
									<div class="col-md-12" style="margin-top: 5px"></div>
									
									<div class="row">
										<div class="col-sm-6">
											<div class="col-sm-7">
												<b>Barcode </b>
											</div>
								
											<div class="col-sm-5">
												'.$stockitemdata['batch_code'].'
											</div>
										</div>
										
										<div class="col-sm-6">
											<div class="col-sm-7">
												<b>Status </b>
											</div>
								
											<div class="col-sm-5">
												'.$status.'
											</div>
										</div>
									</div>
									
									<div class="col-md-12" style="margin-top: 5px"></div>
									
									<div class="row">
										<div class="col-sm-6">
											<div class="col-sm-7">
												<b>Manufatcured Date </b>
											</div>
								
											<div class="col-sm-5">
												'.$manufacture.'
											</div>
										</div>
										
										<div class="col-sm-6">
											<div class="col-sm-7">
												<b>Expiry Date </b>
											</div>
								
											<div class="col-sm-5">
												'.$expiry.'
											</div>
										</div>
									</div>
									
									<div id="distributiontable">
									'.$stocktable.'
									</div>
								</div>
								
								<div id="notesfooter" class="modal-footer">
									<a href="" data-dismiss="modal" class="btn btn-danger"><i class="fa fa-times"></i> Close</a>
								</div>
								
								<!-- AdminLTE App -->
								<script src="dist/js/app.min.js" type="text/javascript"></script>
								<!-- AdminLTE for demo purposes -->
								<script src="dist/js/demo.js" type="text/javascript"></script>
								<!-- SlimScroll -->
								<script src="plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
								<script>
									$("#distributiontable").slimscroll({
										height: "200px",
										color: "#428bca"
									});
								</script>';
						
	
			$server_response[] = array('isdataobtained' => 1, 'message' => $adjustmentformdata);
			echo json_encode($server_response);
		}
		catch(Exception $e)
		{
			$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Batch Distribution Information Display Load Error Occured. Try Again</div>";
			$server_response[] = array('isdataobtained' => 0, 'message' => $errormessage);
			echo json_encode($server_response);
			exit();
		}
		
	}
	else
	{
		$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>".$err."</div>";
		$server_response[] = array('isdataobtained' => 0, 'message' => $errormessage);
		echo json_encode($server_response);
	}
?>