<?php
	include("includes/dbconfig.php");
	$pagetitle = "Cash Receipt View";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	if(isset($_POST['receiptfocus']))
	{
		if(DB::queryFirstField("SELECT COUNT(id) FROM cash_receipt WHERE id=%i", $_POST['receiptfocus']) != 1)
		{
			$err = $err."Receipt Not Identified!<br>";
		}
		else
		{
			if(DB::queryFirstField("SELECT COUNT(id) FROM cash_sale_item WHERE receipt=%i", $_POST['receiptfocus']) == 0)
			{
				$err = $err."Receipt Items Not Identified!<br>";
			}
			else
			{
				$shopdata = DB::queryFirstRow("SELECT full_name, logo_file, address_line_1, address_line_2, address_line_3, zip_code, city, country, tin, phone, fax, email FROM shop WHERE id=%i", $_SESSION["connecteduserbranch"]);
				
				if(DB::count() != 1)
				{
					$err = $err."Shop Not Identified!<br>";
				}
				else
				{
					$detailedreceiptaddress = "";
					$detailedcontactinfo = "";
					
					if(trim($shopdata['address_line_1']) != "")
						$detailedreceiptaddress = $detailedreceiptaddress.trim($shopdata['address_line_1'])."<br>";
					if(trim($shopdata['address_line_2']) != "")
						$detailedreceiptaddress = $detailedreceiptaddress.trim($shopdata['address_line_2'])."<br>";
					if(trim($shopdata['address_line_3']) != "")
						$detailedreceiptaddress = $detailedreceiptaddress.trim($shopdata['address_line_3'])."<br>";
						
					if(trim($shopdata['zip_code']) != "")
						$detailedcontactinfo = $detailedcontactinfo."P.O Box ".trim($shopdata['zip_code']);
					if(trim($shopdata['city']) != "")
						$detailedcontactinfo = $detailedcontactinfo." ".trim($shopdata['city']);
					if(trim($shopdata['country']) != "")
						$detailedcontactinfo = $detailedcontactinfo." - ".trim($shopdata['country'])."<br>";
					
					if(trim($shopdata['phone']) != "")
						$detailedcontactinfo = $detailedcontactinfo.'<i class="glyphicon glyphicon-earphone"></i>: '.trim($shopdata['phone']).'<br>';
					if(trim($shopdata['fax']) != "")
						$detailedcontactinfo = $detailedcontactinfo.'<i class="fa fa-fax"></i>: '.trim($shopdata['fax']).'<br>';
					if(trim($shopdata['email']) != "")
						$detailedcontactinfo = $detailedcontactinfo.'<i class="glyphicon glyphicon-envelope"></i>: '.trim($shopdata['email']).'<br>';
						
					$receipt = DB::queryFirstRow("SELECT personnel_details.display_name, personnel_details.first_name, cash_receipt.created_date, cash_receipt.value_date, cash_receipt.receipt_number, cash_receipt.customer_name, cash_receipt.amount, cash_receipt.customer_change, cash_receipt.memo, cash_receipt.is_cancelled FROM cash_receipt LEFT JOIN  personnel_details ON cash_receipt.created_by = personnel_details.id WHERE cash_receipt.id=%i AND cash_receipt.shop=%i", $_POST['receiptfocus'], $_SESSION["connecteduserbranch"]);
					
					$receiptitems = DB::query("SELECT stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.description, item_batch.batch_code, item_batch.manufacture_date, item_batch.expiry_date, cash_sale_item.sell_price, cash_sale_item.quantity FROM cash_sale_item INNER JOIN item_stock_level ON cash_sale_item.price_id = item_stock_level.id INNER JOIN stock_item ON item_stock_level.item = stock_item.id LEFT JOIN item_batch ON item_stock_level.batch = item_batch.id WHERE cash_sale_item.shop=%i AND cash_sale_item.receipt=%i", $_SESSION["connecteduserbranch"], $_POST['receiptfocus']);
					
					$receiptitemscompact = DB::query("SELECT stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.description, item_batch.batch_code, item_batch.manufacture_date, item_batch.expiry_date, cash_sale_item.sell_price, SUM(cash_sale_item.quantity) AS quantity FROM cash_sale_item INNER JOIN item_stock_level ON cash_sale_item.price_id = item_stock_level.id INNER JOIN stock_item ON item_stock_level.item = stock_item.id LEFT JOIN item_batch ON item_stock_level.batch = item_batch.id WHERE cash_sale_item.shop=%i AND cash_sale_item.receipt=%i GROUP BY cash_sale_item.price_id", $_SESSION["connecteduserbranch"], $_POST['receiptfocus']);

				}
			}
		}
	}
	else
	{
		$err= $err."Receipt Identification Required!<br>";
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Cash Receipt View</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<?php 
						if($err == "")
						{
					?>
					<!-- Default box -->
					<div class="row">
						<div class="col-md-8">
							<div class="box box-primary" id="saledetails" style="height: 500px;">
								<div class="box-body">
									<div id="detailedreceipt">										
										<div class="text-center">
											<b>CASH RECEIPT</b>
										</div>										
										<hr>
										
										<div class="row">
											<div class="col-sm-6">
												<div class="col-sm-4">
													<div style="height: 100px width: 100px">
														<img class="img-thumbnail" id="itemphoto" src="<?php echo ($shopdata['logo_file'] != "") ? "images/shoplogos/" . $shopdata['logo_file'] : "images/shoplogos/noimage.gif" ?>" alt="..." style="width: 100%;max-height: 100%">
													</div>
												</div>
												
												<div class="invoice-col col-sm-8">
													<address>
														<strong><?php echo $shopdata['full_name']; ?></strong><br>
															<?php echo $detailedreceiptaddress; ?>												
													</address>
												</div>
												
												<div class="invoice-col col-sm-12">
													<address>
														<?php echo $detailedcontactinfo; ?>
														TIN:<?php echo $shopdata['tin']; ?><br>
													</address>
												</div>
											</div>
											
											<div class="col-sm-6 pull-right">
												<div class="pull-right">
													M/S <b><?php echo $receipt['customer_name']; ?></b><br>
													<b>Receipt No:</b> <?php echo $receipt['receipt_number']; ?><br>
													<b>Date:</b> <?php echo date("d-m-Y H:i", strtotime($receipt['created_date'])); ?><br>
												</div>
												
											</div>
										</div>
										
										<table class="table table-hover">
											<thead>
												<tr>
													<th>Item</th>
													<th>Description</th>
													<th class="text-center">Quantity</th>
													<th class="text-right">Price</th>
													<th class="text-right">Amount</th>
												</tr>
											</thead>											
											<tbody>
												<?php
													$itemscount = 0;
													$itemstotalcost = 0;
													
													foreach($receiptitemscompact as $receiptitemscompactrow)
													{
														$userowtotal = ($receiptitemscompactrow['quantity'] * $receiptitemscompactrow['sell_price']);
														
														$itemscount += $receiptitemscompactrow['quantity'];
														$itemstotalcost += $userowtotal;
												?>
												<tr>
													<td style="vertical-align:middle;"><?php echo substr($receiptitemscompactrow['item_name'], 0, 200); ?></td>
													<td style="vertical-align:middle;"><?php echo substr($receiptitemscompactrow['description'], 0, 400); ?></td>
													<td class="text-center" style="vertical-align:middle;"><?php echo $receiptitemscompactrow['quantity']; ?></td>
													<td class="text-right" style="vertical-align:middle;"><?php echo number_format($receiptitemscompactrow['sell_price'], 2); ?></td>
													<td class="text-right" style="vertical-align:middle;"><?php echo number_format($userowtotal, 2); ?></td>
												</tr>
												<?php
														if($receiptitemscompactrow['batch_code'] != "")
														{
												?>
												<tr>
													<td style="vertical-align:middle;" colspan="5"><?php echo "<b>Batch Code:</b> <i>".$receiptitemscompactrow['batch_code']."</i> <b>Manufactured Date:</b> <i>".date("d-m-Y", strtotime($receiptitemscompactrow['manufacture_date']))."</i> <b>Expiry Date:</b> <i>".date("d-m-Y", strtotime($receiptitemscompactrow['expiry_date']))."</i>"; ?></td>
												</tr>	
												<?php
														}
													}
												?>
											</tbody>
											<tfoot>
												<tr>
													<th>Totals</th>
													<th></th>
													<th class="text-center"><?php echo number_format($itemscount, 2); ?></th>
													<th class="text-right"></th>
													<th class="text-right"><?php echo number_format($itemstotalcost, 2); ?></th>
												</tr>
											</tfoot>
										</table>
										<div class="row">
											<div class="col-xs-6">
											</div>
											 
											<div class="col-xs-6">
												<table class="table table-hover pull-right">
													<tr>
														<td class="lead">Cash Paid</td>
														<td class="text-center lead"><b>:</b></td>
														<td class="text-right lead"><?php echo number_format($receipt['amount'], 2); ?></td>
													</tr>
													<tr>
														<td class="lead">Change</td>
														<td class="text-center lead"><b>:</b></td>
														<td class="text-right lead"><?php echo number_format($receipt['customer_change'], 2); ?></td>
													</tr>
												</table>
											</div>										
										</div>
										
										<div class="text-center">
											Goods once sold will not be taken back or exchanged<br>
											<b>Thank you. Please come again.</b><br>
											Served By:<b><?php echo $receipt['display_name']; ?></b><br>
										</div>
									</div>
								</div><!-- /.box-body -->
								
								<div class="box-footer">
									<div class="btn-list col-md-12 text-center">
										<a href="cashsalesregister.php" class="btn btn-danger"><i class="glyphicon glyphicon-remove"></i> Cancel</a>
										
										<button onclick="gendawano('cashsalesregisterreceiptdetail_print', 'receiptfocus', <?php echo $_POST['receiptfocus']; ?>)" class="btn btn-primary"><i class="glyphicon glyphicon-print"></i> Print</button>
									</div>
								</div><!-- /.box-footer-->
							</div><!-- /.box -->
						</div>
						
						<div class="col-md-4">
							<div class="box box-success" id="salesummary" style="height: 500px;">
								<div class="box-body">
									<div id="slimreceipt">
										<div class="text-center" style="height: 40px width: 40px">
											<img class="img-thumbnail" id="logo" src="<?php echo ($shopdata['logo_file'] != "") ? "images/shoplogos/" . $shopdata['logo_file'] : "images/shoplogos/noimage.gif" ?>" alt="..." style="width: 20%;max-height: 20%">
										</div>
										
										<div class="text-center">
											<b><?php echo $shopdata['full_name']; ?></b><br>
											<?php echo $detailedreceiptaddress; ?>
											<?php echo $detailedcontactinfo; ?>
											<b>TIN:</b> <?php echo $shopdata['tin']; ?><br>
											<b>CASH SALE:</b> <?php echo $receipt['customer_name']; ?><br>
											<b>Receipt No:</b> <?php echo $receipt['receipt_number']; ?> <b>Date:</b> <?php echo date("d-m-Y H:i", strtotime($receipt['created_date'])); ?><br>
										</div>
										
										<table class="table table-hover">
											<thead>
												<tr>
													<th>Item</th>
													<th class="text-center">Qty</th>
													<th class="text-right">Price</th>
													<th class="text-right">Amount</th>
												</tr>
											</thead>											
											<tbody>
												<?php
													$itemscount = 0;
													$itemstotalcost = 0;
													foreach($receiptitems as $receiptrow)
													{  
														$userowtotal = ($receiptrow['quantity'] * $receiptrow['sell_price']);
														
														$itemscount += 1;
														$itemstotalcost += $userowtotal;
												?>
												<tr>
													<td><?php echo substr($receiptrow['item_name'], 0, 15); ?></td>
													<td class="text-center"><?php echo $receiptrow['quantity']; ?></td>
													<td class="text-right"><?php echo number_format($receiptrow['sell_price'], 2); ?></td>
													<td class="text-right"><?php echo number_format($userowtotal, 2); ?></td>
												</tr>
												<?php
														if($receiptrow['batch_code'] != "")
														{
												?>
												<tr>
													<td colspan="4" ><?php echo "Man. Date: ".date("d-m-Y", strtotime($receiptrow['manufacture_date']))." Exp. Date: ".date("d-m-Y", strtotime($receiptrow['expiry_date'])); ?></td>
												</tr>
												<?php
														}
													}
												?> 
											</tbody>
											<tfoot>
												<tr>
													<th>Totals</th>
													<th class="text-center"><?php echo $itemscount; ?></th>
													<th class="text-right"></th>
													<th class="text-right"><?php echo number_format($itemstotalcost, 2); ?></th>
												</tr>
											</tfoot>
										</table>
										
										<table class="table table-hover">
											<tr>
												<td class="lead"><b>Paid</b></td>
												<td class="text-center lead"><b>:</b></td>
												<td class="text-right lead"><b><?php echo number_format($receipt['amount'], 2); ?></b></td>
											</tr>
											<tr>
												<td class="lead"><b>Change</b></td>
												<td class="text-center lead"><b>:</b></td>
												<td class="text-right lead"><b><?php echo number_format($receipt['customer_change'], 2); ?></b></td>
											</tr>
										</table>
										
										<div class="text-center">
											Goods once sold will not be taken back or exchanged<br>
											<b>Thank you. Please come again.</b><br>
											Served By:<b><?php echo $receipt['display_name']; ?></b><br>
										</div>
									</div>									
							
								</div><!-- /.box-body -->
								<div class="box-footer">
									<div class="btn-list col-md-12 text-center">
										<a href="cashsalesregister.php" class="btn btn-danger"><i class="glyphicon glyphicon-remove"></i> Cancel</a>
										
										<button onclick="gendawano('cashsalesregisterreceiptslim_print', 'receiptfocus', <?php echo $_POST['receiptfocus']; ?>)" class="btn btn-primary"><i class="glyphicon glyphicon-print"></i> Print</button>
									</div>
								</div><!-- /.box-footer-->
							</div><!-- /.box -->
						</div>
					</div>
					<?php
						}
						else
						{
					?>
					<div class="alert alert-danger alert-dismissable">
						<i class="glyphicon glyphicon-ban-circle"></i><br>
						<?php 
							echo $err; 
						?>
					</div>
					<?php
						}
					?>
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<!-- jQuery 2.1.3 -->
		<script src="plugins/jQuery/jQuery-2.1.3.min.js"></script>
		<!-- Bootstrap 3.3.2 JS -->
		<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
		<!-- FastClick -->
		<script src='plugins/fastclick/fastclick.min.js'></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		
		<script src="plugins/bert/jquery.price_format.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/cashsalesregisterreceiptview.js" type="text/javascript"></script>
	</body>
</html>