<?php
	header('Content-Type: application/json');
	include("includes/dbconfig.php");
	
	session_write_close();
	
	$err = "";
	
	$server_response = array();
	
	$category = $_POST['category'];
	$recversion = $_POST['recversion'];
	
	$catname = "";
	$catdescription = "";
	
	if(isset($_SESSION['connecteduserid']))
	{
		if($_SESSION["connectedusergroup"] == 1)
		{
			if($category > 0)
			{
				$catdata = DB::queryFirstRow("SELECT category_name, category_description FROM item_category WHERE id=%i", $category);
			
				if(DB::count() != 1)
				{
					$err = $err."Category Not Identified!<br>";
				}
				else
				{
					$catname = $catdata['category_name'];
					$catdescription = $catdata['category_description'];
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
	else
	{
		$err = $err."Un Authenticated User Access Detected!<br>";
	}

	if($err == "")
	{
		try
		{
		
			$categoryformdata = '<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
							<h4 class="modal-title text-center">Item Category Setup Form</h4>
						</div>
						<div class="modal-body">
							<div id="categoryerrormessage">
							</div>
							
							<div class="form-group">
								<label for="catname">Category Name</label>
								<input type="text" name="catname" id="catname" class="form-control" value="' . $catname . '" maxlength="95" >
							</div><!-- form-group -->
							
							<div class="form-group">
								<label for="catname">Description</label>
								<textarea name="catdescription" id="catdescription" class="form-control" rows="3" maxlength="195" >'.$catdescription.'</textarea>
							</div><!-- form-group -->
                      
						</div>
						
						<div id="notesfooter" class="modal-footer">
							<a href="" data-dismiss="modal" class="btn btn-danger"><i class="fa fa-times"></i> Close</a>
							<button name="savetagbtn" id="savebtn" class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
							
						</div>
						
						<!-- AdminLTE App -->
						<script src="dist/js/app.min.js" type="text/javascript"></script>
						<!-- AdminLTE for demo purposes -->
						<script src="dist/js/demo.js" type="text/javascript"></script>
						
						<script>
							$("#mediummodal").on("hidden.bs.modal", function (e){
								$("#categoryerrormessage").html("");
							});
							
							$("#mediummodal").on("shown.bs.modal", function (e){
								$("#catname").focus();
							});
							
							$("#savebtn").click(function()
							{
								var err = "";
								
								$("#categoryerrormessage").html("");
								
								if($("#catname").val().trim()=="")
									err += "Category Name Required!<br>";
								
								if(err == "")
								{
									$("#categoryerrormessage").html("");
								
									$.ajax
									(
										{
											url: "categorysetupsave.php",
											async: false, 
											type: "POST",
											dataType: "json",
											data: {catname: $("#catname").val().trim(), catdescription: $("#catdescription").val().trim(), category: ' . $category . ', recversion: ' . $recversion . '},
											success: function(json)
											{
												if(json[0].issaved == 0)
												{
													$("#categoryerrormessage").html(json[0].message);
												}
												else
												{
													$("#categoryerrormessage").html(json[0].message);
													location.href="category.php";
												}
											},
											error: function(jqXHR, exception)
											{	
												if (jqXHR.status === 0) 
												{
													$("#categoryerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Not Connected Verify Network.</div>");
												} 
												else if (jqXHR.status == 404) 
												{
													$("#categoryerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested Operation Not Found.</div>");
												} 
												else if (jqXHR.status == 500) 
												{
													$("#categoryerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Internal Server Error.</div>");
												} 
												else if (exception === "parsererror") 
												{
													$("#categoryerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested JSON Parse Failed.</div>");
												} 
												else if (exception === "timeout") 
												{
													$("#categoryerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Time Out Error.</div>");
												} 
												else if (exception === "abort") 
												{
													$("#categoryerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Ajax Request Aborted.</div>");
												} 
												else 
												{
													$("#categoryerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Uncaught Error " + jqXHR.responseText + ".</div>");
												}
											}
										}
									);
									
								}
								else
								{
									$("#categoryerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" + err + "</div>");
								}
							});
						</script>';
	
			$server_response[] = array('isdataobtained' => 1, 'message' => $categoryformdata);
			echo json_encode($server_response);
		}
		catch(Exception $e)
		{
			$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Category Setup Form Load Error Occured. Try Again</div>";
			$server_response[] = array('isdataobtained' => 0, 'message' => $errormessage);
			echo json_encode($server_response);
			exit();
		}
		
	}
	else
	{
		$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>".$err."</div>";
		$server_response[] = array('isdataobtained' => 0, 'message' => $errormessage);
		echo json_encode($server_response);
	}
?>