<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>QR Code Scanner</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
      html,
      body {
        padding: 0;
        margin: 0;
        font-family: Arial, Helvetica, sans-serif;
      }
      .wrapper {
        padding: 0 4rem;
      }
      #canvas {
        position: absolute;
      }
      #scanned {
        display: flex;
        flex-direction: column;
        gap:1rem;
      }
      #video-wrapper {
        height: 480px;
        position: relative;
        border-radius: 10px;
        overflow: hidden;
      }
    </style>
  </head>
  <body>

   

  <div id="reader" width="480px" height="200px"></div>
  <input type='text' id='search'> 

  <button onclick="StartSkan();"> Search button</button>

  <script src="https://unpkg.com/html5-qrcode@2.0.9/dist/html5-qrcode.min.js"></script>

  <script src=" https://kampanisbc.com/pos//mod/plugins/jquery/jquery.min.js"></script>

 

  <SCRIPT>

   function StartSkan(){
 const html5QrCode = new Html5Qrcode("reader");
const qrCodeSuccessCallback = (decodedText, decodedResult) => {
    

    alert(decodedText);
    $('#search').val(decodedText);


    html5QrCode.stop().then((ignore) => {
  // QR Code scanning is stopped.
}).catch((err) => {
  // Stop failed, handle it.
});
};
const config = { fps: 10, qrbox: { width: 300, height: 150 } };
 
html5QrCode.start({ facingMode: { exact: "environment"} }, config, qrCodeSuccessCallback);

   }
 

    </SCRIPT>
   
  </body>
</html>