<?php
	header('Content-Type: application/json');
	include('my_functions.php');
	
	$percentage = 1- Commission_settings(  2)/100; 
	 
	
	$err = "";
	
	$server_response = array();
	
	$itemsearchtext = trim($_POST['itemsearchtext']);

	if(isset($_SESSION['connecteduserid']))
	{
		if($_SESSION["connectedusergroup"] == 3 || $_SESSION["connectedusergroup"] == 4)
		{
			if($itemsearchtext == "")
			{
				$err = $err."Item Identification Required!<br>";
			}
			else
			{				
				$pricedata = DB::query("SELECT item_price.id, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, item_price.item, item_price.sell_price FROM item_price INNER JOIN stock_item ON item_price.item = stock_item.id AND stock_item.item_code=%s  WHERE item_price.shop=%i UNION SELECT item_price.id, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, item_price.item, item_price.sell_price FROM item_price INNER JOIN stock_item ON item_price.item = stock_item.id AND stock_item.item_name LIKE %ss WHERE item_price.shop=%i ORDER BY item_name", $itemsearchtext, $_SESSION["connecteduserbranch"], $itemsearchtext, $_SESSION["connecteduserbranch"]);
					
				if(DB::count() > 0)
				{
					
				}
				else
				{
					$err = $err."Item Not Identified!<br>";
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
	else
	{
		$err = $err."Un Authenticated User Access Detected!<br>";
	}
	
	if($err == "")
	{
		$searchresults = '<table id="stockitemstable" class="table table-striped">
								<thead>
									<tr>
										<th>Image</th>
										<th>Name</th>
										<th>Code</th>
										<th>Barcode</th>
										<th class="text-right">Sell Price</th>
										<th class="text-center">Actions</th>
									</tr>
								</thead>
								<tfoot>
									<tr>
										<th>Image</th>
										<th>Name</th>
										<th>Code</th>
										<th>Barcode</th>
										<th class="text-right">Sell Price</th>
										<th class="text-center">Actions</th>
									</tr>
								</tfoot>
								<tbody>';
								
		foreach($pricedata as $row)
		{
			$itemimage = ($row['item_image_file'] != "") ? "images/stockitemimage/" . $row['item_image_file'] : "images/stockitemimage/noimage.gif";
			
			$searchresults .= '<tr>
									<td style="width: 6%; vertical-align:middle;">
										<img class="img-thumbnail" id="logo" src="'.$itemimage.'" alt="..." style="width: 100%;max-height: 100%">
									</td>
									<td style="vertical-align:middle;">'.$row["item_name"].'</td>
									<td style="vertical-align:middle;">'.$row["item_code"].'</td>
									<td style="vertical-align:middle;">'.$row["bar_code"].'</td>
									<td style="vertical-align:middle;" class="text-right">'.number_format($row["sell_price"]*$percentage, 2).'</td>
									<td style="vertical-align:middle;" class="text-center">
										<a href="javascript:void(0);" onclick="addtocart(\''.$row["id"].'\', \''.addslashes($row["item_name"]).'\', \''.number_format($row["sell_price"]*$percentage, 2).'\')" data-toggle="tooltip" title="Add Item To Cart" class="tooltips"><span class="label label-primary" ><i class="fa fa-plus"></i></span></a>
									</td>
								</tr>';
		}
		
		$searchresults .= '</tbody>
						</table>
						<!-- AdminLTE App -->
						<script src="dist/js/app.min.js" type="text/javascript"></script>
						<!-- AdminLTE for demo purposes -->
						<script src="dist/js/demo.js" type="text/javascript"></script>
						<script>
							addtocart = function(priceid, itemname, itemprice)
							{
								var itemrow = "<tr><td style=\"display:none;\">"+priceid+"</td><td>"+itemname+"</td><td></td><td class=\"text-right\">"+itemprice+"</td><td class=\"text-right\">1</td><td class=\"text-right\">"+itemprice+"</td><td class=\"text-right\"><a href=\"javascript:void(0);\" onclick=\"itemupdate(this)\" data-toggle=\"tooltip\" title=\"Edit Cart Item\" class=\"tooltips\"><span class=\"label label-primary\" ><i class=\"fa fa-edit\"></i></span></a> <a href=\"javascript:void(0);\" onclick=\"itemdelete(this)\" data-toggle=\"tooltip\" title=\"Delete Cart Item\" class=\"tooltips\"><span class=\"label label-danger\" ><i class=\"fa fa-trash\"></i></span></a></td></tr>";
								
								$("#cartitemstable > tbody:last-child").append(itemrow);
								document.getElementById("itemcode").value = "";
								
								$("#cartitemslist").slimscroll({scrollTo: "350px"});
								
								var numberofcartitems = 0.00;
								var totalbill = 0.00;
									
								$("#cartitemstable").children("tbody").children("tr").each(function(i) 
								{
									$tr = $(this);
									var useindex = 0;

									$("td", $tr).each(function() 
									{
										if(useindex == 4)
										{
											numberofcartitems += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
										}
										
										if(useindex == 5)
										{
											totalbill += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
										}
										
										useindex +=1;
									});
								});
								
								$("#itemscount").html("<b>"+numberofcartitems+"</b>");
								$("#cost").html("<b>"+totalbill.toLocaleString()+" UGX</b>");
								document.getElementById("cashpaidin").value = "";
								$("#clientbalance").html("<b>0 UGX</b>");
							}
						</script>';
		
		$server_response[] = array('isdataobtained' => 1, 'message' => $searchresults);
		echo json_encode($server_response);
	}
	else
	{
		$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" . $err . "</div>";
		$server_response[] = array('isdataobtained' => 0, 'message' => $errormessage);
		echo json_encode($server_response);
	}
?>