<?php
	include("includes/dbconfig.php");
	$pagetitle = "GL Accounts View";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>GL Accounts View</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default box -->
					<div class="box box-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="box-header with-border text-center">
							<h3 class="box-title">GL Accounts List</h3>
						</div>
						
						<div class="box-body">
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="glyphicon glyphicon-ban-circle"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<div id="servererrormessage">
							</div>
							
							<div class="box-body table-responsive no-padding">
								<table class="table table-hover">
									<thead>
										<tr>
											<th>GL Account Type</th>
											<th>GL Account Name</th>
											<th>GL Account Number</th>
											<th class="text-center">Action</th>
										</tr>
									</thead>
									<?php
										$glaccounttypedata = DB::query("SELECT id, gl_class_name FROM gl_class ORDER BY id");

										if(DB::count() > 0)
										{
											foreach($glaccounttypedata as $glaccounttype)
											{
									?>
									<tr>
										<td><?php echo $glaccounttype['gl_class_name']; ?></td>
										<td></td>
										<td></td>
										<td></td>
									</tr>
									<?php
												$glaccountsdata = DB::query("SELECT gl_chartmaster.id, gl_chartmaster.account_code, gl_chartmaster.account_name, gl_chartmaster.version FROM gl_chartmaster WHERE gl_chartmaster.account_class=%i ORDER BY gl_chartmaster.account_code", $glaccounttype['id']);
												
												if(DB::count() > 0)
												{
													foreach($glaccountsdata as $glaccount)
													{
									?>
									<tr>
										<td></td>
										<td><?php echo $glaccount['account_name']; ?></td>
										<td><?php echo $glaccount['account_code']; ?></td>
										<td class="text-center">
											<a href="javascript:void(0);" onclick="gendawano('glaccountsetup', 'glaccountfocus', '<?php echo $glaccount['id']; ?>')" data-toggle="tooltip" title="Edit GL Account" class="tooltips"><span class="label label-primary" ><i class="glyphicon glyphicon-edit"></i></span></a>&nbsp;&nbsp;
											<a href="javascript:void(0);" onclick="deleteglaccount(<?php echo $glaccount['id']; ?>, <?php echo $glaccount['version']; ?>)" data-toggle="tooltip" title="Delete GL" class="tooltips"><span class="label label-danger" ><i class="glyphicon glyphicon-trash"></i></span></a>
										</td>
									</tr>
									<?php
													}
												}
											}
										}
									?>
								</table>
							</div><!-- /.box-body -->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="glyphicon glyphicon-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.box -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->

		<!-- jQuery 2.1.3 -->
		<script src="plugins/jQuery/jQuery-2.1.3.min.js"></script>
		<!-- Bootstrap 3.3.2 JS -->
		<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
		<!-- FastClick -->
		<script src='plugins/fastclick/fastclick.min.js'></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/jquery.price_format.min.js" type="text/javascript"></script>
		<script src="plugins/bert/glaccountsview.js" type="text/javascript"></script>
	</body>
</html>