<?php
	include("includes/dbconfig.php");
	$pagetitle = "GL Payment";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$successsave="";
	
	if(isset($_POST['savedatabtn']))
	{
		if($_SESSION["connectedusergroup"] == 1)
		{
			if(trim($_POST['valuedate'])=="")
			{
				$err = $err."Transaction Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['valuedate'], 0, 2);
				$day = substr($_POST['valuedate'], 3, 2);
				$year = substr($_POST['valuedate'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid Transaction Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['valuedate']))) > date("Y-m-d"))
						$err = $err."Future Transaction Date Not Supported.<br>";
				}
			}
		
			if($_POST['payoutgl'] == "")
				$err = $err."Cash/Bank Account Required!<br>";

			if($_POST['trxntype'] == "")
				$err = $err."Transaction Type Required!<br>";
			
			if(trim($_POST['payoutgldesc'])=="")
				$err = $err."Description On Cash/Bank Account Required!<br>";
			
			if($_POST['glaccount'] == "")
			{
				$err = $err."General Ledger Account Required!<br>";
			}
			else
			{
				if($_POST['payoutgl'] != "" && ($_POST['payoutgl'] == $_POST['glaccount']))
					$err = $err."General Ledger Account Different From Cash/Bank Account Required!<br>";
			}
			
			if (trim($_POST['trxnamount'])=="")
			{
				$err = $err."Amount Required!<br>";
			}
			else
			{
				if(!is_numeric(trim($_POST['trxnamount'])))
				{
					$err = $err."Numeric Amount Required!<br>";
				}
				else
				{
					if(trim($_POST['trxnamount']) <= 0)
						$err = $err."Numeric Amount Greater Than Zero Required!<br>";
				}
			}
			
			if(trim($_POST['paidgldesc'])=="")
				$err = $err."Description On General Ledger Account Required!<br>";
			
			if($err == "")
			{
				DB::$error_handler = false;
				DB::$throw_exception_on_error = true;
			
				try
				{
					DB::startTransaction();
					DB::query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
					
					DB::insert
					('gl_trxnref', 
						array
						(
							'created_date' => date("Y-m-d H:i:s"),
							'created_by' => $_SESSION['connecteduserid'], 
							'authorised_by' => 0,
							'amount' => trim($_POST['trxnamount'])
						)
					);
					
					$trxnref = DB::insertId();
					
					DB::insert
					('gl_gltrxn', 
						array
						( 
							'created_date' => date("Y-m-d H:i:s"),
							'value_date' => (trim($_POST['valuedate']) != "") ? date("Y-m-d", strtotime(trim($_POST['valuedate']))) : NULL,
							'created_by' => $_SESSION['connecteduserid'], 
							'chartmaster' => $_POST['glaccount'],
							'trxn_type' => $_POST['trxntype'],
							'trxn_ref' => $trxnref,
							'cheque_number' => (trim($_POST['chqnumber'])!="" && trim($_POST['chqnumber']) > 0) ? trim($_POST['chqnumber']) : NULL,
							'trxn_desc' => trim($_POST['paidgldesc']),
							'trxn_amount' => trim($_POST['trxnamount']),
							'tag' => (isset($_POST['trxntag']) && $_POST['trxntag'] > 0) ? $_POST['trxntag'] : 0
						)
					);
					
					DB::insert
					('gl_gltrxn', 
						array
						( 
							'created_date' => date("Y-m-d H:i:s"),
							'value_date' => (trim($_POST['valuedate']) != "") ? date("Y-m-d", strtotime(trim($_POST['valuedate']))) : NULL,
							'created_by' => $_SESSION['connecteduserid'], 
							'chartmaster' => $_POST['payoutgl'],
							'trxn_type' => $_POST['trxntype'],
							'trxn_ref' => $trxnref,
							'cheque_number' => (trim($_POST['chqnumber'])!="" && trim($_POST['chqnumber']) > 0) ? trim($_POST['chqnumber']) : NULL,
							'trxn_desc' => trim($_POST['payoutgldesc']),
							'trxn_amount' => (trim($_POST['trxnamount']) * -1),
							'tag' => (isset($_POST['trxntag']) && $_POST['trxntag'] > 0) ? $_POST['trxntag'] : 0
						)
					);
					
					DB::commit();

					$successsave="General Ledger Payment Transaction Successfully Posted.";
					unset($_POST['valuedate']);
					unset($_POST['payoutgl']);
					unset($_POST['trxntype']);
					unset($_POST['chqnumber']);
					unset($_POST['payoutgldesc']);
					unset($_POST['glaccount']);
					unset($_POST['trxntag']); 
					unset($_POST['trxnamount']);
					unset($_POST['paidgldesc']);
				}
				catch(MeekroDBException $e)
				{
					$err = $err."Critical Error Occured!<br>";
					$err = $err.$e->getMessage()."<br>";
					$err = $err.$e->getQuery()."<br>";
					DB::rollback();
					DB::$error_handler = 'meekrodb_error_handler';
					DB::$throw_exception_on_error = false;
				}
			}
		}
		else
		{
			$err = $err."Limited Acccess!<br>";
		}
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>GL Payment</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default box -->
					<div class="box box-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="box-header with-border text-center">
							<h3 class="box-title">GL Payment Form</h3>
						</div>
						
						<div class="box-body">
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="glyphicon glyphicon-ban-circle"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<?php
								if($successsave!="")
								{
							?>
							<div class="alert alert-success alert-dismissable">
								<i class="glyphicon glyphicon-ok"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
								<?php 
									echo $successsave; 
								?>
							</div>
							<?php
								}
							?>
							<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
								<div class="row">
									<div class="col-sm-3">
										<div class="form-group">
											<label for="valuedate">Transaction Date</label>
											<input type="text" value="<?php echo isset($_POST['valuedate']) ? $_POST['valuedate'] : "" ?>" name="valuedate" id="valuedate" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
										</div><!-- form-group -->
									</div>
										
									<div class="col-sm-3">
										<div class="form-group">
											<label for="payoutgl">Cash/Bank Account</label>
											<select  class="form-control" name="payoutgl" id="payoutgl" data-placeholder="Choose One">
												<option value="">Choose One</option>
												<?php
													$glaccountsdata = DB::query("SELECT id, account_name FROM gl_chartmaster WHERE is_money_control=1");
													
													foreach ($glaccountsdata as $glaccount)
													{
												?>
												<option <?php if(isset($_POST['payoutgl']) && $glaccount['id']==$_POST['payoutgl']) echo "selected=\"selected\""; ?> value="<?php echo $glaccount['id']; ?>"><?php echo $glaccount['account_name']; ?></option>
												<?php
													}
												?>
											</select>
										</div><!-- form-group -->
									</div>
									
									<div class="col-sm-3">
										<div class="form-group">
											<label for="trxntype">Transaction Type</label>
											<select  class="form-control" name="trxntype" id="trxntype" data-placeholder="Choose One">
												<option value="">Choose One</option>
												<?php
													$trxntypedata = DB::query("SELECT id, name FROM gl_transaction_type WHERE id IN (2, 4)");
													
													foreach ($trxntypedata as $trxntype)
													{
												?>
												<option <?php if(isset($_POST['trxntype']) && $trxntype['id']==$_POST['trxntype']) echo "selected=\"selected\""; ?> value="<?php echo $trxntype['id']; ?>"><?php echo $trxntype['name']; ?></option>
												<?php
													}
												?>
											</select>
										</div><!-- form-group -->
									</div>
									
									<div class="col-sm-3">
										<div class="form-group">
											<label for="chqnumber">Cheque Number</label>
											<input type="text" name="chqnumber" id="chqnumber" class="form-control" value="<?php echo isset($_POST['chqnumber']) ? $_POST['chqnumber'] : "" ?>" >
										</div><!-- form-group -->
									</div>
									
								</div>
							
								<div class="row">							
									<div class="col-sm-12">
										<div class="form-group">
											<label for="payoutgldesc">Description On Cash/Bank Account</label>
											<input type="text" name="payoutgldesc" id="payoutgldesc" class="form-control" value="<?php echo isset($_POST['payoutgldesc']) ? $_POST['payoutgldesc'] : "" ?>" >
										</div><!-- form-group -->
									</div>
									
								</div>
							
								<div class="row">
									<div class="col-sm-6">
										<div class="form-group">
											<label for="glaccount">General Ledger Account</label>
											<select  class="form-control" name="glaccount" id="glaccount" data-placeholder="Choose One">
												<option value="">Choose One</option>
												<?php
													$glaccountsdata = DB::query("SELECT gl_chartmaster.id, CONCAT(gl_chartmaster.account_code, ' - ', gl_chartmaster.account_name, ' - ', gl_class.gl_class_name) AS gl_account FROM gl_chartmaster, gl_class WHERE gl_chartmaster.account_class = gl_class.id ORDER BY gl_class.id, gl_chartmaster.account_code, gl_chartmaster.account_name");
													
													foreach ($glaccountsdata as $glaccount)
													{
												?>
												<option <?php if(isset($_POST['glaccount']) && $glaccount['id']==$_POST['glaccount']) echo "selected=\"selected\""; ?> value="<?php echo $glaccount['id']; ?>"><?php echo $glaccount['gl_account']; ?></option>
												<?php
													}
												?>
											</select>
										</div><!-- form-group -->
									</div>
										
									<div class="col-sm-3">
										<div class="form-group">
											<label for="trxntag">Tag</label>
											<select  class="form-control" name="trxntag" id="trxntag" data-placeholder="Choose One">
												<option value="">Choose One</option>
												<?php
													$trxntagsdata = DB::query("SELECT id, tag_name FROM gl_tag");
													
													foreach ($trxntagsdata as $trxntag)
													{
												?>
												<option <?php if(isset($_POST['trxntag']) && $trxntag['id']==$_POST['trxntag']) echo "selected=\"selected\""; ?> value="<?php echo $trxntag['id']; ?>"><?php echo $trxntag['tag_name']; ?></option>
												<?php
													}
												?>
											</select>
										</div><!-- form-group -->
									</div>
									
									<div class="col-sm-3">
										<div class="form-group">
											<label for="trxnamount">Amount</label>
											<input type="text" name="trxnamount" id="trxnamount" class="form-control" value="<?php echo isset($_POST['trxnamount']) ? $_POST['trxnamount'] : "" ?>" >
										</div><!-- form-group -->
									</div>
								</div>
							
								<div class="row">							
									<div class="col-sm-12">
										<div class="form-group">
											<label for="paidgldesc">Description On General Ledger Account</label>
											<input type="text" name="paidgldesc" id="paidgldesc" class="form-control" value="<?php echo isset($_POST['paidgldesc']) ? $_POST['paidgldesc'] : "" ?>" >
										</div><!-- form-group -->
									</div>
								</div>						
						</div><!-- /.box-body -->
						
						<div class="box-footer">
							<div class="btn-list">
								<div class="text-right">
									<a href="dashboard.php" class="btn btn-danger"><i class="glyphicon glyphicon-remove"></i> Cancel</a>
									
									<button type="submit" name="savedatabtn" id="savedatabtn" class="btn btn-success"><i class="glyphicon glyphicon-floppy-disk"></i> Save</button>
								</div>
							</div>
						</div><!-- /.box-footer-->
							</form>
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="glyphicon glyphicon-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.box -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->

		<!-- jQuery 2.1.3 -->
		<script src="plugins/jQuery/jQuery-2.1.3.min.js"></script>
		<!-- Bootstrap 3.3.2 JS -->
		<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
		<!-- FastClick -->
		<script src='plugins/fastclick/fastclick.min.js'></script>
		<!-- InputMask -->
		<script src="plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.extensions.js" type="text/javascript"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/jquery.price_format.min.js" type="text/javascript"></script>
		<script src="plugins/bert/glpayment.js" type="text/javascript"></script>
	</body>
</html>