$(function() 
{	
	$('#cartitemslist').slimscroll({
		height: '350px',
		color: "#428bca"
	});
	
	$('#searchresultsdisplay').slimscroll({
		height: '350px',
		color: "#428bca"
	});
	
	$("#stockitemstable").dataTable();
		
	$('#itemcode').on('input', function() 
	{
		$("#servererrormessage").html("");
	});
	
	$("#itemcode").focus();
	
	$("#cashpaidin").priceFormat({
		prefix: "",
		thousandsSeparator: ",",
		centsLimit: 2,
		clearOnEmpty: true
	});
	
	$("#itemquantity").priceFormat({
		prefix: "",
		thousandsSeparator: ",",
		centsLimit: 0,
		clearOnEmpty: true
	});
	
	$("#itemsellprice").priceFormat({
		prefix: "",
		thousandsSeparator: ",",
		centsLimit: 2,
		clearOnEmpty: true
	});
	
	$("#itemcode").keyup(function(e) 
	{
		if (e.keyCode == 13) 
		{
			if($("#itemcode").val().trim()!="")
			{
				$("#servererrormessage").html("");
				
				$.ajax
				(
					{
						url: "getitemsaledetails.php",
						async: false, 
						type: "POST",
						dataType: "json",
						data: {itemcode: $("#itemcode").val().trim()},
						success: function(json)
						{
							if(json[0].isdataobtained == 0)
							{
								$("#servererrormessage").html(json[0].message);
								$('html, body').animate({ scrollTop: 0}, 'slow');
								$("#itemcode").select();
							}
							else
							{
								var itemrow = '<tr><td style="display:none;">'+json[0].priceid+'</td><td>'+json[0].name+'</td><td></td><td class="text-right">'+json[0].price+'</td><td class="text-right">1</td><td class="text-right">'+json[0].price+'</td><td class="text-right"><a href="javascript:void(0);" onclick="itemupdate(this)" data-toggle="tooltip" title="Edit Cart Item" class="tooltips"><span class="label label-primary" ><i class="fa fa-edit"></i></span></a> <a href="javascript:void(0);" onclick="itemdelete(this)" data-toggle="tooltip" title="Delete Cart Item" class="tooltips"><span class="label label-danger" ><i class="fa fa-trash"></i></span></a></td></tr>';
								
								$('#cartitemstable > tbody:last-child').append(itemrow);
								document.getElementById("itemcode").value = "";
								
								$('#cartitemslist').slimscroll({scrollTo: '350px'});
								
								var numberofcartitems = 0.00;
								var totalbill = 0.00;
									
								$("#cartitemstable").children("tbody").children("tr").each(function(i) 
								{
									$tr = $(this);
									var useindex = 0;
				
									$("td", $tr).each(function() 
									{
										if(useindex == 4)
										{
											numberofcartitems += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
										}
										
										if(useindex == 5)
										{
											totalbill += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
										}
										
										useindex +=1;
									});
								});
								
								$("#itemscount").html('<b>'+numberofcartitems+'</b>');
								$("#cost").html('<b>'+totalbill.toLocaleString()+' UGX</b>');
								document.getElementById("cashpaidin").value = "";
								$("#clientbalance").html('<b>0 UGX</b>');
							}
						},
						error: function(jqXHR, exception)
						{	
							if (jqXHR.status === 0) 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Not Connected Verify Network.</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else if (jqXHR.status == 404) 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested Operation Not Found.</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else if (jqXHR.status == 500) 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Internal Server Error.</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else if (exception === "parsererror") 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested JSON Parse Failed" + jqXHR.responseText + ".</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else if (exception === "timeout") 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Time Out Error.</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else if (exception === "abort") 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Ajax Request Aborted.</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							} 
							else 
							{
								$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Uncaught Error " + jqXHR.responseText + ".</div>");
								$('html, body').animate({ scrollTop: 0}, 'slow');
							}
						}
					}
				);
			}
			else
			{
				$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Item Identification Code Required!</div>");
				$('html, body').animate({ scrollTop: 0}, 'slow');
			}
		}
	});

	loadsearchform = function()
	{
		$('#largemodal').modal('show');
	}
	
	$("#largemodal").on("shown.bs.modal", function (e){
		$("#itemsearchtext").focus();
		$("#searchitemerrormessage").html("");
		$("#searchresultsdisplay").html("");
	});
	
	$("#largemodal").on("hidden.bs.modal", function (e){
		document.getElementById("itemsearchtext").value = "";
	});
	
	$("#getitemsbtn").click(function()
	{
		if($("#itemsearchtext").val().trim()!="")
		{
			$("#searchitemerrormessage").html("");
			
			$.ajax
			(
				{
					url: "getpositemsearchresults.php",
					async: false, 
					type: "POST",
					dataType: "json",
					data: {itemsearchtext: $("#itemsearchtext").val().trim()},
					success: function(json)
					{
						if(json[0].isdataobtained == 0)
						{
							$("#searchitemerrormessage").html(json[0].message);
							$("#itemsearchtext").select();
						}
						else
						{
							$("#searchresultsdisplay").html(json[0].message);
						}
					},
					error: function(jqXHR, exception)
					{	
						if (jqXHR.status === 0) 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Not Connected Verify Network.</div>");
						} 
						else if (jqXHR.status == 404) 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested Operation Not Found.</div>");
						} 
						else if (jqXHR.status == 500) 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Internal Server Error.</div>");
						} 
						else if (exception === "parsererror") 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested JSON Parse Failed" + jqXHR.responseText + ".</div>");
						} 
						else if (exception === "timeout") 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Time Out Error.</div>");
						} 
						else if (exception === "abort") 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Ajax Request Aborted.</div>");
						} 
						else 
						{
							$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Uncaught Error " + jqXHR.responseText + ".</div>");
						}
					}
				}
			);
		}
		else
		{
			$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Item Name Or Code Required!</div>");
		}
	});
	
	$('#itemsearchtext').on('input', function() 
	{
		$("#searchitemerrormessage").html("");
		$("#searchresultsdisplay").html("");
	});
	
	$("#itemsearchtext").keyup(function(e) 
	{
		if (e.keyCode == 13) 
		{
			if($("#itemsearchtext").val().trim()!="")
			{
				$("#searchitemerrormessage").html("");
				
				$.ajax
				(
					{
						url: "getpositemsearchresults.php",
						async: false, 
						type: "POST",
						dataType: "json",
						data: {itemsearchtext: $("#itemsearchtext").val().trim()},
						success: function(json)
						{
							if(json[0].isdataobtained == 0)
							{
								$("#searchitemerrormessage").html(json[0].message);
								$("#itemsearchtext").select();
							}
							else
							{
								$("#searchresultsdisplay").html(json[0].message);
							}
						},
						error: function(jqXHR, exception)
						{	
							if (jqXHR.status === 0) 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Not Connected Verify Network.</div>");
							} 
							else if (jqXHR.status == 404) 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested Operation Not Found.</div>");
							} 
							else if (jqXHR.status == 500) 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Internal Server Error.</div>");
							} 
							else if (exception === "parsererror") 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested JSON Parse Failed" + jqXHR.responseText + ".</div>");
							} 
							else if (exception === "timeout") 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Time Out Error.</div>");
							} 
							else if (exception === "abort") 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Ajax Request Aborted.</div>");
							} 
							else 
							{
								$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Uncaught Error " + jqXHR.responseText + ".</div>");
							}
						}
					}
				);
			}
			else
			{
				$("#searchitemerrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Item Name Or Code Required!</div>");
			}
		}
	});
	
	itemupdate = function(t)
	{
		var row = t.parentNode.parentNode;
		$("#servererrormessage").html("");
		$("#itemrowindex").text(row.rowIndex);
		$("#itemnamedisplay").html("<b>"+$("#cartitemstable tr:eq("+row.rowIndex+") td:eq(1)").text()+"</b>");
		$("#itemquantity").val($("#cartitemstable tr:eq("+row.rowIndex+") td:eq(4)").text());
		$("#itemsellprice").val($("#cartitemstable tr:eq("+row.rowIndex+") td:eq(3)").text());
		$("#serialnumbers").val($("#cartitemstable tr:eq("+row.rowIndex+") td:eq(2)").text());
		$('#mediummodal').modal('show');
	}
	
	cartitemrowupdate = function()
	{
		$("#itemediterrormessage").html("");
		
        var err = "";
      
		
		if($("#itemquantity").val() == "")
		{
			err += "Item Quantity Required!<br>";
		}
		else
		{
			if(parseFloat($("#itemquantity").val().replace(/[^0-9\.]/g,"")) <= 0)
				err += "Item Quantity Greater Than Zero Required!<br>";
		}
		
		if($("#itemsellprice").val() == "")
		{
			err += "Item Sell Price Required!<br>";
		}
		else
		{
			if(parseFloat($("#itemsellprice").val().replace(/[^0-9\.]/g,"")) <= 0)
				err += "Item Sell Price Greater Than Zero Required!<br>";
		}
		
		if(err == "")
		{
			var itemcost = (parseFloat($("#itemsellprice").val().replace(/[^0-9\.]/g,"")) * parseFloat($("#itemquantity").val().replace(/[^0-9\.]/g,"")))
			$("#cartitemstable tr:eq("+$("#itemrowindex").text()+") td:eq(2)").text($("#serialnumbers").val());
			$("#cartitemstable tr:eq("+$("#itemrowindex").text()+") td:eq(3)").text($("#itemsellprice").val());
			$("#cartitemstable tr:eq("+$("#itemrowindex").text()+") td:eq(4)").text($("#itemquantity").val());
			$("#cartitemstable tr:eq("+$("#itemrowindex").text()+") td:eq(5)").text(itemcost.toLocaleString());
			
			var numberofcartitems = 0.00;
			var totalbill = 0.00;
				
			$("#cartitemstable").children("tbody").children("tr").each(function(i) 
			{
				$tr = $(this);
				var useindex = 0;

				$("td", $tr).each(function() 
				{
					if(useindex == 4)
					{
						numberofcartitems += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
					}
					
					if(useindex == 5)
					{
						totalbill += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
					}
					
					useindex +=1;
				});
			});
			
			$("#itemscount").html('<b>'+numberofcartitems+'</b>');
            $("#cost").html('<b>'+totalbill.toLocaleString()+' UGX</b>');
            
           

			document.getElementById("cashpaidin").value = "";
			$("#clientbalance").html('<b>0 UGX</b>');
		
			$('#mediummodal').modal('hide');
		}
		else
		{
			$("#itemediterrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" + err + "</div>");
		}
	}
	
	$("#mediummodal").on("shown.bs.modal", function (e){
		$("#itemediterrormessage").html("");
	});

	itemdelete = function(t)
	{
		$("#servererrormessage").html("");
		
		var row = t.parentNode.parentNode;
		
		document.getElementById("cartitemstable").deleteRow(row.rowIndex);
		
		var numberofcartitems = 0.00;
		var totalbill = 0.00;
	
		$("#cartitemstable").children("tbody").children("tr").each(function(i) 
		{
			$tr = $(this);
			var useindex = 0;

			$("td", $tr).each(function() 
			{
				if(useindex == 4)
				{
					numberofcartitems += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
				}
				
				if(useindex == 5)
				{
					totalbill += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
				}
				
				useindex +=1;
			});
		});
		
		$("#itemscount").html('<b>'+numberofcartitems+'</b>');
		$("#cost").html('<b>'+totalbill.toLocaleString()+' UGX</b>');
		$("#itemcode").focus();
		document.getElementById("cashpaidin").value = "";
		$("#clientbalance").html('<b>0 UGX</b>');
	}
	
	cancelsale = function()
	{
		$("#servererrormessage").html("");
		
		$("#cartitemstable > tbody").html("");
		
		var numberofcartitems = 0.00;
		var totalbill = 0.00;
	
		$("#cartitemstable").children("tbody").children("tr").each(function(i) 
		{
			$tr = $(this);
			var useindex = 0;

			$("td", $tr).each(function() 
			{
				if(useindex == 4)
				{
					numberofcartitems += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
				}
				
				if(useindex == 5)
				{
					totalbill += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
				}
				
				useindex +=1;
			});
		});
		
		$("#itemscount").html('<b>'+numberofcartitems+'</b>');
		$("#cost").html('<b>'+totalbill.toLocaleString()+' UGX</b>');
		
		document.getElementById("clientname").value = "";
		document.getElementById("cashpaidin").value = "";
		$("#clientbalance").html('<b>0 UGX</b>');
		$("#memo").val('');
		document.getElementById("itemcode").value = "";
		$("#itemcode").focus();
	}
	
	$('#cashpaidin').on('blur', function() 
	{
		var numberofcartitems = 0.00;
		var totalbill = 0.00;
	
		$("#cartitemstable").children("tbody").children("tr").each(function(i) 
		{
			$tr = $(this);
			var useindex = 0;

			$("td", $tr).each(function() 
			{
				if(useindex == 4)
				{
					numberofcartitems += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
				}
				
				if(useindex == 5)
				{
					totalbill += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
				}
				
				useindex +=1;
			});
		});
		
		$("#itemscount").html('<b>'+numberofcartitems+'</b>');
		$("#cost").html('<b>'+totalbill.toLocaleString()+' UGX</b>');
		
		if($('#cashpaidin').val() != "")
		{
			$("#clientbalance").html('<b>'+(parseFloat($('#cashpaidin').val().replace(/[^0-9\.]/g,"")) - totalbill).toLocaleString()+' UGX</b>');
		}
		else
		{
			$("#clientbalance").html('<b>'+(0 - totalbill).toLocaleString()+' UGX</b>');
		}
		
	});
	
	processcashsale = function()
	{
		var err = "";
		var cartitemsarray = [];
		
		$("#servererrormessage").html("");
		
		var tbody = $("#cartitemstable tbody");

		if (tbody.children().length == 0)
		{
			err += "Cart Items Required!<br>";
		}
		else
		{
			var numberofcartitems = 0.00;
			var totalbill = 0.00;
		
			$("#cartitemstable").children("tbody").children("tr").each(function(i) 
			{
				$tr = $(this);
				var useindex = 0;
				var usepriceid = 0;
				var useitemname = "";
				var useserialnumbers = "";
				var useunitsellprice = 0.00;
				var usequantity = 0;

				$("td", $tr).each(function() 
				{	
					if(useindex == 0)
					{
						usepriceid = $(this).text();
					}
					
					if(useindex == 1)
					{
						useitemname = $(this).text();
					}
					
					if(useindex == 2)
					{
						useserialnumbers = $(this).text();
					}
					
					if(useindex == 3)
					{
						useunitsellprice = parseFloat($(this).text().replace(/[^0-9\.]/g,""));
					}
					
					if(useindex == 4)
					{
						usequantity = parseFloat($(this).text().replace(/[^0-9\.]/g,""));
						numberofcartitems += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
					}
					
					if(useindex == 5)
					{
						if(parseFloat($(this).text().replace(/[^0-9\.]/g,"")) == parseFloat(0))
							err += useitemname+" With Zero Price Is Not Supported. Please Contact Admin To Set Its Price!<br>";
							
						totalbill += parseFloat($(this).text().replace(/[^0-9\.]/g,""));
					}
				
					useindex +=1;
				});
				
				cartitemsarray.push({priceid: usepriceid, itemname: useitemname, serialnumber: useserialnumbers, sellprice: useunitsellprice, quantity: usequantity});
			});
			
			$("#itemscount").html('<b>'+numberofcartitems+'</b>');
            $("#cost").html('<b>'+totalbill.toLocaleString()+' UGX</b>');
            
            if($("#bounce_type").val() == "")
            {
                err += "Item Return  Required!<br>";
            }
            
            if($("#memo").val() == "")
            {
                err += "Explain this return in a memo <br>";
            }
			
			if($('#cashpaidin').val() != "")
			{
				$("#clientbalance").html('<b>'+(parseFloat($('#cashpaidin').val().replace(/[^0-9\.]/g,"")) - totalbill).toLocaleString()+' UGX</b>');
			}
			else
			{
				$("#clientbalance").html('<b>'+(0 - totalbill).toLocaleString()+' UGX</b>');
			}
			
			 
		 
			
			if($('#receiptmode').val() == "")
				err += "Payment Type Required!<br>";
		}

		if(err == "")
		{
			$("#servererrormessage").html("");
			
			$.ajax
			(
				{
					url: "special_sales_save.php",
					async: false, 
					type: "POST",
					dataType: "json",
					data: {bounce_type: $("#bounce_type").val().trim(), customername: $("#clientname").val().trim(), cashpaid: $("#cashpaidin").val().trim(), receiptmode: $('#receiptmode').val(), notes: $("#memo").val().trim(), cartitems: JSON.stringify(cartitemsarray)},
					success: function(json)
					{
						if(json[0].issaved == 0)
						{
							$("#servererrormessage").html(json[0].message);
							$('html, body').animate({ scrollTop: 0}, 'slow');
						}
						else
						{
							$("#servererrormessage").html(json[0].message);
							$('html, body').animate({ scrollTop: 0}, 'slow');
							cancelsale();
							gendawano('special_sales_receipt', 'receiptfocus', json[0].receipt);
						}
					},
					error: function(jqXHR, exception)
					{	
						if (jqXHR.status === 0) 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Not Connected Verify Network.</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else if (jqXHR.status == 404) 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested Operation Not Found.</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else if (jqXHR.status == 500) 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Internal Server Error.</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else if (exception === "parsererror") 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Requested JSON Parse Failed" + jqXHR.responseText + ".</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else if (exception === "timeout") 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Time Out Error.</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else if (exception === "abort") 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Ajax Request Aborted.</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						} 
						else 
						{
							$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Uncaught Error " + jqXHR.responseText + ".</div>");
							$('html, body').animate({ scrollTop: 0}, 'slow');
						}
					}
				}
			);
		}
		else
		{
			$("#servererrormessage").html("<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>"+err+"</div>");
			$('html, body').animate({ scrollTop: 0}, 'slow');
		}
	}
	
});