<?php
	header('Content-Type: application/json');
	include("includes/dbconfig.php");
	
	session_write_close();
	
	$err = "";
	
	/////
	
 
	
	
	
	/////////
	
	$server_response = array();
	
	$cartitems = json_decode(stripslashes($_POST['cartitems']), TRUE);
	$supplier = trim($_POST['supplier']);
	$memo = trim($_POST['memo']);
	
	if(isset($_SESSION['connecteduserid']))
	{
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
		{
			if(empty($cartitems))
			{
				$err = $err."Cart Items Required!<br>";
			}
			else
			{
				foreach($cartitems as $cartitem)
				{
					if($cartitem['quantity'] == 0)
					{
						$err = $err.$cartitem['itemname']." With Zero Quantity Is Not Supported!<br>";
					}
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
	else
	{
		$err = $err."Un Authenticated User Access Detected!<br>";
	}
	
	if($err == "")
	{
		DB::$error_handler = false;
		DB::$throw_exception_on_error = true;
		
		try
		{
			$trxnConnextn = new MeekroDB();
			$nonTrxnConnextn = new MeekroDB();
			
			$trxnConnextn->startTransaction();
			$trxnConnextn->query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
 
			
			foreach($cartitems as $cartitem)
			{
				$itemstockdata = $trxnConnextn->queryFirstRow("SELECT quantity, version FROM item_stock_level WHERE id=%i", $cartitem['stockid']);
				
				$trxnConnextn->update
				('item_stock_level', 
					array
					(
						'updated_date' => date('Y-m-d H:i:s'),
						'updated_by' => $_SESSION["connecteduserid"],
						'quantity' => ($itemstockdata['quantity'] + $cartitem['quantity']),
						'version' => ($itemstockdata['version'] + 1)
					), 
					"id=%i", $cartitem['stockid']
				);
				
				$trxnConnextn->insert
				('stock_item_received', 
					array
					(
						'created_date' => date('Y-m-d H:i:s'),
						'created_by' => $_SESSION["connecteduserid"],
						'value_date' => date("Y-m-d"),
						'goods_received_note' => NULL,
						'item' => $cartitem['stockid'],
						'supplier' => ($supplier == "") ? NULL : $supplier,
						'quantity' => $cartitem['quantity'],
						'memo' => $memo
					)
				);
			}		
			
			$trxnConnextn->commit();
			$savestatusmessage = "<div class=\"alert alert-success\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>Item(s) Successfully Received!</div>";
			$server_response[] = array('issaved' => 1, 'message' => $savestatusmessage);
			DB::$error_handler = 'meekrodb_error_handler';
			DB::$throw_exception_on_error = false;
			echo json_encode($server_response);
		}
		catch(MeekroDBException $e)
		{
			$err = $err.$e->getMessage()."<br>";
			$err = $err.$e->getQuery()."<br>";
			$trxnConnextn->rollback();
			$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" . $err . "</div>";
			$server_response[] = array('issaved' => 0, 'message' => $errormessage);
			DB::$error_handler = 'meekrodb_error_handler';
			DB::$throw_exception_on_error = false;
			echo json_encode($server_response);
			exit();
		}
	}
	else
	{
		$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" . $err . "</div>";
		$server_response[] = array('issaved' => 0, 'message' => $errormessage);
		echo json_encode($server_response);
	}
?>