<?php
	include("includes/dbconfig.php");
	$pagetitle = "Shop Items Quantities";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	$clear = '';
		
	if(isset($_POST['shop']))
	{
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 3)
		{
			if($_SESSION["connectedusergroup"] == 3 && ($_POST['shop'] != $_SESSION["connecteduserbranch"]))
			{
				$err=$err."You Are Not Authorised To Access Stock Information From Other Shops!<br>";
			}
			else
			{
				$clear = $pricedata = DB::query("SELECT item_stock_level.id, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, item_stock_level.quantity, item_stock_level.is_active, item_stock_level.version FROM item_stock_level INNER JOIN stock_item ON item_stock_level.item = stock_item.id LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_stock_level.shop=%i AND item_stock_level.quantity != 0 ORDER BY item_stock_level.is_active DESC, item_category.category_name, stock_item.item_name, stock_item.item_code", $_POST['shop']);
			
				if(DB::count() == 0)
					$err=$err."No Stock List For Selected Shop Found Or All Items Have Zero Balance!<br>";
			}
			
			if($_SESSION["connectedusergroup"] == 1)
			{
				$pricedata = DB::query("SELECT item_stock_level.id, item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, item_stock_level.quantity, item_stock_level.is_active, item_stock_level.version FROM item_stock_level INNER JOIN stock_item ON item_stock_level.item = stock_item.id LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_stock_level.shop=%i AND item_stock_level.quantity != 0 ORDER BY item_stock_level.is_active DESC, item_category.category_name, stock_item.item_name, stock_item.item_code", $_POST['shop']);
			
				if(DB::count() == 0)
					$err=$err."No Stock List For Selected Shop Found Or All Items Have Zero Balance!<br>";
			}
		}
		else
		{
			$err=$err."Limited Access!<br>";
		}
		
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Shop Items Quantities <?php // echo $_POST['shop'];?></h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<?php
		 
							if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 3)
							{
						?>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							
							<div class="row">
								<div class="col-sm-3">
								</div>
								<div class="col-sm-6">
									<div class="form-group">
										<label for="shop">Select Shop</label>
										<select onchange="gendawano('shopquantitiesview', 'shop', $('#shop').val())" class="form-control" name="shop" id="shop" data-placeholder="Choose One">
											<option value="">Choose One</option>
											<?php
												$results = DB::query("SELECT id, full_name FROM shop");
												
												foreach ($results as $row)
												{
											?>
											<option <?php if(isset($_POST['shop']) && $row['id']==$_POST['shop']) echo "selected=\"selected\""; ?> value="<?php echo $row['id']; ?>"><?php echo $row['full_name']; ?></option>
											<?php
												}
											?>
										</select>
									</div><!-- form-group -->
								</div>
								<div class="col-sm-3">
								</div>
							</div>
							
							<?php
								if($err=="" && isset($_POST['shop']))
								{
							?>							
							<!--<div class="col-sm-12">-->
								<h3 class="card-title text-center">Shop Items Quantities</h3>
								<div class="card-body table-responsive no-padding">
									<div class="card-body table-responsive">
										<table id="stockitemstable " class="table   table-bordered table-hoover">
											<thead>
												<tr>
													<th>Image</th>
													<th>Name</th>
													<th>Category</th>
													<th>Code</th>
													<th>Barcode</th>
													<th class="text-right">Quantity</th>
													<th class="text-center">Status</th>
												</tr>
											</thead>
											<tfoot>
												<tr>
													<th>Image</th>
													<th>Name</th>
													<th>Category</th>
													<th>Code</th>
													<th>Barcode</th>
													<th class="text-right">Quantity</th>
													<th class="text-center">Status</th>
												</tr>
											</tfoot>
											<tbody>
												<?php
													foreach($pricedata as $row)
													{
														if($row['is_active'] == 1)
														{
															$status = '<label class="label label-success" >Active</label>';
														}
														else
														{
															$status = '<label class="label label-danger" >Inactive</label>';
														}
												?>
												<tr>
													<td style="width: 6%; vertical-align:middle;">
														<img class="img-thumbnail" id="logo" src="<?php echo ($row['item_image_file'] != "") ? "images/stockitemimage/" . $row['item_image_file'] : "images/stockitemimage/noimage.gif" ?>" alt="..." style="width: 100%;max-height: 100%">
													</td>
													<td style="vertical-align:middle;"><?php echo $row['item_name']; ?></td>
													<td style="vertical-align:middle;"><?php echo $row['category_name']; ?></td>
													<td style="vertical-align:middle;"><?php echo $row['item_code']; ?></td>
													<td style="vertical-align:middle;"><?php echo $row['bar_code']; ?></td>
													<td style="vertical-align:middle;" class="text-right"><?php echo number_format($row['quantity'], 2); ?></td>
													<td style="vertical-align:middle;" class="text-center"><?php echo $status; ?></td>
												</tr>
												<?php
													}
												?>
											</tbody>
										</table>
									</div>
								</div>
							<!--</div>-->
							<?php
								}
								
								if($err != "")
								{
							?>
							<div class="alert alert-danger">
								<i class="fa fa-ban-circle"></i><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
						</div><!-- /.card-body -->
						<div class="card-footer">
							
						</div><!-- /.card-footer-->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			<footer class="main-footer text-center">
				<strong>Copyright &copy; <?php echo date("Y"); ?> BSMPOS.</strong> All rights reserved.
			</footer>
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>

		 <?php include ('includes/general_footer.php')?>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/shopstock.js" type="text/javascript"></script>
	</body>
</html>