<?php
	include("includes/dbconfig.php");
	$pagetitle = "Shop Cash Receipts";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$startdatevalid = false;
	
	if(isset($_POST['getreceiptsbtn']))
	{
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 3)
		{
			
			if($_POST['shop']=="")
			{
				$err = $err."Shop Selection Required!<br>";
			}
			else
			{
				if($_SESSION["connectedusergroup"] == 3 && $_POST['shop'] != $_SESSION["connecteduserbranch"])
					$err = $err."You Are Not Authorised To Access Receipts From Other Shops!<br>";
			}
			
			if(trim($_POST['from'])=="")
			{
				$err = $err."Start Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['from'], 0, 2);
				$day = substr($_POST['from'], 3, 2);
				$year = substr($_POST['from'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid Start Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d"))
					{
						$err = $err."Future Start Date Not Supported.<br>";
					}
					else
					{
						$startdatevalid = true;
					}
				}
			}
			
			if(trim($_POST['to'])=="")
			{
				$err = $err."End Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['to'], 0, 2);
				$day = substr($_POST['to'], 3, 2);
				$year = substr($_POST['to'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid End Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['to']))) > date("Y-m-d"))
					{
						$err = $err."Future End Date Not Supported.<br>";
					}
					else
					{
						if($startdatevalid)
						{
							if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d", strtotime(trim($_POST['to']))))
							{
								$err = $err."Start Date Can Not Be Greater Than The End Date.<br>";
							}
							else
							{
								$receiptsdata = DB::query("SELECT cash_receipt.id,cash_receipt.memo, personnel_details.display_name, cash_receipt.value_date, cash_receipt.receipt_number, cash_receipt.customer_name, cash_receipt.bill, cash_receipt.is_cancelled, cash_receipt.version FROM cash_receipt LEFT JOIN personnel_details ON cash_receipt.created_by = personnel_details.id WHERE cash_receipt.is_cancelled = 0 AND cash_receipt.shop=%i AND cash_receipt.value_date>=%s AND cash_receipt.value_date<=%s ORDER BY personnel_details.display_name, cash_receipt.value_date, cash_receipt.id", $_POST['shop'], date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
								
								if(DB::count() == 0)
									$err = $err."No Cash Receipts Found!<br>";
								
							}
						}
					}
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Shop Cash Receipts</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 3)
							{
						?>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="fa fa-ban"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<div class="card card-info">
              <div class="card-header">
                <h3 class="card-title">Shop Cash Receipts</h3>
              </div>
              <div class="card-body">
			  <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
									
                <div class="row">
                  <div class="col-3">
                    <label for="shop">Select Shop</label>
											<select  class="form-control" name="shop" id="shop" data-placeholder="Choose One">
												<option value="">Choose One</option>
												<?php
													$shopsdata = DB::query("SELECT id, full_name FROM shop");
													
													foreach ($shopsdata as $shoprow)
													{
												?>
												<option <?php if(isset($_POST['shop']) && $shoprow['id']==$_POST['shop']) echo "selected=\"selected\""; ?> value="<?php echo $shoprow['id']; ?>"><?php echo $shoprow['full_name']; ?></option>
												<?php
													}
												?>
											</select>
                  </div>
                  <div class="col-4">
                   <label for="from">Start Date</label>
											<input type="text" value="<?php echo isset($_POST['from']) ? $_POST['from'] : "" ?>" name="from" id="from" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
										
                  </div>
                  <div class="col-5">
                    <label for="to">End Date</label>
											<div class="input-group">
												<input type="text" value="<?php echo isset($_POST['to']) ? $_POST['to'] : "" ?>" name="to" id="to" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
												<span class="input-group-btn">
													<button class="btn btn-primary btn-flat" type="submit" name="getreceiptsbtn" id="getreceiptsbtn">Go!</button>
												</span>
											</div>
                  </div>
                </div>
				</form>
              </div>
              <!-- /.card-body -->
            </div>
							
							<div class="card-body table-responsive no-padding">
								 
								
								<div class="col-md-12" style="margin-top: 25px"></div>
								<div>
								<?php
									if($err=="" && isset($_POST['getreceiptsbtn']))
									{
								?>
								<table   id="receiptstable" class="table  table-bordered table-striped table-responsive">
									<thead>
										<tr>
											<th>Personnel</th>
											<th>No.</th>
											<th>Date</th>
											<th>Receipt Number</th>
											<th>Customer</th>
											<th>Memo</th>
											
											<th class="text-right">Amount</th>
											<th class="text-center">Actions</th>
										</tr>
									</thead>
									<tbody>
									<?php
										$postedby = "";
										$receiptcount = 0;
										$allreceiptscount = 0;
										$receiptgrandtotal = 0;
										
										foreach($receiptsdata as $receiptrow)
										{
											if($postedby != $receiptrow['display_name'])
											{
												$receiptcount = 1;
									?>
										<tr>
											<td><?php echo $receiptrow['display_name']; ?></td>
											<td><?php echo number_format($receiptcount, 0); ?></td>
											<td><?php echo $receiptrow['value_date']; ?></td>
											<td><?php echo $receiptrow['receipt_number']; ?></td>
											<td><?php echo $receiptrow['customer_name']; ?></td>
											<td><?php echo $receiptrow['memo']; ?></td>
											<td class="text-right"><?php echo number_format($receiptrow['bill'], 2); ?></td>
											<td class="text-center">
												<a href="javascript:void(0);" onclick="cancelreceiptform(<?php echo $receiptrow['id'].', '.$receiptrow['version']; ?>)" data-toggle="tooltip" title="Cancel Receipt" class="tooltips"><span class="label label-danger" ><i class="fa fa-remove"></i></span></a> <a href="javascript:void(0);"  onclick="gendawano(<?php echo '\'receiptpreview\', \'receiptfocus\', '.$receiptrow['id']; ?>)" data-toggle="tooltip" title="Receipt Details View" class="tooltips"><span class="label label-primary" ><i class="fa fa-shopping-cart"></i></span></a>
											</td>
										</tr>
									<?php
											}
											else
											{
									?>
										<tr>
											<td></td>
											<td><?php echo number_format($receiptcount, 0); ?></td>
											<td><?php echo $receiptrow['value_date']; ?></td>
											<td><?php echo $receiptrow['receipt_number']; ?></td>
											<td><?php echo $receiptrow['customer_name']; ?></td>
											<td><?php echo $receiptrow['memo']; ?></td>
											<td class="text-right"><?php echo number_format($receiptrow['bill'], 2); ?></td>
											<td class="text-center">
												<a href="javascript:void(0);" onclick="cancelreceiptform(<?php echo $receiptrow['id'].', '.$receiptrow['version']; ?>)" data-toggle="tooltip" title="Cancel Receipt" class="tooltips"><span class="label label-danger" ><i class="fa fa-remove"></i></span></a> <a href="javascript:void(0);"  onclick="gendawano(<?php echo '\'receiptpreview\', \'receiptfocus\', '.$receiptrow['id']; ?>)" data-toggle="tooltip" title="Receipt Details View" class="tooltips"><span class="label label-primary" ><i class="fa fa-shopping-cart"></i></span></a>
											</td>
										</tr>
									<?php
											}
											$postedby = $receiptrow['display_name'];
											$receiptcount += 1;
											
											$allreceiptscount += 1;
											$receiptgrandtotal += $receiptrow['bill'];
										}
									?>
									</tbody>
									<tfoot>
										<tr>
											<th>Totals</th>
											<th><?php echo number_format($allreceiptscount, 0); ?></th>
											<th></th>
											<th></th>
											<th></th>
											<th class="text-right"><?php echo number_format($receiptgrandtotal, 2); ?></th>
											<th class="text-center"></th>
										</tr>
									</tfoot>
								</table>
								<?php
									}
								?>
								</div>
							</div>
						</div><!-- /.card-body -->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="mediummodaldetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<div class="modal" id="largemodal">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="largemodaldetails">
							
						</div>
					</div>
				</div>
			</div>
		</div>

		<?php include ('includes/general_footer.php')?> 
		<script src="plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.extensions.js" type="text/javascript"></script>
		 
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/shopreceiptsview.js" type="text/javascript"></script>
	</body>
</html>