<?php
	include("includes/dbconfig.php");
	$pagetitle = "Stock Items";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	$stocklistfound = FALSE;
	
	if(isset($_POST['getitembtn']))
	{	
		if(trim($_POST['itemsearchtext'])=="")
		{
			$err = $err."Item Name, Code Or Barcode Required!<br>";
		}
		else
		{
			$stockitemsdata = DB::query("SELECT stock_item.id, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, stock_item.description, item_category.category_name, item_unit_measure.measure_name, stock_item.reorder_level, stock_item.default_cost_price, stock_item.default_sell_price, stock_item.status FROM stock_item LEFT JOIN item_category ON stock_item.category = item_category.id LEFT JOIN item_unit_measure ON stock_item.measure_unit = item_unit_measure.id WHERE stock_item.item_name LIKE %ss UNION SELECT stock_item.id, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, stock_item.description, item_category.category_name, item_unit_measure.measure_name, stock_item.reorder_level, stock_item.default_cost_price, stock_item.default_sell_price, stock_item.status FROM stock_item LEFT JOIN item_category ON stock_item.category = item_category.id LEFT JOIN item_unit_measure ON stock_item.measure_unit = item_unit_measure.id WHERE stock_item.item_code=%s UNION SELECT stock_item.id, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, stock_item.description, item_category.category_name, item_unit_measure.measure_name, stock_item.reorder_level, stock_item.default_cost_price, stock_item.default_sell_price, stock_item.status FROM stock_item LEFT JOIN item_category ON stock_item.category = item_category.id LEFT JOIN item_unit_measure ON stock_item.measure_unit = item_unit_measure.id WHERE stock_item.bar_code=%s UNION SELECT stock_item.id, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, stock_item.description, item_category.category_name, item_unit_measure.measure_name, stock_item.reorder_level, stock_item.default_cost_price, stock_item.default_sell_price, stock_item.status FROM stock_item LEFT JOIN item_category ON stock_item.category = item_category.id LEFT JOIN item_unit_measure ON stock_item.measure_unit = item_unit_measure.id WHERE stock_item.alt_barcode=%s ORDER BY category_name, item_name, item_code", trim($_POST['itemsearchtext']), trim($_POST['itemsearchtext']), trim($_POST['itemsearchtext']), trim($_POST['itemsearchtext']));
	
			if(DB::count() == 0)
			{
				$err=$err."No Item Found!<br>";
			}
			else
			{
				$stocklistfound = TRUE;
			}
		}
	}
	
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				 

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							
							<?php
								
								if($err!="")
								{
							?>
							<div class="alert alert-danger">
								<i class="fa fa-ban-circle"></i><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							<div class="row">
								<div class="col-sm-2">
								</div>
								<div class="col-sm-8">
								<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
									
							 		
										<div class="form-group">
											<label for="itemsearchtext">Item</label>
											<div class="input-group">
												<input type="text" value="<?php echo isset($_POST['itemsearchtext']) ? $_POST['itemsearchtext'] : "" ?>" name="itemsearchtext" id="itemsearchtext" class="form-control" placeholder="Enter Item Name, Code Or Barcode" />
												<span class="input-group-btn">
													<button class="btn btn-primary btn-flat" type="submit" name="getitembtn" id="getitembtn">Go!</button>
												</span>
											</div>
										</div><!-- form-group -->
									
								 
								</form>
							</div>
								<div class="col-sm-2">
								</div>
							</div>
							
							<?php
								if($stocklistfound)
								{
							?>
							<h3 class="card-title text-center">Search Result Set Items List</h3>
							<div class="card-body table-responsive no-padding">
								<div class="card-body table-responsive">
									<table id="stockitemstable" class="table table-striped">
										<thead>
											<tr>
												<th>Image</th>
												<th>Name</th>
												<th>Code</th>
												<th>Barcode</th>
												<th>Category</th>
												<th>Unit</th>
												<th>Reorder Level</th>
												<th>Def Cost Price</th>
												<th>Def Sell Price</th>
												<th>Status</th>
												<th class="text-center">Actions</th>
											</tr>
										</thead>
										<tfoot>
											<tr>
												<th>Image</th>
												<th>Name</th>
												<th>Code</th>
												<th>Barcode</th>
												<th>Category</th>
												<th>Unit</th>
												<th>Reorder Level</th>
												<th>Def Cost Price</th>
												<th>Def Sell Price</th>
												<th>Status</th>
												<th class="text-center">Action</th>
											</tr>
										</tfoot>
										<tbody>
											<?php
												$status = "";
									
												foreach($stockitemsdata as $row)
												{
													
														
													if($row['status'] == 1)
													{
														$status = '<label class="label label-success" >Active</label>';
													}
													else
													{
														$status = '<label class="label label-danger" >Inactive</label>';
													}
										
													$action = '<a href="javascript:void(0);" onclick="gendawano(\'itemsetup\', \'itemfocus\', '.$row['id'].')" data-toggle="tooltip" title="Edit Item" class="tooltips"><span class="label label-primary" ><i class="fa fa-edit"></i></span></a> <a href="javascript:void(0);"  data-toggle="tooltip" title="'.$row['description'].'" class="tooltips"><span class="label label-warning" ><i class="fa fa-info-sign"></i></span></a>';
											?>
											<tr>
												<td style="width: 8%; vertical-align:middle;">
													<img class="img-thumbnail" id="logo" src="<?php echo ($row['item_image_file'] != "") ? "images/stockitemimage/" . $row['item_image_file'] : "images/stockitemimage/noimage.gif" ?>" alt="..." style="width: 100%;max-height: 100%">
												</td>
												<td style="vertical-align:middle;"><?php echo $row['item_name']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['item_code']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['bar_code']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['category_name']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['measure_name']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['reorder_level']; ?></td>
												<td style="vertical-align:middle;"><?php echo number_format($row['default_cost_price'], 2); ?></td>
												<td style="vertical-align:middle;"><?php echo number_format($row['default_sell_price'], 2); ?></td>
												<td style="vertical-align:middle;"><?php echo $status; ?></td>
												<td style="vertical-align:middle;" class="text-center"><?php echo $action; ?></td>
											</tr>
											<?php
												}
											?>
										</tbody>
									</table>
								</div>
							</div><!-- /.card-body -->
							<?php
								}
							?>
						<div class="card-footer">
							
						</div><!-- /.card-footer-->
						</div><!-- /.card-body -->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="mediummodaldetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>

		<?php include ('includes/general_footer.php')?>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		 
	</body>
</html>