<?php
	include("includes/dbconfig.php");
	
	DB::$error_handler = false;
	DB::$throw_exception_on_error = true;
	
	try
	{
		$trxnConnextn = new MeekroDB();
		$nonTrxnConnextn = new MeekroDB();
		
		$trxnConnextn->startTransaction();
		$trxnConnextn->query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
		$adjustmentdata = $trxnConnextn->query("SELECT item, quantity FROM stock_item_adjustment WHERE id >= 10435 AND created_by = 1 AND value_date = '2016-06-11' AND shop = 1 AND quantity < 0");
		
		$recordscount = 0;
		
		$totalrecords = $trxnConnextn->count();
		
		foreach($adjustmentdata as $adjustment)
		{
			$recordscount += 1;
			
			$row = $trxnConnextn->queryFirstRow("SELECT quantity FROM item_stock_level WHERE shop=1 AND item=%i", $adjustment['item']);
			
			$currentqty = ($row['quantity']=="") ? 0 : $row['quantity'];
			
			$trxnConnextn->query("UPDATE item_stock_level SET updated_date = current_timestamp(), updated_by = 1, quantity = " . ($currentqty + $adjustment['quantity']) . " WHERE shop = 1 AND item=%i", $adjustment['item']);
			
			echo $recordscount."/".$totalrecords."<br>";
		}
	
		$trxnConnextn->commit();
	}
	catch(MeekroDBException $e)
	{
		$err = $err.$e->getMessage()."<br>";
		$err = $err.$e->getQuery()."<br>";
		$trxnConnextn->rollback();
		echo $err;
		DB::$error_handler = 'meekrodb_error_handler';
		DB::$throw_exception_on_error = false;
		exit();
	}
	
?>