<?php
	include("includes/dbconfig.php");
	$pagetitle = "Store Quantities By Category";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$itemscount = 0;
	
	if(isset($_POST['category']))
	{
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
		{
			$stockitemsdata = DB::query("SELECT item_stock_level.id, stock_item.item_name, stock_item.item_code, stock_item.bar_code, stock_item.item_image_file, item_stock_level.quantity, item_stock_level.is_active FROM item_stock_level INNER JOIN stock_item ON item_stock_level.item = stock_item.id AND stock_item.category=%i WHERE item_stock_level.shop IS NULL ORDER BY stock_item.item_name, stock_item.item_code", $_POST['category']);
		
			if(DB::count() == 0)
				$err=$err."No Stock List For Selected Category Found!<br>";
		}
		else
		{
			$err=$err."Limited Access!<br>";
		}
		
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Store Quantities By Category</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
							{
						?>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							
							<div class="card-body table-responsive no-padding">
								<div class="col-sm-12">
									<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
										<div class="form-group col-sm-4">
										</div>
										
										<div class="form-group col-sm-4">
											<label for="category">Stock Item Category</label>
											<select onchange="gendawano('storequantitiesbycategory', 'category', $('#category').val())" class="form-control" name="category" id="category" data-placeholder="Choose One">
												<option value="">Choose One</option>
												<?php
													$categorydata = DB::query("SELECT id, category_name FROM item_category ORDER BY category_name");
													
													foreach ($categorydata as $category)
													{
												?>
												<option <?php if(isset($_POST['category']) && $category['id']==$_POST['category']) echo "selected=\"selected\""; ?> value="<?php echo $category['id']; ?>"><?php echo $category['category_name']; ?></option>
												<?php
													}
												?>
											</select>
										</div><!-- form-group -->
										
										<div class="form-group col-sm-4">
										</div>
									</form>									
								</div>
								
								<div class="col-md-12" style="margin-top: 25px"></div>
								<?php
									if($err=="" && isset($_POST['category']))
									{
								?>
								<div class="col-sm-12">
									<div class="input-group-btn">
										<button onclick="gendawano('storequantitiesbycategory_print', 'categoryfocus', <?php echo $_POST['category']; ?>)" class="btn btn-sm btn-primary pull-right"><i class="fa fa-print"></i> Print</button>
									</div>
								</div>
								
								<div class="col-md-12" style="margin-top: 25px"></div>
								
								<h3 class="card-title text-center">Items Quantities</h3>
								
								<div class="card-body table-responsive">
									<table id="stockitemstable" class="table table-striped">
										<thead>
											<tr>
												<th>Image</th>
												<th>Name</th>
												<th>Code</th>
												<th>Barcode</th>
												<th>Quantity At Hand</th>
												<th class="text-center">Status</th>
											</tr>
										</thead>
										<tfoot>
											<tr>
												<th>Image</th>
												<th>Name</th>
												<th>Code</th>
												<th>Barcode</th>
												<th>Quantity At Hand</th>
												<th class="text-center">Status</th>
											</tr>
										</tfoot>
										<tbody>
											<?php												
												foreach($stockitemsdata as $row)
												{
													if($row['is_active'] == 1)
													{
														$status = '<label class="label label-success" >Active</label>';
													}
													else
													{
														$status = '<label class="label label-danger" >Inactive</label>';
													}
											?>
											<tr>
												<td style="width: 7%; vertical-align:middle;">
													<img class="img-thumbnail" id="logo" src="<?php echo ($row['item_image_file'] != "") ? "images/stockitemimage/" . $row['item_image_file'] : "images/stockitemimage/noimage.gif" ?>" alt="..." style="width: 100%;max-height: 100%">
												</td>
												<td style="vertical-align:middle;"><?php echo $row['item_name']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['item_code']; ?></td>
												<td style="vertical-align:middle;"><?php echo $row['bar_code']; ?></td>
												<td style="vertical-align:middle;"><?php echo number_format($row['quantity'], 2); ?></td>
												<td style="vertical-align:middle;" class="text-center"><?php echo $status; ?></td>
											</tr>
											<?php
												}
											?>
										</tbody>
									</table>
								</div>
								<?php
									}
									
									if($err != "")
									{
								?>
								<div class="alert alert-danger">
									<i class="fa fa-ban-circle"></i><br>
									<?php 
										echo $err; 
									?>
								</div>
								<?php
									}
								?>
							</div>
							
						</div><!-- /.card-body -->
						<div class="card-footer">
							
						</div><!-- /.card-footer-->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="mediummodaldetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<div class="modal" id="largemodal">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="largemodaldetails">
							
						</div>
					</div>
				</div>
			</div>
		</div>

	<?php include ('includes/general_footer.php')?> 
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script src="plugins/bert/store.js" type="text/javascript"></script>
	</body>
</html>