<?php
	include("includes/dbconfig.php");
	
	$err= "";
	
	if(isset($_POST['categoryfocus']))
	{
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2)
		{
			if(DB::queryFirstField("SELECT COUNT(id) FROM item_category WHERE id=%i", $_POST['categoryfocus']) != 1)
			{
				$err = $err."Category Not Identified!<br>";
			}
			else
			{
				$stockitemsdata = DB::query("SELECT item_category.category_name, stock_item.item_name, stock_item.item_code, stock_item.bar_code, item_stock_level.quantity FROM item_stock_level INNER JOIN stock_item ON item_stock_level.item = stock_item.id AND stock_item.category=%i LEFT JOIN item_category ON stock_item.category = item_category.id WHERE item_stock_level.shop IS NULL ORDER BY stock_item.item_name, stock_item.item_code", $_POST['categoryfocus']);
		
				if(DB::count() == 0)
					$err=$err."No Stock List For Selected Category Found!<br>";
			}
		}
		else
		{
			$err=$err."Limited Access!<br>";
		}
	}
	else
	{
		$err= $err."Category Identification Required!<br>";
	}
?>
<!DOCTYPE html>
<html>
	<head>
	<meta charset="UTF-8">
	<title>Store Quantities By Category</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<!-- Bootstrap 3.3.2 -->
	<link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
	<!-- Font Awesome Icons -->
	<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
	<!-- Ionicons -->
	<link href="http://code.ionicframework.com/ionicons/2.0.0/css/ionicons.min.css" rel="stylesheet" type="text/css" />
	<!-- Theme style -->
	<link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />

	<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
	<!--[if lt IE 9]>
	<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
	<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
	<![endif]-->
	</head>
	<body onload=" window.print();">
		<div class="wrapper">
			<!-- Main content -->
			<section class="content">
				<?php
					if($err == "")
					{
				?>
				
				<h3 class="card-title text-center"><?php echo "Store ".$stockitemsdata[0]['category_name']. " As At ". date("d-m-Y H:i:s"); ?></h3>
			
				<table class="table table-hover">
					<thead>
						<tr>
							<th>Sr.</th>
							<th>Name</th>
							<th>Code</th>
							<th>Barcode</th>
							<th class="text-right">Quantity At Hand</th>
						</tr>
					</thead>											
					<tbody>
						<?php
							$itemscount = 0;
							
							foreach($stockitemsdata as $stockitem)
							{
								$itemscount += 1;
						?>
						<tr>
							<td style="vertical-align:middle;"><?php echo number_format($itemscount, 0); ?></td>
							<td style="vertical-align:middle;"><?php echo $stockitem['item_name']; ?></td>
							<td style="vertical-align:middle;"><?php echo $stockitem['item_code']; ?></td>
							<td style="vertical-align:middle;"><?php echo $stockitem['bar_code']; ?></td>
							<td class="text-right" style="vertical-align:middle;"><?php echo number_format($stockitem['quantity'], 2); ?></td>
						</tr>	
						<?php
							}
						?>
					</tbody>
					<tfoot>
						<tr>
							<th>Sr.</th>
							<th>Name</th>
							<th>Code</th>
							<th>Barcode</th>
							<th class="text-right">Quantity At Hand</th>
						</tr>
					</tfoot>
				</table>
						
				<div class="text-center">
					Report Generated By:<b><?php echo $_SESSION["connecteduserdisplayname"]; ?></b><br>
				</div>
				<?php
					}
					else
					{
				?>
				<div class="alert alert-danger alert-dismissable">
					<i class="fa fa-ban-circle"></i><br>
					<?php 
						echo $err; 
					?>
				</div>
				<?php
					}
				?>
			</section><!-- /.content -->
		</div><!-- ./wrapper -->
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
	</body>
</html>