<?php
	include("includes/dbconfig.php");
	$pagetitle = "Suppliers";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Manage Suppliers</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1)
							{
						?>
						<div class="card-header with-border text-center">
							<h3 class="card-title">Suppiers List</h3>
						</div>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							<div class="card-body table-responsive no-padding">
								<div class="col-sm-12">
									<div class="input-group-btn">
										<a href="suppliersetup.php" class="btn btn-sm btn-primary pull-right"><i class="fa fa-plus"></i> Add Supplier</a>
									</div>
								</div>
								
								<div class="col-md-12" style="margin-top: 25px"></div>
										
								<table class="table table-hover">
									<thead>
										<tr>
											<th>Supplier Name</th>
											<th>Code</th>
											<th>Address</th>
											<th>Contact</th>
											<th>Contact Person</th>
											<th>Bank</th>
											<th>Status</th>
											<th class="text-center">Action</th>
										</tr>
									</thead>
									<tfoot>
										<tr>
											<th>Supplier Name</th>
											<th>Code</th>
											<th>Address</th>
											<th>Contact</th>
											<th>Contact Person</th>
											<th>Bank</th>
											<th>Status</th>
											<th class="text-center">Action</th>
										</tr>
									</tfoot>
									<tbody>
										<?php
											$supplierdata = DB::query("SELECT id, supplier_name, supplier_code, address_line1, address_line2, address_line3, postal_code, city, country, telephone_number, fax, supplier_email, supplier_bank, bank_branch_name, bank_account_code, contact_first_name, contact_last_name, contact_telephone_number, contact_email, supplier_status, version FROM supplier ORDER BY supplier_name, supplier_code");

											if(DB::count() > 0)
											{
												foreach($supplierdata as $row)
												{
													$address = "";
													$contacts = "";
													$contactperson = "";
													$bankdetails = "";
													$status = "";
												
													if(trim($row['address_line1']) != "")
														$address = $address.trim($row['address_line1'])."<br>";
													if(trim($row['address_line2']) != "")
														$address = $address.trim($row['address_line2'])."<br>";
													if(trim($row['address_line3']) != "")
														$address = $address.trim($row['address_line3'])."<br>";
													if(trim($row['postal_code']) != "")
														$address = $address."P.O card ".trim($row['postal_code'])."<br>";
													if(trim($row['city']) != "")
														$address = $address.trim($row['city'])."<br>";
													if(trim($row['country']) != "")
														$address = $address.trim($row['country']);
														
													if(trim($row['contact_first_name']) != "")
														$contactperson = trim($row['contact_first_name']);
														
													if(trim($row['contact_last_name']) != "" && $contactperson != "")
													{
														$contactperson .= ' '.trim($row['contact_last_name']).'<br>';
													}
													elseif(trim($row['contact_last_name']) != "" && $contactperson == "")
													{
														$contactperson .= trim($row['contact_last_name']).'<br>';
													}
													
													if(trim($row['contact_telephone_number']))
														$contactperson .= '<i class="fa fa-earphone"></i>: '.trim($row['contact_telephone_number']).'<br>'; 
													
													if(trim($row['contact_email']) != "")
														$contactperson .= '<i class="fa fa-envelope"></i>: '.trim($row['contact_email']);
													
													if(trim($row['telephone_number']) != "")
														$contacts = $contacts.'<i class="fa fa-earphone"></i>: '.trim($row['telephone_number']).'<br>';
													if(trim($row['fax']) != "")
														$contacts = $contacts.'<i class="fa fa-fax"></i>: '.trim($row['fax']).'<br>';
													if(trim($row['supplier_email']) != "")
														$contacts = $contacts.'<i class="fa fa-envelope"></i>: '.trim($row['supplier_email']).'<br>';
													
													$bankdetails .= "Branch: " . trim($row['bank_branch_name']) . " Bank Account: " . trim($row['bank_account_code']);
														
													if($row['supplier_status'] == 1)
													{
														$status = '<label class="label label-success" >Active</label>';
													}
													else
													{
														$status = '<label class="label label-danger" >Inactive</label>';
													}
										
													$action = '<a href="javascript:void(0);" onclick="gendawano(\'suppliersetup\', \'supplierfocus\', '.$row['id'].')" data-toggle="tooltip" title="Edit Supplier" class="tooltips"><span class="label label-primary" ><i class="fa fa-edit"></i></span></a>';
										?>
										<tr>
											<td style="vertical-align:middle;"><?php echo $row['supplier_name']; ?></td>
											<td style="vertical-align:middle;"><?php echo $row['supplier_code']; ?></td>
											<td style="vertical-align:middle;"><?php echo $address; ?></td>
											<td style="vertical-align:middle;"><?php echo $contacts; ?></td>
											<td style="vertical-align:middle;"><?php echo $contactperson; ?></td>
											<td style="vertical-align:middle;"><a href="javascript:void(0);" data-toggle="tooltip" title="<?php echo $bankdetails; ?>" class="tooltips"><?php echo $row['supplier_bank']; ?></a></td>
											<td style="vertical-align:middle;"><?php echo $status; ?></td>
											<td style="vertical-align:middle;" class="text-center"><?php echo $action; ?></td>
										</tr>
										<?php
												}
											}
										?>
									</tbody>
								</table>
							</div>
						</div><!-- /.card-body -->
						<div class="card-footer">
							
						</div><!-- /.card-footer-->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="mediummodaldetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>

			<?php include ('includes/general_footer.php')?>
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
	</body>
</html>