<?php
	header('Content-Type: application/json');
	include("includes/dbconfig.php");
	
	session_write_close();
	
	$err = "";
	$server_response = array();
	
	$userid = $_POST['userid'];
	$recversion = $_POST['userversion'];

	if(isset($_SESSION['connecteduserid']))
	{
		if($_SESSION["connectedusergroup"] == 1)
		{
			if($userid == "")
			{
				$err = $err."System User Identification Required!<br>";
			}
			else
			{
				$userdata = DB::queryFirstRow("SELECT is_locked FROM personnel_details WHERE id=%i", $userid);
				
				if(DB::count() == 0)
				{
					$err = $err."System User Not Identified!<br>";
				}
				else
				{
					if($userdata['is_locked'] == 0)
						$err = $err."User Account Is Open!<br>";
				}
				
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
	else
	{
		$err = $err."Un Authenticated User Access Detected!<br>";
	}
	
	if($err=="")
	{
		try
		{
			$trxnConnextn = new MeekroDB();
			$nonTrxnConnextn = new MeekroDB();
			
			$trxnConnextn->startTransaction();
			$trxnConnextn->query("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE");
			$trxnConnextn->query("SELECT * FROM personnel_details WHERE id=%i FOR UPDATE", $userid);
			
			$trxnConnextn->update
			('personnel_details',
				array
				(
					'updated_date' => $trxnConnextn->sqleval("current_timestamp()"),
					'updated_by' => $_SESSION['connecteduserid'],
					'is_locked' => 0,
					'version' => ($recversion + 1)
				), 
				"id=%i", $userid
			);
			
			$row = $nonTrxnConnextn->queryFirstRow("SELECT version FROM personnel_details WHERE id=%i LIMIT 1", $userid);
			
			if($row['version'] == $recversion)
			{
				$trxnConnextn->commit();
				$statusmessage = "<div class=\"alert alert-success\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>User Account Successfully Opened.</div>";
				$server_response[] = array('isopen' => 1, 'message' => $statusmessage);
				echo json_encode($server_response);
			}
			else
			{
				$trxnConnextn->rollback();
				$err = "User Account Could Not Be Opened Due To Updates Just Done By Another System User!<br>";
				$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" . $err . "</div>";
				$server_response[] = array('isopen' => 0, 'message' => $errormessage);
				echo json_encode($server_response);
			}
		}
		catch(Exception $e)
		{
			$trxnConnextn->rollback();
			$err = "User Account Has Not Been Opened!<br>";
			$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" . $err . "</div>";
			$server_response[] = array('isopen' => 0, 'message' => $errormessage);
			echo json_encode($server_response);
		}
	}
	else
	{
		$errormessage = "<div class=\"alert alert-danger\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\"aria-hidden=\"true\">&times;</button>" . $err . "</div>";
		$server_response[] = array('isopen' => 0, 'message' => $errormessage);
		echo json_encode($server_response);
	}
?>