<?php
	include("includes/dbconfig.php");
	
	$err= "";
	
	$startdatevalid = false;
	
	if(isset($_SESSION["connectedusergroup"]) && isset($_POST['origin']) && isset($_POST['shop']) && isset($_POST['from']) && isset($_POST['to']) )
	{
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2 || $_SESSION["connectedusergroup"] == 3)
		{
			if($_POST['origin']=="")
				$err = $err."Origin Selection Required!<br>";
			
			if($_POST['shop']=="")
				$err = $err."Destination Selection Required!<br>";
			
			if($_SESSION["connectedusergroup"] == 2 || $_SESSION["connectedusergroup"] == 3)
			{
				if($_POST['origin']!="" && $_POST['shop']!="")
				{
					if($_SESSION["connectedusergroup"] == 2)
					{
						if($_POST['origin']!="x" && $_POST['shop']!="x")
							$err = $err."You Are Not Authorised To Access These Transfers!<br>";
					}
					
					if($_SESSION["connectedusergroup"] == 3)
					{
						if($_POST['origin']!=$_SESSION["connecteduserbranch"] && $_POST['shop']!=$_SESSION["connecteduserbranch"])
							$err = $err."You Are Not Authorised To Access These Transfers!<br>";
					}
				}
			}
			
			if(trim($_POST['from'])=="")
			{
				$err = $err."Start Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['from'], 0, 2);
				$day = substr($_POST['from'], 3, 2);
				$year = substr($_POST['from'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid Start Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d"))
					{
						$err = $err."Future Start Date Not Supported.<br>";
					}
					else
					{
						$startdatevalid = true;
					}
				}
			}
			
			if(trim($_POST['to'])=="")
			{
				$err = $err."End Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['to'], 0, 2);
				$day = substr($_POST['to'], 3, 2);
				$year = substr($_POST['to'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid End Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['to']))) > date("Y-m-d"))
					{
						$err = $err."Future End Date Not Supported.<br>";
					}
					else
					{
						if($startdatevalid)
						{
							if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d", strtotime(trim($_POST['to']))))
							{
								$err = $err."Start Date Can Not Be Greater Than The End Date.<br>";
							}
							else
							{
								if($_POST['origin']!="" && $_POST['shop']!="")
								{
									if($_POST['origin']!=$_POST['shop'])
									{
										if($_POST['origin']=="x" || $_POST['shop']=="x")
										{
											if($_POST['origin']=="x")
											{
												$itemstransferdata = DB::query("SELECT stock_item_movement.value_date, stock_item_movement.goods_transfer_note, stock_item.item_name, stock_item.item_code, stock_item.bar_code, item_batch.batch_code, origin.full_name AS origin, destination.full_name AS destination, stock_item_movement.quantity, stock_item_movement.memo, stock_item_movement.received_quantity, stock_item_movement.is_complete FROM stock_item_movement INNER JOIN stock_item ON stock_item_movement.item = stock_item.id LEFT JOIN item_batch ON stock_item_movement.batch = item_batch.id LEFT JOIN shop origin ON stock_item_movement.origin = origin.id LEFT JOIN shop destination ON stock_item_movement.destination = destination.id WHERE stock_item_movement.origin IS NULL AND stock_item_movement.destination=%i AND stock_item_movement.value_date>=%s AND stock_item_movement.value_date<=%s ORDER BY stock_item_movement.value_date, stock_item_movement.id,stock_item_movement.goods_transfer_note", $_POST['shop'], date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
											}
											else
											{
												$itemstransferdata = DB::query("SELECT stock_item_movement.value_date, stock_item_movement.goods_transfer_note, stock_item.item_name, stock_item.item_code, stock_item.bar_code, item_batch.batch_code, origin.full_name AS origin, destination.full_name AS destination, stock_item_movement.quantity, stock_item_movement.memo, stock_item_movement.received_quantity, stock_item_movement.is_complete FROM stock_item_movement INNER JOIN stock_item ON stock_item_movement.item = stock_item.id LEFT JOIN item_batch ON stock_item_movement.batch = item_batch.id LEFT JOIN shop origin ON stock_item_movement.origin = origin.id LEFT JOIN shop destination ON stock_item_movement.destination = destination.id WHERE stock_item_movement.origin=%i AND stock_item_movement.destination IS NULL AND stock_item_movement.value_date>=%s AND stock_item_movement.value_date<=%s ORDER BY stock_item_movement.value_date, stock_item_movement.id,stock_item_movement.goods_transfer_note", $_POST['origin'], date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
											}
										}
										else
										{
											$itemstransferdata = DB::query("SELECT stock_item_movement.value_date, stock_item_movement.goods_transfer_note, stock_item.item_name, stock_item.item_code, stock_item.bar_code, item_batch.batch_code, origin.full_name AS origin, destination.full_name AS destination, stock_item_movement.quantity, stock_item_movement.memo, stock_item_movement.received_quantity, stock_item_movement.is_complete FROM stock_item_movement INNER JOIN stock_item ON stock_item_movement.item = stock_item.id LEFT JOIN item_batch ON stock_item_movement.batch = item_batch.id LEFT JOIN shop origin ON stock_item_movement.origin = origin.id LEFT JOIN shop destination ON stock_item_movement.destination = destination.id WHERE stock_item_movement.origin=%i AND stock_item_movement.destination=%i AND stock_item_movement.value_date>=%s AND stock_item_movement.value_date<=%s ORDER BY stock_item_movement.value_date, stock_item_movement.id,stock_item_movement.goods_transfer_note", $_POST['origin'], $_POST['shop'], date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
										}
										
										if(DB::count() == 0)
											$err = $err."No Cash Receipts Found!<br>";
										
									}
									else
									{
										$err = $err."Origin And Destination Must Differ!.<br>";
									}
								}
							}
						}
					}
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
	else
	{
		$err = $err."Report Parameters Required!<br>";
	}

?>
<!DOCTYPE html>
<html>
	<head>
	<meta charset="UTF-8">
	<title>Transfer Report</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<!-- Bootstrap 3.3.2 -->
	<link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
	<!-- Font Awesome Icons -->
	<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
	<!-- Ionicons -->
	<link href="http://code.ionicframework.com/ionicons/2.0.0/css/ionicons.min.css" rel="stylesheet" type="text/css" />
	<!-- Theme style -->
	<link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />

	<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
	<!--[if lt IE 9]>
	<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
	<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
	<![endif]-->
	</head>
	<body onload="location.href='transferreportview.php'; window.print();">
		<div class="wrapper">
			<!-- Main content -->
			<section class="content">
				<?php
					if($err == "")
					{
				?>
				
				<h3 class="card-title text-center">Transfer Report From <?php echo ($itemstransferdata[0]['origin']=="") ? "Store" : $itemstransferdata[0]['origin']; ?> To <?php echo ($itemstransferdata[0]['destination']=="") ? "Store" : $itemstransferdata[0]['destination']; ?></h3>
				<h3 class="card-title text-center">From <?php echo date("d-m-Y", strtotime($_POST['from'])); ?> To <?php echo date("d-m-Y", strtotime($_POST['to'])); ?></h3>
				
				<table class="table table-striped" id="receiptstable">
					<thead>
						<tr>
							<th>Date</th>
							<th>Name</th>
							<th>Code</th>
							<th>Barcode</th>
							<th>Ref</th>
							<th>Memo</th>
							<th class="text-right">Sent</th>
							<th class="text-right">Received</th>
							<th class="text-center">Status</th>
						</tr>
					</thead>
					<tbody>
					<?php
						
						foreach($itemstransferdata as $transferrow)
						{
					?>
						<tr>
							<td><?php echo date("d-m-Y", strtotime($transferrow['value_date'])); ?></td>
							<td><?php echo $transferrow['item_name']; ?></td>
							<td><?php echo $transferrow['item_code']; ?></td>
							<td><?php echo ($transferrow['batch_code'] != "") ? $transferrow['batch_code'] : $transferrow['bar_code']; ?></td>
							<td><?php echo $transferrow['goods_transfer_note']; ?></td>
							<td><?php echo $transferrow['memo']; ?></td>
							<td class="text-right"><?php echo number_format($transferrow['quantity'], 2); ?></td>
							<td class="text-right"><?php echo number_format($transferrow['received_quantity'], 2); ?></td>
							<td class="text-center">
								<?php
									if($transferrow['quantity'] == 1)
									{
								?>
								Complete
								<?php
									}
									else
									{
								?>
								Incomplete
								<?php
									}
								?>
							</td>
						</tr>
					<?php
						}
					?>
					</tbody>
				</table>
					<!--</div><!-- /.card-body -->
				<!--</div><!-- /.card -->
				<?php
					}
					else
					{
				?>
				<div class="alert alert-danger alert-dismissable">
					<i class="fa fa-ban-circle"></i><br>
					<?php 
						echo $err; 
					?>
				</div>
				<?php
					}
				?>
			</section><!-- /.content -->
		</div><!-- ./wrapper -->
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js" type="text/javascript"></script>
	</body>
</html>