<?php
	include("includes/dbconfig.php");
	$pagetitle = "Transfer Report View";
	require('includes/applicationtop.php');
	require('includes/applicationmenu.php');
	
	$err= "";
	
	$startdatevalid = false;
	
	if(isset($_POST['gettransfersbtn']))
	{
		if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2 || $_SESSION["connectedusergroup"] == 3)
		{
			if($_POST['origin']=="")
				$err = $err."Origin Selection Required!<br>";
			
			if($_POST['shop']=="")
				$err = $err."Destination Selection Required!<br>";
			
			if($_SESSION["connectedusergroup"] == 2 || $_SESSION["connectedusergroup"] == 3)
			{
				if($_POST['origin']!="" && $_POST['shop']!="")
				{
					if($_SESSION["connectedusergroup"] == 2)
					{
						if($_POST['origin']!="x" && $_POST['shop']!="x")
							$err = $err."You Are Not Authorised To Access These Transfers!<br>";
					}
					
					if($_SESSION["connectedusergroup"] == 3)
					{
						if($_POST['origin']!=$_SESSION["connecteduserbranch"] && $_POST['shop']!=$_SESSION["connecteduserbranch"])
							$err = $err."You Are Not Authorised To Access These Transfers!<br>";
					}
				}
			}
			
			if(trim($_POST['from'])=="")
			{
				$err = $err."Start Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['from'], 0, 2);
				$day = substr($_POST['from'], 3, 2);
				$year = substr($_POST['from'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid Start Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d"))
					{
						$err = $err."Future Start Date Not Supported.<br>";
					}
					else
					{
						$startdatevalid = true;
					}
				}
			}
			
			if(trim($_POST['to'])=="")
			{
				$err = $err."End Date Required!<br>";
			}
			else
			{
				$month = substr($_POST['to'], 0, 2);
				$day = substr($_POST['to'], 3, 2);
				$year = substr($_POST['to'], 6, 4);
				
				if(!checkdate($month, $day, $year))
				{
					$err = $err."Valid End Date Required.<br>";
				}
				else
				{
					if(date("Y-m-d", strtotime(trim($_POST['to']))) > date("Y-m-d"))
					{
						$err = $err."Future End Date Not Supported.<br>";
					}
					else
					{
						if($startdatevalid)
						{
							if(date("Y-m-d", strtotime(trim($_POST['from']))) > date("Y-m-d", strtotime(trim($_POST['to']))))
							{
								$err = $err."Start Date Can Not Be Greater Than The End Date.<br>";
							}
							else
							{
								if($_POST['origin']!="" && $_POST['shop']!="")
								{
									if($_POST['origin']!=$_POST['shop'])
									{
										if($_POST['origin']=="x" || $_POST['shop']=="x")
										{
											if($_POST['origin']=="x")
											{
												$receiptsdata = DB::query("SELECT stock_item_movement.value_date, stock_item_movement.goods_transfer_note, stock_item.item_name, stock_item.item_code, stock_item.bar_code, item_batch.batch_code, origin.full_name AS origin, destination.full_name AS destination, stock_item_movement.quantity, stock_item_movement.memo, stock_item_movement.received_quantity, stock_item_movement.is_complete FROM stock_item_movement INNER JOIN stock_item ON stock_item_movement.item = stock_item.id LEFT JOIN item_batch ON stock_item_movement.batch = item_batch.id LEFT JOIN shop origin ON stock_item_movement.origin = origin.id LEFT JOIN shop destination ON stock_item_movement.destination = destination.id WHERE stock_item_movement.origin IS NULL AND stock_item_movement.destination=%i AND stock_item_movement.value_date>=%s AND stock_item_movement.value_date<=%s ORDER BY stock_item_movement.value_date, stock_item_movement.id,stock_item_movement.goods_transfer_note", $_POST['shop'], date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
											}
											else
											{
												$receiptsdata = DB::query("SELECT stock_item_movement.value_date, stock_item_movement.goods_transfer_note, stock_item.item_name, stock_item.item_code, stock_item.bar_code, item_batch.batch_code, origin.full_name AS origin, destination.full_name AS destination, stock_item_movement.quantity, stock_item_movement.memo, stock_item_movement.received_quantity, stock_item_movement.is_complete FROM stock_item_movement INNER JOIN stock_item ON stock_item_movement.item = stock_item.id LEFT JOIN item_batch ON stock_item_movement.batch = item_batch.id LEFT JOIN shop origin ON stock_item_movement.origin = origin.id LEFT JOIN shop destination ON stock_item_movement.destination = destination.id WHERE stock_item_movement.origin=%i AND stock_item_movement.destination IS NULL AND stock_item_movement.value_date>=%s AND stock_item_movement.value_date<=%s ORDER BY stock_item_movement.value_date, stock_item_movement.id,stock_item_movement.goods_transfer_note", $_POST['origin'], date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
											}
										}
										else
										{
											$receiptsdata = DB::query("SELECT stock_item_movement.value_date, stock_item_movement.goods_transfer_note, stock_item.item_name, stock_item.item_code, stock_item.bar_code, item_batch.batch_code, origin.full_name AS origin, destination.full_name AS destination, stock_item_movement.quantity, stock_item_movement.memo, stock_item_movement.received_quantity, stock_item_movement.is_complete FROM stock_item_movement INNER JOIN stock_item ON stock_item_movement.item = stock_item.id LEFT JOIN item_batch ON stock_item_movement.batch = item_batch.id LEFT JOIN shop origin ON stock_item_movement.origin = origin.id LEFT JOIN shop destination ON stock_item_movement.destination = destination.id WHERE stock_item_movement.origin=%i AND stock_item_movement.destination=%i AND stock_item_movement.value_date>=%s AND stock_item_movement.value_date<=%s ORDER BY stock_item_movement.value_date, stock_item_movement.id,stock_item_movement.goods_transfer_note", $_POST['origin'], $_POST['shop'], date("Y-m-d H:i:s", strtotime(trim($_POST['from'] . " 00:00:00"))), date("Y-m-d H:i:s", strtotime(trim($_POST['to'] . " 23:59:00"))));
										}
										
										if(DB::count() == 0)
											$err = $err."No Cash Receipts Found!<br>";
										
									}
									else
									{
										$err = $err."Origin And Destination Must Differ!.<br>";
									}
								}
							}
						}
					}
				}
			}
		}
		else
		{
			$err = $err."Limited Access!<br>";
		}
	}
?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>Transfer Report View</h1>
					<ol class="breadcrumb">
					</ol>
				</section>

				<!-- Main content -->
				<section class="content">
					<!-- Default card -->
					<div class="card card-primary">
						<?php
							if($_SESSION["connectedusergroup"] == 1 || $_SESSION["connectedusergroup"] == 2 || $_SESSION["connectedusergroup"] == 3)
							{
						?>
						<div class="card-body">
							<div id="servererrormessage">
							</div>
							
							<?php
								if($err!="")
								{
							?>
							<div class="alert alert-danger alert-dismissable">
								<i class="fa fa-ban"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><br>
								<?php 
									echo $err; 
								?>
							</div>
							<?php
								}
							?>
							
							<div class="card card-info">
              <div class="card-header">
                <h3 class="card-title">Transfer Report </h3>
              </div>
              <div class="card-body">
			  <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
									
                <div class="row">
                  <div class="col-3">
                    <label for="origin">Select Origin</label>
											<select  class="form-control" name="origin" id="origin" data-placeholder="Choose One">
												<option value="">Choose One</option>
												<option <?php if(isset($_POST['origin']) && "x"==$_POST['origin']) echo "selected=\"selected\""; ?> value="x">Store</option>
												<?php
													$shopsdata = DB::query("SELECT id, full_name FROM shop");
													
													foreach ($shopsdata as $shoprow)
													{
												?>
												<option <?php if(isset($_POST['origin']) && $shoprow['id']==$_POST['origin']) echo "selected=\"selected\""; ?> value="<?php echo $shoprow['id']; ?>"><?php echo $shoprow['full_name']; ?></option>
												<?php
													}
												?>
											</select>
                  </div>
                  <div class="col-3">
                    <label for="shop">Select Destination</label>
											<select  class="form-control" name="shop" id="shop" data-placeholder="Choose One">
												<option value="">Choose One</option>
												<option <?php if(isset($_POST['shop']) && "x"==$_POST['shop']) echo "selected=\"selected\""; ?> value="x">Store</option>
												<?php
													$shopsdata = DB::query("SELECT id, full_name FROM shop");
													
													foreach ($shopsdata as $shoprow)
													{
												?>
												<option <?php if(isset($_POST['shop']) && $shoprow['id']==$_POST['shop']) echo "selected=\"selected\""; ?> value="<?php echo $shoprow['id']; ?>"><?php echo $shoprow['full_name']; ?></option>
												<?php
													}
												?>
											</select>
                  </div>
                  <div class="col-3">
                   	<label for="from">Start Date</label>
											<input type="text" value="<?php echo isset($_POST['from']) ? $_POST['from'] : "" ?>" name="from" id="from" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
										
                  </div>
				  
				  <div class="form-group col-3">
											<label for="to">End Date</label>
											<div class="input-group">
												<input type="text" value="<?php echo isset($_POST['to']) ? $_POST['to'] : "" ?>" name="to" id="to" class="form-control" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask />
												<span class="input-group-btn">
													<button class="btn btn-primary btn-flat" type="submit" name="gettransfersbtn" id="gettransfersbtn">Go!</button>
												</span>
											</div>
										</div><!-- form-group -->
                </div>
				</form>
				<div class="card-body table-responsive no-padding">
								 
								
								 
								<?php
									if($err=="" && isset($_POST['gettransfersbtn']))
									{
								?>
								<table class="table table-striped table-bordered" id="receiptstable">
									<thead>
										<tr>
											<th>Date</th>
											<th>Name</th>
											<th>Code</th>
											<th>Barcode</th>
											<th>Ref</th>
											<th>Memo</th>
											<th class="text-right">Sent</th>
											<th class="text-right">Received</th>
											<th class="text-center">Status</th>
										</tr>
									</thead>
									<tbody>
									<?php
										
										foreach($receiptsdata as $transferrow)
										{
									?>
										<tr>
											<td><?php echo date("d-m-Y", strtotime($transferrow['value_date'])); ?></td>
											<td><?php echo $transferrow['item_name']; ?></td>
											<td><?php echo $transferrow['item_code']; ?></td>
											<td><?php echo ($transferrow['batch_code'] != "") ? $transferrow['batch_code'] : $transferrow['bar_code']; ?></td>
											<td><?php echo $transferrow['goods_transfer_note']; ?></td>
											<td><?php echo $transferrow['memo']; ?></td>
											<td class="text-right"><?php echo number_format($transferrow['quantity'], 2); ?></td>
											<td class="text-right"><?php echo number_format($transferrow['received_quantity'], 2); ?></td>
											<td class="text-center">
												<?php
													if($transferrow['quantity'] == 1)
													{
												?>
												<label class="label label-success" >Complete</label>
												<?php
													}
													else
													{
												?>
												<label class="label label-warning" >Incomplete</label>
												<?php
													}
												?>
											</td>
										</tr>
									<?php
										}
									?>
									</tbody>
								</table>
								
								<button onclick="printtransferreport('<?php echo $_POST['origin']; ?>', '<?php echo $_POST['shop']; ?>', '<?php echo $_POST['from']; ?>', '<?php echo $_POST['to']; ?>')" class="btn btn-sm btn-primary pull-right"><i class="fa fa-print"></i> Print Report</button>
								<?php
									}
								?>
								 
							</div>
				</div>
              </div>
              <!-- /.card-body -->
            </div>
							
							
						</div><!-- /.card-body -->
						<?php
							}
							else
							{
						?>
						<div class="alert alert-danger alert-dismissable">
							<i class="fa fa-ban-circle"></i><br>
							Limited Access
						</div>
						<?php
							}
						?>
					</div><!-- /.card -->
				</section><!-- /.content -->
			</div><!-- /.content-wrapper -->

			 
		</div><!-- ./wrapper -->
		
		<div class="modal" id="waitdialogmodal"  data-backdrop="static">
            <div class="modal-dialog modal-sm">
              <div class="modal-content">
                  <div class="modal-body">
					<div class="text-center">
						<img src="<?php echo $base_url . $ajax_loading_image; ?>" />
					</div>
				  </div>
              </div>
            </div>
        </div>
		
		<div class="modal" id="mediummodal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="mediummodaldetails">
					
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<div class="modal" id="largemodal">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-body">					
						<div class="row" id="largemodaldetails">
							
						</div>
					</div>
				</div>
			</div>
		</div>

 <?php include ('includes/general_footer.php')?>
		<!-- InputMask -->
		<script src="plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>
		<script src="plugins/input-mask/jquery.inputmask.extensions.js" type="text/javascript"></script>
		 
		<script src="plugins/bert/storepos.js" type="text/javascript"></script>
		<script>
			$(function() 
			{
				//Datemask2 mm/dd/yyyy
				$("#datemask2").inputmask("mm/dd/yyyy", {"placeholder": "mm/dd/yyyy"});
				//Money Euro
				$("[data-mask]").inputmask();

				$("#origin").focus();
				
				printtransferreport = function(origin, shop, from, to)
				{
					var form = $('<form action="transferreport_print.php" method="post">' + '<input type="hidden" name="origin" value="'+origin+'"></input><input type="hidden" name="shop" value="'+shop+'"></input><input type="hidden" name="from" value="'+from+'"></input><input type="hidden" name="to" value="'+to+'"></input></form>');
					$('body').append(form);
					$(form).submit();
				}
			});
		</script>
	</body>
</html>